/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.schematics.SimError;
import ventus.feature.Feature;
import ventus.feature.results.DataNode;
import ventus.feature.results.DataNodeAnimator;
import ventus.feature.results.EventHandler;
import ventus.feature.results.JunctionDataNodeAnimator;
import ventus.feature.results.JunctionSelectionRibbon;
import ventus.feature.results.OpenFileAction;
import ventus.feature.results.PathSelectionResultsTable;
import ventus.feature.results.ResultsDataComp;
import ventus.feature.results.ResultsItemStatusInfoProvider;
import ventus.feature.results.ResultsModelChangeObserver;
import ventus.feature.results.ResultsOISHandler;
import ventus.feature.results.ResultsSceneItem;
import ventus.feature.results.SegmentDataNodeAnimator;
import ventus.feature.results.SegmentSelectionRibbon;
import ventus.feature.results.SelectionRibbon;
import ventus.feature.results.ShowResultsAction;
import ventus.feature.results.ToggleVectorAction;
import ventus.feature.results.ZoneDataNodeAnimator;
import ventus.feature.results.ZoneSelectionResultsTable;
import ventus.feature.results.ZoneSelectionRibbon;
import ventus.gui.guiUtil;

public class ResultsFeature {
    static final Icon icon_resultsFind = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/find.svg"), 16);
    static final Icon icon_resultsFilterEdit = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/filter-more.svg"), 16);
    static final Icon icon_resultsFilterClear = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/filter-cancel.svg"), 16);
    static final Icon icon_resultsFollow = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/filter-by-select.svg"), 16);
    static final Icon icon_resultsFollowTime = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/filter-by-time.svg"), 16);

    public static Feature create() {
        ResultsDataComp dataComp = new ResultsDataComp();
        EntryPointHelper<DataNode.XLogData> xlogHelper = EntryPointHelper.helperEP(DataNode.XLogData.class);
        xlogHelper.getErrors = (vd, xLog) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (xLog.hasErrors()) {
                String error = Intl.intl("Problems were encountered while running CONTAM.");
                String fix = Intl.intl("Inspect the .xlog file to determine the problem.");
                errors.add(new SimError(SimError.Level.CRITICAL, error, fix, List.of(xLog), SimError.Type.RESULTS));
            }
            return errors;
        };
        xlogHelper.register();
        EntryPointHelper<DataNode.StaleLeaf> visleafHelper = EntryPointHelper.helperEP(DataNode.StaleLeaf.class);
        visleafHelper.getErrors = (ventusData, leaf) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (leaf.isStale()) {
                String error = Intl.intl("Results may be out of date due to changes in the Ventus model.");
                String fix = Intl.intl("Run the simulation again to update the results.");
                errors.add(new SimError(SimError.Level.MODERATE, error, fix, List.of(leaf), SimError.Type.RESULTS));
            }
            return errors;
        };
        visleafHelper.register();
        return new Feature(dataComp, new ResultsModelChangeObserver(), new PathSelectionResultsTable(), new ZoneSelectionResultsTable(), new ResultsSceneItem(), new OpenFileAction(), new ToggleVectorAction(), new ShowResultsAction(), new SelectionRibbon(), new ZoneSelectionRibbon(), new JunctionSelectionRibbon(), new SegmentSelectionRibbon(), new ResultsOISHandler(), new EventHandler(dataComp), new DataNodeAnimator(), new ZoneDataNodeAnimator(), new JunctionDataNodeAnimator(), new SegmentDataNodeAnimator(), new ResultsItemStatusInfoProvider());
    }
}

