/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import ventus.feature.ducts.Segment;
import ventus.io.contamx.PrjData;

public class OutputDataReaderSegmentVis {
    public static List<SegmentData> getSegmentResults(PrjData inputData, File prjFile, String extn) {
        ArrayList<SegmentData> zones = new ArrayList<SegmentData>();
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(1);
            for (PrjData.Segment segment : inputData.segmentList) {
                SegmentData data = OutputDataReaderSegmentVis.getSegmentData(segment, connection, stmt);
                if (data == null) continue;
                zones.add(data);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return zones;
    }

    private static SegmentData getSegmentData(PrjData.Segment segment, Connection connection, Statement stmt) throws SQLException {
        Object object = segment.refObj;
        if (object instanceof Segment) {
            Segment segObj = (Segment)object;
            String query = String.format("SELECT T.Time, LDD.dP, LDD.Flow0\nFROM LINKDUCTINFO as LDI\nLEFT JOIN LINKDUCTDATA AS LDD ON LDD.DuctLinkNumber = LDI.DuctLinkNumber\nLEFT JOIN TIME AS T ON LDD.TimeID = T.TimeID\nWHERE LDI.DuctLinkNumber = %1$d AND LDI.Type = 1;\n", segment.nr);
            ArrayList<Double> times = new ArrayList<Double>();
            ArrayList<Double> dps = new ArrayList<Double>();
            ArrayList<Double> flows = new ArrayList<Double>();
            ArrayList<Double> flowDensities = new ArrayList<Double>();
            try (ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    double time = rs.getDouble(1);
                    double dp = rs.getDouble(2);
                    double flow = rs.getDouble(3);
                    double flowDensity = 0.0;
                    int flowJunc = flow >= 0.0 ? segment.pjn : segment.pjm;
                    String juncQuery = String.format("SELECT T.Time, NDF.Density\nFROM NODEDUCTFLOWDATA AS NDF\nLEFT JOIN TIME AS T ON NDF.TimeID = T.TimeID\nWHERE NDF.DuctNodeNumber == %1$d;\n", flowJunc);
                    try (ResultSet rs2 = stmt.executeQuery(juncQuery);){
                        while (rs.next()) {
                            flowDensity = rs2.getDouble(2);
                        }
                    }
                    times.add(time);
                    dps.add(dp);
                    flows.add(flow);
                    flowDensities.add(flowDensity);
                }
            }
            return new SegmentData(segment, segObj.getName(), ArrayUtils.toPrimitive(times.toArray(new Double[0])), ArrayUtils.toPrimitive(dps.toArray(new Double[0])), ArrayUtils.toPrimitive(flows.toArray(new Double[0])), ArrayUtils.toPrimitive(flowDensities.toArray(new Double[0])));
        }
        return null;
    }

    public static class SegmentData {
        public final PrjData.Segment refObj;
        public final String refObjDesc;
        public final double[] times;
        public final double[] dps;
        public final double[] flows;
        public final double[] flowDensities;

        public SegmentData(PrjData.Segment refObj, String refObjDesc, double[] times, double[] dps, double[] flows, double[] flowDensities) {
            this.refObj = refObj;
            this.refObjDesc = refObjDesc;
            this.times = times;
            this.dps = dps;
            this.flows = flows;
            this.flowDensities = flowDensities;
        }
    }
}

