/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import thunderheadeng.geometry.Ray3d;
import ventus.feature.ducts.DuctsUtil;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.io.contamx.PrjData;

public class OutputDataReaderJunctionVis {
    public static List<JunctionData> getJunctionResults(PrjData inputData, File prjFile, String extn) {
        ArrayList<JunctionData> junctions = new ArrayList<JunctionData>();
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(1);
            for (PrjData.Junction junc : inputData.junctionList) {
                JunctionData data = OutputDataReaderJunctionVis.getJunctionData(junc, connection, stmt);
                if (data == null) continue;
                junctions.add(data);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (junctions.isEmpty()) {
            return Collections.emptyList();
        }
        return OutputDataReaderJunctionVis.normalize(junctions);
    }

    private static List<JunctionData> normalize(List<JunctionData> unscaled) {
        double flow0Max = -1.7976931348623157E308;
        for (JunctionData junc : unscaled) {
            for (double flow0 : junc.flows) {
                flow0Max = Math.max(flow0Max, Math.abs(flow0));
            }
        }
        double flow0Scale = flow0Max != 0.0 ? 1.0 / flow0Max : 1.0;
        ArrayList<JunctionData> scaled = new ArrayList<JunctionData>(unscaled.size());
        for (JunctionData juncData : unscaled) {
            scaled.add(new JunctionData(juncData, flow0Scale));
        }
        return scaled;
    }

    private static JunctionData getJunctionData(PrjData.Junction juncPrj, Connection connection, Statement stmt) throws SQLException {
        Object object = juncPrj.refObj;
        if (object instanceof Junction) {
            Junction juncObj = (Junction)object;
            Ray3d baseGeom = OutputDataReaderJunctionVis.getJuncBaseGeom(juncObj);
            boolean isTerminal = juncPrj.jtype != 0;
            String query = isTerminal ? String.format("SELECT T.Time, NDF.Temperature, NDF.Pressure, NDF.Density, LDD.Flow0\nFROM NODEDUCTFLOWDATA AS NDF\nLEFT JOIN LINKDUCTINFO as LDI ON LDI.DuctNumber = NDF.DuctNodeNumber\nLEFT JOIN LINKDUCTDATA AS LDD ON LDD.DuctLinkNumber = LDI.DuctLinkNumber\nLEFT JOIN TIME AS T ON T.TimeID = NDF.TimeID\nWHERE NDF.DuctNodeNumber =  %1$d AND LDI.Type = 2 AND LDD.TimeID = NDF.TimeID;\n", juncPrj.nr, juncPrj.jtype) : String.format("SELECT T.Time, NDF.Temperature, NDF.Pressure, NDF.Density\nFROM NODEDUCTFLOWDATA AS NDF\nLEFT JOIN TIME AS T ON NDF.TimeID = T.TimeID\nWHERE NDF.DuctNodeNumber == %1$d;\n", juncPrj.nr);
            ArrayList<Double> times = new ArrayList<Double>();
            ArrayList<Double> flows = new ArrayList<Double>();
            ArrayList<Double> temperatures = new ArrayList<Double>();
            ArrayList<Double> pressures = new ArrayList<Double>();
            ArrayList<Double> densities = new ArrayList<Double>();
            try (ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    double time = rs.getDouble(1);
                    double temperature = rs.getDouble(2);
                    double pressure = rs.getDouble(3);
                    double density = rs.getDouble(4);
                    double flow = isTerminal ? rs.getDouble(5) : 0.0;
                    times.add(time);
                    flows.add(flow);
                    temperatures.add(temperature);
                    pressures.add(pressure);
                    densities.add(density);
                }
            }
            return new JunctionData(juncPrj, juncObj.getName(), baseGeom, ArrayUtils.toPrimitive(times.toArray(new Double[0])), ArrayUtils.toPrimitive(flows.toArray(new Double[0])), ArrayUtils.toPrimitive(temperatures.toArray(new Double[0])), ArrayUtils.toPrimitive(pressures.toArray(new Double[0])), ArrayUtils.toPrimitive(densities.toArray(new Double[0])));
        }
        return null;
    }

    private static Ray3d getJuncBaseGeom(Junction junc) {
        Point3d juncLoc = junc.getElevatedLocation();
        double len = 1.0;
        Optional<Segment> segQuery = DuctsUtil.getSegmentFromTerminal(junc);
        if (segQuery.isPresent()) {
            Segment segment = segQuery.get();
            Vector3d flowDir = segment.getRelativeFlowDirection(junc);
            return new Ray3d(juncLoc, flowDir, 1.0);
        }
        return new Ray3d(juncLoc, new Vector3d(new double[]{0.0, 0.0, 1.0}), 1.0);
    }

    public static class JunctionData {
        public final PrjData.Junction refObj;
        public final String refObjDesc;
        public final Ray3d baseGeom;
        public final double[] times;
        public final double[] flows;
        public final double[] temperatures;
        public final double[] pressures;
        public final double[] densities;
        public final double scaleFactorFlow;

        public JunctionData(PrjData.Junction refObj, String refObjDesc, Ray3d baseGeom, double[] times, double[] flows, double[] temperatures, double[] pressures, double[] densities) {
            this.refObj = refObj;
            this.refObjDesc = refObjDesc;
            this.baseGeom = baseGeom;
            this.times = times;
            this.flows = flows;
            this.temperatures = temperatures;
            this.pressures = pressures;
            this.densities = densities;
            this.scaleFactorFlow = 1.0;
        }

        public JunctionData(JunctionData original, double flowScale) {
            this.refObj = original.refObj;
            this.refObjDesc = original.refObjDesc;
            this.baseGeom = original.baseGeom;
            this.times = original.times;
            this.flows = original.flows;
            this.temperatures = original.temperatures;
            this.pressures = original.pressures;
            this.densities = original.densities;
            this.scaleFactorFlow = flowScale;
        }
    }
}

