/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import thunderheadeng.animate.DefaultFrameSrc;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.IFrameSrc;
import thunderheadeng.animate.InterpInfo;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

public class JunctionDataNodeAnimator
implements IFeatureAnimator,
IEventObserver,
IAnimator {
    private IFrameSrc<DataNodeFrame> d_frameSrc = new DefaultFrameSrc<DataNodeFrame>();
    private final Set<DataNode.JunctionVisLeaf> d_dataLeaves = new LinkedIdentityHashSet<DataNode.JunctionVisLeaf>();

    @Override
    public void update(Events events) {
        IEventRecord<DataNode.JunctionVisLeaf> leafRecords = events.getEvents(DataNode.JunctionVisLeaf.class, new Class[0]);
        if (leafRecords.hasAddedObjs()) {
            Collection<DataNode.JunctionVisLeaf> visLeaves = ((DataNode.ResultsRoot)VentusApp.getAppData().getComponentData(ResultsDataComp.GUID)).flatten(DataNode.JunctionVisLeaf.class);
            this.d_dataLeaves.addAll(visLeaves);
            this.d_frameSrc = this.createFrameSrc(visLeaves);
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
        if (events.getEvents(DataNode.JunctionVisLeaf.class, new Class[0]).hasRemovedObjs()) {
            this.d_dataLeaves.removeAll(leafRecords.getRemovedObjs());
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
    }

    private IFrameSrc<DataNodeFrame> createFrameSrc(Collection<DataNode.JunctionVisLeaf> leaves) {
        DefaultFrameSrc<DataNodeFrame> frameSrc = new DefaultFrameSrc<DataNodeFrame>();
        for (DataNode.JunctionVisLeaf leaf : leaves) {
            int i = 0;
            while (i < leaf.getTimes().length) {
                int currFrame = i++;
                frameSrc.computeFrame(leaf.getTimes()[currFrame], (time, oldFrame) -> {
                    DataNodeFrame frame = oldFrame == null ? new DataNodeFrame() : oldFrame;
                    frame.add(leaf, new FrameData(leaf.getFlows()[currFrame], leaf.getTemperatures()[currFrame], leaf.getPressures()[currFrame], leaf.getDensities()[currFrame]));
                    return frame;
                });
            }
        }
        return frameSrc;
    }

    @Override
    public boolean update(IAnimSession session) {
        VentusApp.getAppData().pauseUpdates();
        double time = session.get(IAnimSession.TIME);
        InterpInfo<DataNodeFrame> ii = this.d_frameSrc.getFrames(time);
        for (DataNode.JunctionVisLeaf leaf : this.d_dataLeaves) {
            FrameData frame1Data = ii.frame1().getData(leaf);
            FrameData frame2Data = ii.frame2().getData(leaf);
            leaf.setAnimationData(frame1Data.flow, theUtil.lerp(frame1Data.flow, frame2Data.flow, ii.interpT()), frame1Data.temperature, frame1Data.pressure, frame1Data.density);
        }
        VentusApp.getAppData().resumeUpdates();
        return true;
    }

    @Override
    public Pair<Double, Double> getTimeRange() {
        if (this.d_dataLeaves.isEmpty()) {
            return new Pair<Double, Double>(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return this.d_frameSrc.getTimeRange();
    }

    private static class DataNodeFrame {
        private final Map<DataNode.JunctionVisLeaf, FrameData> d_vals = new IdentityHashMap<DataNode.JunctionVisLeaf, FrameData>();

        private DataNodeFrame() {
        }

        public FrameData getData(DataNode.JunctionVisLeaf leaf) {
            return this.d_vals.get(leaf);
        }

        public void add(DataNode.JunctionVisLeaf leaf, FrameData val) {
            this.d_vals.put(leaf, val);
        }
    }

    private record FrameData(double flow, double temperature, double pressure, double density) {
    }
}

