/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.props.PropertyDefs;
import ventus.feature.results.DataTable;
import ventus.feature.results.NodeProps;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.io.contamx.PrjData;

public interface DataNode
extends IMerlinObj {
    public static UnitDouble calculateAirflowVelocity(UnitDouble massFlow, UnitDouble density, UnitDouble area) {
        UnitDouble volumeFlow = massFlow.divide(density);
        return volumeFlow.divide(area);
    }

    public static class SegmentVisLeaf
    extends NamedMerlinObj
    implements DataNode,
    StaleLeaf {
        private static final long serialVersionUID = 1L;
        private static final Color COLOR_DP = Color.MAGENTA;
        private static final Color COLOR_FLOW0 = Color.GREEN;
        public static final PropertyDefs<SegmentVisLeaf> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(SegmentVisLeaf.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), NamedMerlinObj.PROP_TYPES);
        public static final TypedProp<Boolean> IS_VISIBLE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(SegmentVisLeaf::isVisible, IS_VISIBLE).attrSetter(SegmentVisLeaf::setVisible, null).attrUndoPropRestore(false, IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> IS_STALE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_STALE).attrFinish();
        public static final DisplayProp<String> SIMULATION_NAME = PROP_TYPES.storeAsReadOnly(NodeProps.SIMULATION_NAME).attrGetter(SegmentVisLeaf::getSimulationName, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> DP = PROP_TYPES.storeAsReadOnly(NodeProps.DP).attrGetter(SegmentVisLeaf::getPressure, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> FLOW0 = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0).attrGetter(SegmentVisLeaf::getFlow, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> DENSITY = PROP_TYPES.storeAsReadOnly(NodeProps.DENSITY).attrGetter(SegmentVisLeaf::getFlowDensity, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> VELOCITY = PROP_TYPES.storeAsReadOnly(NodeProps.VELOCITY).attrGetter(SegmentVisLeaf::getVelocity, Stream.empty()).attrFinish();
        private final double[] d_times;
        private final double[] d_dps;
        private final double[] d_flows;
        private final double[] d_flowDensities;
        private final Unit d_dpUnit;
        private transient double d_dp;
        private transient double d_dpInterp;
        private final Unit d_flowUnit;
        private transient double d_flow;
        private transient double d_flowInterp;
        private final Unit d_densityUnit;
        private transient double d_flowDensity;
        private IPropertySet d_props = new PropertySet();

        public SegmentVisLeaf(String name, double[] times, double[] dps, double[] flows, double[] flowDensities, Unit dpUnit, Unit flowUnit, Unit densityUnit) {
            super(name);
            this.set(IS_VISIBLE, false);
            this.set(IS_STALE, false);
            this.d_times = times;
            this.d_dps = dps;
            this.d_dpUnit = dpUnit;
            this.d_flows = flows;
            this.d_flowUnit = flowUnit;
            this.d_flowDensities = flowDensities;
            this.d_densityUnit = densityUnit;
            this.d_dpInterp = this.d_dp = dps[0];
            this.d_flowInterp = this.d_flow = flows[0];
            this.d_flowDensity = flowDensities[0];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.d_dpInterp = this.d_dp = this.d_dps[0];
            this.d_flowInterp = this.d_flow = this.d_flows[0];
            this.d_flowDensity = this.d_flowDensities[0];
        }

        public UnitDouble getFlow() {
            return new UnitDouble(this.d_flow, this.d_flowUnit);
        }

        public UnitDouble getPressure() {
            return new UnitDouble(this.d_dp, this.d_dpUnit);
        }

        public UnitDouble getFlowDensity() {
            return new UnitDouble(this.d_flowDensity, this.d_densityUnit);
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getFlows() {
            return this.d_flows;
        }

        public double[] getPressures() {
            return this.d_dps;
        }

        public double[] getFlowDensities() {
            return this.d_flowDensities;
        }

        public UnitDouble getVelocity() {
            Object seg = this.getCorrespondingSegment();
            assert (seg instanceof Segment);
            UnitDouble area = ((Segment)seg).get(Segment.ELEMENT).getDuctGeomArea();
            return DataNode.calculateAirflowVelocity(this.getFlow(), this.getFlowDensity(), area);
        }

        @Override
        public boolean isStale() {
            return this.get(IS_STALE);
        }

        @Override
        public void setStale(boolean stale) {
            this.set(IS_STALE, stale);
        }

        public boolean isVisible() {
            return this.get(IS_VISIBLE);
        }

        public void setVisible(boolean visible) {
            this.set(IS_VISIBLE, visible);
        }

        public PropertyDefs<SegmentVisLeaf> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public SegmentVisLeaf clone() {
            return (SegmentVisLeaf)super.clone();
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public Object getCorrespondingSegment() {
            return this.getParentObject(DuctVisRoot.class).map(visRoot -> visRoot.findCorrespondingDuctObject(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }

        public void setAnimationData(double flow, double flowInterp, double dp, double dpInterp, double flowDensity) {
            this.d_flow = flow;
            this.d_flowInterp = flowInterp;
            this.d_dp = dp;
            this.d_dpInterp = dpInterp;
            this.d_flowDensity = flowDensity;
        }
    }

    public static class JunctionVisLeaf
    extends SceneLeaf
    implements DataNode,
    StaleLeaf {
        private static final long serialVersionUID = 1L;
        private static final Color COLOR_FLOW = Color.GREEN;
        public static final PropertyDefs<JunctionVisLeaf> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(JunctionVisLeaf.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), NamedMerlinObj.PROP_TYPES);
        public static final TypedProp<Boolean> IS_VISIBLE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(JunctionVisLeaf::isVisible, IS_VISIBLE).attrSetter(JunctionVisLeaf::setVisible, null).attrUndoPropRestore(false, IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> IS_STALE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_STALE).attrFinish();
        public static final DisplayProp<String> SIMULATION_NAME = PROP_TYPES.storeAsReadOnly(NodeProps.SIMULATION_NAME).attrGetter(JunctionVisLeaf::getSimulationName, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> FLOW = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0).attrGetter(JunctionVisLeaf::getFlow, Stream.empty()).attrFinish();
        public static final TypedProp<Point3d> FLOW_ROOT = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0_ROOT).attrGetter(leaf -> leaf.d_flowRoot, Stream.empty()).attrFinish();
        public static final TypedProp<Vector3d> FLOW_DIR = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0_DIR).attrGetter(leaf -> leaf.d_flowDir, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> TEMPERATURE = PROP_TYPES.storeAsReadOnly(NodeProps.TEMPERATURE).attrGetter(JunctionVisLeaf::getTemperature, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> PRESSURE = PROP_TYPES.storeAsReadOnly(NodeProps.PRESSURE).attrGetter(JunctionVisLeaf::getPressure, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> DENSITY = PROP_TYPES.storeAsReadOnly(NodeProps.DENSITY).attrGetter(JunctionVisLeaf::getDensity, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> VELOCITY = PROP_TYPES.storeAsReadOnly(NodeProps.VELOCITY).attrGetter(JunctionVisLeaf::getVelocity, Stream.empty()).attrFinish();
        public static final TypedProp<Boolean> IS_TERMINAL = TypedProps.build((Object)"output.isTerminal", false).attrStoreAsReadOnly(PROP_TYPES).attrGetter(JunctionVisLeaf::isTerminal, Stream.empty()).attrFinish();
        private final double[] d_times;
        private final double[] d_flows;
        private final double[] d_temperatures;
        private final double[] d_pressures;
        private final double[] d_densities;
        private final Unit d_flowUnit;
        private final Unit d_velocityUnit;
        private final Unit d_temperatureUnit;
        private final Unit d_pressureUnit;
        private final Unit d_densityUnit;
        private transient double d_flow;
        private transient double d_flowInterp;
        private Point3d d_flowRoot;
        private Vector3d d_flowDir;
        private transient double d_temperature;
        private transient double d_pressure;
        private transient double d_density;
        private IPropertySet d_props = new PropertySet();

        public JunctionVisLeaf(String name, double[] times, double[] flows, double[] temperatures, double[] pressures, double[] densities, Unit flowUnit, Unit velocityUnit, Unit tempUnit, Unit presUnit, Unit densUnit, Point3d flowRoot, Vector3d flowDir) {
            super(name);
            this.set(IS_VISIBLE, false);
            this.set(IS_STALE, false);
            this.d_times = times;
            this.d_flows = flows;
            this.d_temperatures = temperatures;
            this.d_pressures = pressures;
            this.d_densities = densities;
            this.d_flowUnit = flowUnit;
            this.d_velocityUnit = velocityUnit;
            this.d_temperatureUnit = tempUnit;
            this.d_pressureUnit = presUnit;
            this.d_densityUnit = densUnit;
            this.d_flowRoot = flowRoot;
            this.d_flowDir = flowDir;
            this.d_flowInterp = this.d_flow = flows[0];
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.d_flowInterp = this.d_flow = this.d_flows[0];
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getFlows() {
            return this.d_flows;
        }

        public double[] getTemperatures() {
            return this.d_temperatures;
        }

        public double[] getPressures() {
            return this.d_pressures;
        }

        public double[] getDensities() {
            return this.d_densities;
        }

        public UnitDouble getFlow() {
            return new UnitDouble(this.d_flow, this.d_flowUnit);
        }

        public UnitDouble getTemperature() {
            return new UnitDouble(this.d_temperature, this.d_temperatureUnit);
        }

        public UnitDouble getPressure() {
            return new UnitDouble(this.d_pressure, this.d_pressureUnit);
        }

        public UnitDouble getDensity() {
            return new UnitDouble(this.d_density, this.d_densityUnit);
        }

        public UnitDouble getVelocity() {
            Object junc = this.getCorrespondingJunction();
            assert (junc instanceof Junction);
            return DataNode.calculateAirflowVelocity(this.getFlow(), this.getDensity(), ((Junction)junc).get(Junction.FREE_FACE_AREA));
        }

        public boolean isTerminal() {
            Object junc = this.getCorrespondingJunction();
            assert (junc instanceof Junction);
            return ((Junction)junc).getJunctionType() != Junction.JunctionType.JUNCTION;
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public UnitDouble getElevation() {
            return new UnitDouble(this.get(JunctionVisLeaf.FLOW_ROOT).z, Geometry.LENGTH_UNIT);
        }

        @Override
        public boolean isStale() {
            return this.get(IS_STALE);
        }

        @Override
        public void setStale(boolean stale) {
            this.set(IS_STALE, stale);
        }

        @Override
        public boolean isVisible() {
            return this.get(IS_VISIBLE);
        }

        @Override
        public void setVisible(boolean visible) {
            this.set(IS_VISIBLE, visible);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            PropsBuilder pb = new PropsBuilder();
            pb.add(new IPrimProps.Edge(COLOR_FLOW, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            return new DisplayGeom(this.getGeom(), pb);
        }

        public PropertyDefs<JunctionVisLeaf> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public JunctionVisLeaf clone() {
            return (JunctionVisLeaf)super.clone();
        }

        @Override
        public void setGeom(IGeomNode geom) {
        }

        @Override
        public IGeomNode getGeom() {
            double offset = this.d_flowInterp < 0.0 ? 0.07 : 0.0;
            double lengthMult = 2.5;
            Point3d a = new Point3d(this.d_flowRoot.x, this.d_flowRoot.y, this.d_flowRoot.z + offset);
            Vector3d dir = new Vector3d(this.d_flowDir);
            dir.scale(2.5);
            dir.scale(this.d_flowInterp);
            Point3d b = Util3D.linePoint(a, dir, 1.0);
            LineSeg flow = new LineSeg(a, b);
            IGeom geom = GeomUtil.group(flow);
            return GeomNodeUtil.newNode(geom);
        }

        public Object getCorrespondingJunction() {
            return this.getParentObject(DuctVisRoot.class).map(visRoot -> visRoot.findCorrespondingDuctObject(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }

        public void setAnimationData(double flow, double flowInterp, double temperature, double pressure, double density) {
            this.d_flow = flow;
            this.d_flowInterp = flowInterp;
            this.d_temperature = temperature;
            this.d_pressure = pressure;
            this.d_density = density;
            this.changedEvt(NodeProps.FLOW0, NodeProps.TEMPERATURE, NodeProps.PRESSURE, NodeProps.DENSITY);
        }
    }

    public static class DuctVisRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final BidiMap<Object, DataNode> d_visLeafMap = new DualHashBidiMap<Object, DataNode>();

        public DuctVisRoot(String name) {
            super(name);
        }

        public void addLeaf(Object obj, DataNode leaf) {
            this.d_visLeafMap.put(obj, leaf);
            this.add(leaf);
        }

        public DataNode findCorrespondingLeaf(Object obj) {
            return (DataNode)this.d_visLeafMap.get(obj);
        }

        public Object findCorrespondingDuctObject(DataNode leaf) {
            return this.d_visLeafMap.getKey(leaf);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.d_visLeafMap == null) {
                try {
                    theUtil.assignFinalField(this, DuctVisRoot.class, "d_visLeafMap", new DualHashBidiMap());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
        }
    }

    public static class ZoneVisLeaf
    extends NamedMerlinObj
    implements DataNode,
    StaleLeaf {
        private static final long serialVersionUID = 1L;
        public static final PropertyDefs<ZoneVisLeaf> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(ZoneVisLeaf.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), NamedMerlinObj.PROP_TYPES);
        public static final TypedProp<Boolean> IS_VISIBLE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(ZoneVisLeaf::isVisible, IS_VISIBLE).attrSetter(ZoneVisLeaf::setVisible, null).attrUndoPropRestore(false, IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> IS_STALE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_STALE).attrFinish();
        public static final DisplayProp<String> SIMULATION_NAME = PROP_TYPES.storeAsReadOnly(NodeProps.SIMULATION_NAME).attrGetter(ZoneVisLeaf::getSimulationName, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> TEMPERATURE = PROP_TYPES.storeAsReadOnly(NodeProps.TEMPERATURE).attrGetter(ZoneVisLeaf::getTemperature, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> PRESSURE = PROP_TYPES.storeAsReadOnly(NodeProps.PRESSURE).attrGetter(ZoneVisLeaf::getPressure, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> DENSITY = PROP_TYPES.storeAsReadOnly(NodeProps.DENSITY).attrGetter(ZoneVisLeaf::getDensity, Stream.empty()).attrFinish();
        public static final TypedProp<Map<String, Double>> CONCENTRATIONS = PROP_TYPES.storeAsReadOnly(NodeProps.CONCENTRATIONS).attrGetter(zone -> zone.d_concentration, Stream.empty()).attrFinish();
        private final double[] d_times;
        private final double[] d_temperatures;
        private final double[] d_pressures;
        private final double[] d_densities;
        private final Map<String, double[]> d_concentrations;
        private final Unit d_temperatureUnit;
        private final Unit d_pressureUnit;
        private final Unit d_densityUnit;
        private IPropertySet d_props = new PropertySet();
        private transient double d_temperature;
        private transient double d_pressure;
        private transient double d_density;
        private transient Map<String, Double> d_concentration;

        public ZoneVisLeaf(String name, double[] times, Unit temperatureUnit, double[] temperatures, Unit pressureUnit, double[] pressures, Unit densityUnit, double[] densities, Map<String, double[]> concentrations) {
            super(name);
            this.set(IS_VISIBLE, false);
            this.set(IS_STALE, false);
            this.d_times = times;
            this.d_temperatures = temperatures;
            this.d_pressures = pressures;
            this.d_densities = densities;
            this.d_concentrations = concentrations;
            this.d_temperatureUnit = temperatureUnit;
            this.d_pressureUnit = pressureUnit;
            this.d_densityUnit = densityUnit;
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
            this.d_concentration = new HashMap<String, Double>();
            for (Map.Entry<String, double[]> concentration : this.d_concentrations.entrySet()) {
                this.d_concentration.put(concentration.getKey(), concentration.getValue()[0]);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
            this.d_concentration = new HashMap<String, Double>();
            for (Map.Entry<String, double[]> concentration : this.d_concentrations.entrySet()) {
                this.d_concentration.put(concentration.getKey(), concentration.getValue()[0]);
            }
            if (this.d_temperatureUnit.equals(SI.CELSIUS)) {
                try {
                    theUtil.assignFinalField(this, ZoneVisLeaf.class, "d_temperatureUnit", SI.KELVIN);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException(e.getCause());
                }
            }
        }

        @Override
        public boolean isStale() {
            return this.get(IS_STALE);
        }

        @Override
        public void setStale(boolean stale) {
            this.set(IS_STALE, stale);
        }

        public boolean isVisible() {
            return this.get(IS_VISIBLE);
        }

        public void setVisible(boolean visible) {
            this.set(IS_VISIBLE, visible);
        }

        public PropertyDefs<ZoneVisLeaf> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public ZoneVisLeaf clone() {
            return (ZoneVisLeaf)super.clone();
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getTemperatures() {
            return this.d_temperatures;
        }

        public double[] getPressures() {
            return this.d_pressures;
        }

        public double[] getDensities() {
            return this.d_densities;
        }

        public Set<String> getConcentrationKeys() {
            return this.d_concentrations.keySet();
        }

        public double[] getConcentrations(String key) {
            return this.d_concentrations.get(key);
        }

        public UnitDouble getTemperature() {
            return new UnitDouble(this.d_temperature, this.d_temperatureUnit);
        }

        public UnitDouble getPressure() {
            return new UnitDouble(this.d_pressure, this.d_pressureUnit);
        }

        public UnitDouble getDensity() {
            return new UnitDouble(this.d_density, this.d_densityUnit);
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public Object getCorrespondingRoom() {
            return this.getParentObject(ZoneVisRoot.class).map(visRoot -> visRoot.findCorrespondingRoom(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }

        public void setAnimationData(double temperature, double pressure, double density) {
            if (this.d_temperature == temperature && this.d_pressure == pressure && this.d_density == density) {
                return;
            }
            this.d_temperature = temperature;
            this.d_pressure = pressure;
            this.d_density = density;
            this.changedEvt(NodeProps.TEMPERATURE, NodeProps.PRESSURE, NodeProps.DENSITY);
        }
    }

    public static class ZoneVisRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final BidiMap<Object, ZoneVisLeaf> d_visLeafMap = new DualHashBidiMap<Object, ZoneVisLeaf>();

        public ZoneVisRoot(String name) {
            super(name);
        }

        public void addLeaf(SchematicRoom room, ZoneVisLeaf leaf) {
            this.d_visLeafMap.put(room, leaf);
            this.add(leaf);
        }

        public ZoneVisLeaf findCorrespondingLeaf(Object room) {
            return (ZoneVisLeaf)this.d_visLeafMap.get(room);
        }

        public Object findCorrespondingRoom(ZoneVisLeaf leaf) {
            return this.d_visLeafMap.getKey(leaf);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.d_visLeafMap == null) {
                try {
                    theUtil.assignFinalField(this, ZoneVisRoot.class, "d_visLeafMap", new DualHashBidiMap());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
        }
    }

    public static class VisLeaf
    extends SceneLeaf
    implements DataNode,
    StaleLeaf {
        private static final long serialVersionUID = 1L;
        private static final Color COLOR_DP = Color.MAGENTA;
        private static final Color COLOR_FLOW0 = Color.GREEN;
        private static final Color COLOR_FLOW1 = new Color(99, 130, 85);
        public static final PropertyDefs<VisLeaf> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(VisLeaf.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), NamedMerlinObj.PROP_TYPES);
        public static final TypedProp<Boolean> IS_VISIBLE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(VisLeaf::isVisible, IS_VISIBLE).attrSetter(VisLeaf::setVisible, null).attrUndoPropRestore(false, IS_VISIBLE).attrFinish();
        public static final DisplayProp<Boolean> IS_STALE = PROP_TYPES.storeAsPlainOldData(NodeProps.IS_STALE).attrFinish();
        public static final DisplayProp<String> SIMULATION_NAME = PROP_TYPES.storeAsReadOnly(NodeProps.SIMULATION_NAME).attrGetter(VisLeaf::getSimulationName, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> DP = PROP_TYPES.storeAsReadOnly(NodeProps.DP).attrGetter(VisLeaf::getDifferentialPressure, Stream.empty()).attrFinish();
        public static final TypedProp<Point3d> DP_ROOT = PROP_TYPES.storeAsReadOnly(NodeProps.DP_ROOT).attrGetter(leaf -> leaf.d_dpRoot, Stream.empty()).attrFinish();
        public static final TypedProp<Vector3d> DP_DIR = PROP_TYPES.storeAsReadOnly(NodeProps.DP_DIR).attrGetter(leaf -> leaf.d_dpDir, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> FLOW0 = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0).attrGetter(VisLeaf::getPrimaryFlow, Stream.empty()).attrFinish();
        public static final TypedProp<Point3d> FLOW0_ROOT = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0_ROOT).attrGetter(leaf -> leaf.d_flow0Root, Stream.empty()).attrFinish();
        public static final TypedProp<Vector3d> FLOW0_DIR = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW0_DIR).attrGetter(leaf -> leaf.d_flow0Dir, Stream.empty()).attrFinish();
        public static final DisplayProp<UnitDouble> FLOW1 = PROP_TYPES.storeAsReadOnly(NodeProps.FLOW1).attrGetter(VisLeaf::getSecondaryFlow, Stream.empty()).attrFinish();
        private final double[] d_times;
        private final double[] d_dps;
        private final double[] d_flow0s;
        private final double[] d_flow1s;
        private final Unit d_dpUnit;
        private transient double d_dp;
        private transient double d_dpInterp;
        private Point3d d_dpRoot;
        private Vector3d d_dpDir;
        private final Unit d_flow0Unit;
        private transient double d_flow0;
        private transient double d_flow0Interp;
        private Point3d d_flow0Root;
        private Vector3d d_flow0Dir;
        private transient double d_flow1;
        private transient double d_flow1Interp;
        private IPropertySet d_props = new PropertySet();

        public VisLeaf(String name, double[] times, double[] dps, double[] flow0s, double[] flow1s, Unit dpUnit, Point3d dpRoot, Vector3d dpDir, Unit flow0Unit, Point3d flow0Root, Vector3d flow0Dir) {
            super(name);
            this.set(IS_VISIBLE, false);
            this.set(IS_STALE, false);
            this.d_times = times;
            this.d_dps = dps;
            this.d_flow0s = flow0s;
            this.d_flow1s = flow1s;
            this.d_dpInterp = this.d_dp = dps[0];
            this.d_dpUnit = dpUnit;
            this.d_dpRoot = dpRoot;
            this.d_dpDir = dpDir;
            this.d_flow0Interp = this.d_flow0 = flow0s[0];
            this.d_flow0Unit = flow0Unit;
            this.d_flow0Root = flow0Root;
            this.d_flow0Dir = flow0Dir;
            this.d_flow1Interp = this.d_flow1 = flow1s[0];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_times == null) {
                try {
                    UnitDouble dp = this.d_props.get(NodeProps.DP);
                    Point3d dpRoot = this.d_props.get(NodeProps.DP_ROOT);
                    Vector3d dpDir = this.d_props.get(NodeProps.DP_DIR);
                    UnitDouble flow0 = this.d_props.get(NodeProps.FLOW0);
                    Point3d flow0Root = this.d_props.get(NodeProps.FLOW0_ROOT);
                    Vector3d flow0Dir = this.d_props.get(NodeProps.FLOW0_DIR);
                    UnitDouble flow1 = this.d_props.get(NodeProps.FLOW1);
                    this.d_props.remove(NodeProps.DP);
                    this.d_props.remove(NodeProps.DP_ROOT);
                    this.d_props.remove(NodeProps.DP_DIR);
                    this.d_props.remove(NodeProps.FLOW0);
                    this.d_props.remove(NodeProps.FLOW0_ROOT);
                    this.d_props.remove(NodeProps.FLOW0_DIR);
                    this.d_props.remove(NodeProps.FLOW1);
                    theUtil.assignFinalField(this, VisLeaf.class, "d_dpUnit", dp.getUnit());
                    this.d_dpRoot = dpRoot;
                    this.d_dpDir = Util3D.scale(dpDir, 1.0 / dp.getRawValue());
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow0Unit", flow0.getUnit());
                    this.d_flow0Root = flow0Root;
                    this.d_flow0Dir = Util3D.scale(flow0Dir, 1.0 / flow0.getRawValue());
                    theUtil.assignFinalField(this, VisLeaf.class, "d_times", new double[]{0.0});
                    theUtil.assignFinalField(this, VisLeaf.class, "d_dps", new double[]{dp.getRawValue()});
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow0s", new double[]{flow0.getRawValue()});
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow1s", new double[]{flow1.getRawValue()});
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException(e.getCause());
                }
            }
            if (this.d_flow1s == null) {
                UnitDouble flow1 = this.d_props.get(NodeProps.FLOW1);
                try {
                    double[] emptyF1s = new double[this.d_flow0s.length];
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow1s", emptyF1s);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException(e.getCause());
                }
            }
            this.d_dpInterp = this.d_dp = this.d_dps[0];
            this.d_flow0Interp = this.d_flow0 = this.d_flow0s[0];
            this.d_flow1Interp = this.d_flow1 = this.d_flow1s[0];
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            PropsBuilder pb = new PropsBuilder();
            pb.add(new IPrimProps.Edge(COLOR_DP, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            pb.add(new IPrimProps.Edge(COLOR_FLOW0, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            pb.add(new IPrimProps.Edge(COLOR_FLOW1, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            return new DisplayGeom(this.getGeom(), pb);
        }

        public UnitDouble getPrimaryFlow() {
            return new UnitDouble(this.d_flow0, this.d_flow0Unit);
        }

        public UnitDouble getSecondaryFlow() {
            return new UnitDouble(this.d_flow1, this.d_flow0Unit);
        }

        public UnitDouble getDifferentialPressure() {
            return new UnitDouble(this.d_dp, this.d_dpUnit);
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getDifferentialPressures() {
            return this.d_dps;
        }

        public double[] getPrimaryFlows() {
            return this.d_flow0s;
        }

        public double[] getSecondaryFlows() {
            return this.d_flow1s;
        }

        public UnitDouble getElevation() {
            return new UnitDouble(this.get(VisLeaf.DP_ROOT).z, Geometry.LENGTH_UNIT);
        }

        @Override
        public boolean isStale() {
            return this.get(IS_STALE);
        }

        @Override
        public void setStale(boolean stale) {
            this.set(IS_STALE, stale);
        }

        @Override
        public boolean isVisible() {
            return this.get(IS_VISIBLE);
        }

        @Override
        public void setVisible(boolean visible) {
            this.set(IS_VISIBLE, visible);
        }

        @Override
        public void setGeom(IGeomNode geom) {
        }

        @Override
        public IGeomNode getGeom() {
            double offset = 0.05;
            double lengthMult = 2.5;
            Point3d a = new Point3d(this.d_dpRoot);
            Vector3d dir = new Vector3d(this.d_dpDir);
            dir.scale(2.5);
            dir.scale(this.d_dpInterp);
            Point3d b = Util3D.linePoint(a, dir, 1.0);
            this.offset(1.5707963267948966, 0.05, a, b);
            LineSeg dp = new LineSeg(a, b);
            a = new Point3d(this.d_flow0Root);
            dir = new Vector3d(this.d_flow0Dir);
            dir.scale(2.5);
            dir.scale(this.d_flow0Interp);
            b = Util3D.linePoint(a, dir, 1.0);
            this.offset(-1.5707963267948966, 0.05, a, b);
            LineSeg flow0 = new LineSeg(a, b);
            a = new Point3d(this.d_flow0Root);
            dir = new Vector3d(this.d_flow0Dir);
            dir.scale(2.5);
            dir.scale(this.d_flow1Interp);
            b = Util3D.linePoint(a, dir, 1.0);
            this.offset(-1.5707963267948966, -0.05, a, b);
            LineSeg flow1 = new LineSeg(a, b);
            IGeom geom = GeomUtil.group(dp, flow0, flow1);
            return GeomNodeUtil.newNode(geom);
        }

        private void offset(double angle, double distMeters, Point3d a, Point3d b) {
            Vector3d v = Util3D.vector(a, b);
            if (Util3D.safeNormalize(v, 0.0) == 0.0) {
                return;
            }
            v = Util3D.rotate(v, Util3D.VEC3D_ZPOS, angle);
            v.scale(distMeters);
            a.add(v);
            b.add(v);
        }

        public PropertyDefs<VisLeaf> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public VisLeaf clone() {
            return (VisLeaf)super.clone();
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public Object getCorrespondingFlowpath() {
            return this.getParentObject(VisRoot.class).map(visRoot -> visRoot.findCorrespondingFlowpath(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }

        public void setAnimationData(double dp, double dpInterp, double flow0, double flow0Interp, double flow1, double flow1Interp) {
            this.d_dp = dp;
            this.d_dpInterp = dpInterp;
            this.d_flow0 = flow0;
            this.d_flow0Interp = flow0Interp;
            this.d_flow1 = flow1;
            this.d_flow1Interp = flow1Interp;
            this.changedEvt(NodeProps.DP, NodeProps.FLOW0, NodeProps.FLOW1);
        }
    }

    public static class VisRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final BidiMap<Object, VisLeaf> d_visLeafMap = new DualHashBidiMap<Object, VisLeaf>();

        public VisRoot(String name) {
            super(name);
        }

        public void addLeaf(FlowPath path, VisLeaf leaf) {
            this.d_visLeafMap.put(path, leaf);
            this.add(leaf);
        }

        public VisLeaf findCorrespondingLeaf(Object flowpath) {
            return (VisLeaf)this.d_visLeafMap.get(flowpath);
        }

        public Object findCorrespondingFlowpath(VisLeaf leaf) {
            return this.d_visLeafMap.getKey(leaf);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.d_visLeafMap == null) {
                try {
                    theUtil.assignFinalField(this, VisRoot.class, "d_visLeafMap", new DualHashBidiMap());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
            if (this.getName().equals(Intl.intl("Vector Data"))) {
                this.setName(Intl.intl("Path Data"));
            }
        }
    }

    public static class MergedData
    extends NamedMerlinObj
    implements DataNode {
        private static final long serialVersionUID = 1L;
        public static final PropertyDefs<MergedData> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(MergedData.class, PropertyDefs.none(), NamedMerlinObj.PROP_TYPES);
        public static final TypedProp<DataTable> DATA_TABLE = PROP_TYPES.storeAsReadOnly(NodeProps.DATA_TABLE).attrGetter(MergedData::getData, Stream.empty()).attrFinish();
        private DataTable d_table;

        public MergedData(String name) {
            super(name);
            this.reset();
        }

        public void reset() {
            this.d_table = DataTable.EMPTY;
            this.changedEvt(DATA_TABLE);
        }

        public void appendData(DataTable dt) {
            this.d_table = this.d_table.append(dt);
            this.changedEvt(DATA_TABLE);
        }

        public DataTable getData() {
            return this.d_table;
        }

        public PropertyDefs<MergedData> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public MergedData clone() {
            return (MergedData)super.clone();
        }
    }

    public static class XLogData
    extends TextData {
        private static final long serialVersionUID = 6961783786712149071L;
        public static final PropertyDefs<XLogData> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(XLogData.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), TextData.PROP_TYPES);
        public static final TypedProp<Boolean> HAS_ERROR = PROP_TYPES.storeAsReadOnly(NodeProps.HAS_ERROR).attrGetter(XLogData::hasErrors, Stream.empty()).attrFinish();
        private final boolean d_hasErrors;

        public XLogData(String name, String fullPath, String content, int code) {
            super(name, fullPath, content);
            this.d_hasErrors = code != 0;
        }

        public boolean hasErrors() {
            return this.d_hasErrors;
        }

        public PropertyDefs<XLogData> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public XLogData clone() {
            return (XLogData)super.clone();
        }
    }

    public static class TextData
    extends NamedMerlinObj
    implements DataNode {
        private static final long serialVersionUID = 1L;
        public static final PropertyDefs<TextData> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(TextData.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), NamedMerlinObj.PROP_TYPES);
        public static final DisplayProp<String> STR_PATH = PROP_TYPES.storeAsPlainOldData(NodeProps.STR_PATH).attrFinish();
        public static final DisplayProp<String> STR_CONTENT = PROP_TYPES.storeAsPlainOldData(NodeProps.STR_CONTENT).attrFinish();
        protected IPropertySet d_props = new PropertySet();

        public TextData(String name, String fullPath, String content) {
            super(name);
            this.set(STR_PATH, fullPath);
            this.set(STR_CONTENT, content);
        }

        public PropertyDefs<? extends TextData> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public TextData clone() {
            return (TextData)super.clone();
        }
    }

    public static class SimulationRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        public static final PropertyDefs<SimulationRoot> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(SimulationRoot.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
            obj.d_props = new PropertySet();
        }), Composite.PROP_TYPES);
        public static final TypedProp<String> STR_PATH = PROP_TYPES.storeAsPlainOldData(NodeProps.STR_PATH).attrFinish();
        public static final TypedProp<PrjData> PRJDATA = PROP_TYPES.storeAsPlainOldData(NodeProps.PRJDATA).attrFinish();
        private IPropertySet d_props = new PropertySet();

        public SimulationRoot(String name, String prjFilePath, PrjData prjInputData) {
            super(name);
            this.set(STR_PATH, prjFilePath);
            this.set(PRJDATA, prjInputData);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        @Override
        public String toString() {
            return this.getName();
        }

        public PropertyDefs<SimulationRoot> getPropertyDefs() {
            return PROP_TYPES;
        }

        @Override
        public SimulationRoot clone() {
            return (SimulationRoot)super.clone();
        }
    }

    public static class ResultsRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        public final MergedData nodeZoneFlows = new MergedData(Intl.intl("Node-Zone Data"));
        public final MergedData linkPathData = new MergedData(Intl.intl("Link-Path Flows"));

        public ResultsRoot() {
            super(Intl.intl("Results"));
            this.addAll(this.nodeZoneFlows, this.linkPathData);
        }

        @Override
        public void clear() {
            super.clear();
            this.nodeZoneFlows.reset();
            this.linkPathData.reset();
            this.addAll(this.nodeZoneFlows, this.linkPathData);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        public Collection<VisLeaf> getLeavesForFlowpath(Object flowpath) {
            if (flowpath == null) {
                return Collections.emptySet();
            }
            return this.flatten(VisRoot.class).stream().map(visRoot -> visRoot.findCorrespondingLeaf(flowpath)).filter(obj -> obj != null).collect(Collectors.toSet());
        }

        public Object getFlowpathForVisleaf(VisLeaf visleaf) {
            if (visleaf == null) {
                return null;
            }
            for (VisRoot visRoot : this.flatten(VisRoot.class)) {
                if (!visRoot.containsDeep(visleaf)) continue;
                return visRoot.findCorrespondingFlowpath(visleaf);
            }
            return null;
        }

        public Collection<ZoneVisLeaf> getLeavesForZone(Object zone) {
            if (zone == null) {
                return Collections.emptySet();
            }
            return this.flatten(ZoneVisRoot.class).stream().map(visRoot -> visRoot.findCorrespondingLeaf(zone)).filter(obj -> obj != null).collect(Collectors.toSet());
        }

        public Object getZoneForVisleaf(ZoneVisLeaf visleaf) {
            if (visleaf == null) {
                return null;
            }
            for (ZoneVisRoot visRoot : this.flatten(ZoneVisRoot.class)) {
                if (!visRoot.containsDeep(visleaf)) continue;
                return visRoot.findCorrespondingRoom(visleaf);
            }
            return null;
        }
    }

    public static class SceneLeaf
    extends NamedMerlinObj
    implements IMerlinGeomSrc {
        SceneLeaf(String name) {
            super(name);
        }

        @Override
        public void setGeom(IGeomNode geom) {
        }

        @Override
        public IGeomNode getGeom() {
            return null;
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            return null;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void setVisible(boolean visible) {
        }
    }

    public static interface StaleLeaf
    extends IMerlinObj {
        public boolean isStale();

        public void setStale(boolean var1);
    }
}

