/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.props;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.framework.property.IPropComparisonEditorSupplier;
import thunderheadeng.gui.framework.property.ISimplePropComparisonEd;
import thunderheadeng.gui.framework.property.PropComparisonsFramework;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.CompositeFeatureGuid;
import ventus.gui.MerlinComboBox;
import ventus.gui.ObjSources;
import ventus.gui.SetChooser;
import ventus.unitsystem.UnitSystem;

public class PropComparisons
extends PropComparisonsFramework<VentusData, IMerlinObj> {
    private static final PropComparisons s_instance = new PropComparisons();

    public static PropComparisons factory() {
        return s_instance;
    }

    public IPropComparisonEditorSupplier<VentusData, IMerlinObj, UnitDouble> unitdouble(int unitType) {
        return this.unitdouble(() -> UnitSystem.getType(unitType, true));
    }

    public IPropComparisonEditorSupplier<VentusData, IMerlinObj, Schedule> schedule(int unitType) {
        return (parent, vd) -> {
            IUnitSrc unitSrc = UnitSystem.getType(unitType, true);
            return new ScheduleCompare(ValueFields.udFld(new UnitDouble(0.0, unitSrc.getUnit()), UnitDoubleVR.unbounded(), unitSrc), (v1, v2) -> {
                try {
                    return v1.compareToRel((UnitDouble)v2, 1.0E-9);
                }
                catch (Throwable t) {
                    assert (false);
                    return theUtil.relCompare(v1.getRawValue(), v2.getRawValue(), 1.0E-9);
                }
            });
        };
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<VentusData, IMerlinObj, RefT> singleObj(ObjSrcSupplier<RefT> source) {
        return this.singleObj(source, vd -> new MerlinComboBox((VentusData)vd, source.get(vd)), vd -> new SetChooser((VentusData)vd, Intl.intl("Select Objects"), Intl.intl("Invalid Selection"), 1, source.get(vd)), null);
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<VentusData, IMerlinObj, Collection<? extends RefT>> multiObj(ObjSrcSupplier<RefT> source) {
        return this.multiObj(source, vd -> new SetChooser((VentusData)vd, Intl.intl("Select Objects"), Intl.intl("Invalid Selection"), 1, source.get(vd)));
    }

    public static ObjSrcSupplier<Floor> getFloorSrc(String nullName) {
        return vd -> ObjSources.getFloors(vd, nullName);
    }

    public static ObjSrcSupplier<ISchematicRoom> getZoneSrc(String nullName) {
        return vd -> ObjSources.getZones(vd, nullName);
    }

    public static ObjSrcSupplier<Material> getMaterialSrc(String nullName) {
        return vd -> ObjSources.getMaterials(vd, nullName);
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj> ObjSrcSupplier<ObjT> getFeatureSrc(CompositeFeatureGuid<RootT, ObjT> guid, String nullName) {
        return vd -> ObjSources.getFeature(vd, guid, nullName);
    }

    public static interface ObjSrcSupplier<RefT extends IMerlinObj>
    extends PropComparisonsFramework.ObjSrcSupplier<VentusData, RefT> {
    }

    private static class ScheduleCompare
    extends guiPanel
    implements ISimplePropComparisonEd<IMerlinObj, Schedule> {
        private static final long serialVersionUID = 1L;
        private final ValueField<UnitDouble> d_field;
        private final guiComboBox<Range> d_rangeCb;
        private final guiComboBox<Comparison> d_comparisonCb;
        private final Comparator<UnitDouble> d_comparator;

        public ScheduleCompare(ValueField<UnitDouble> field, Comparator<UnitDouble> comparator) {
            this.d_field = field;
            this.d_field.setNullAllowed(false);
            this.d_rangeCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Range.values());
            this.d_comparisonCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Comparison.values());
            this.d_comparator = comparator;
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(this.d_rangeCb, this.d_comparisonCb, this.d_field);
            gb.finalizeRows();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public Predicate<Schedule> getSimplePredicate() {
            Range range = this.d_rangeCb.getSelectedItem();
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            Predicate<UnitDouble> compareInstantaneous = val -> {
                if (val == null) {
                    assert (false) : "PropComparisons.factory().ScheduleCompare does not yet support comparing to null values. Update ScheduleCompare to handle this case.";
                    return false;
                }
                int compared = this.d_comparator.compare((UnitDouble)val, (UnitDouble)this.d_field.getValue());
                return comparison.test.test(compared);
            };
            return schedule -> range.test.test((Schedule)schedule, compareInstantaneous);
        }

        private static enum Range {
            INITIALLY(Intl.intl("is initially"), (schedule, test) -> test.test(schedule.getInitialValue())),
            EVER(Intl.intl("is ever"), (schedule, test) -> schedule.allValues().anyMatch((Predicate<UnitDouble>)test)),
            ALWAYS(Intl.intl("is always"), (schedule, test) -> schedule.allValues().allMatch((Predicate<UnitDouble>)test));

            public final String desc;
            public final BiPredicate<Schedule, Predicate<UnitDouble>> test;

            private Range(String desc, BiPredicate<Schedule, Predicate<UnitDouble>> test) {
                this.desc = desc;
                this.test = test;
            }
        }

        private static enum Comparison {
            LT("<", c -> c < 0),
            LE("\u2264", c -> c <= 0),
            GT(">", c -> c > 0),
            GE("\u2265", c -> c >= 0);

            public final String desc;
            public final IntPredicate test;

            private Comparison(String desc, IntPredicate test) {
                this.desc = desc;
                this.test = test;
            }
        }
    }
}

