/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.plot;

import javax.swing.Icon;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.MerlinOp;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IHotkey;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.plot.IPlotSrc;
import ventus.feature.plot.PlotModeDesc;
import ventus.feature.plot.ShowTimeHistoryPlotOp;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

public class ShowTimeHistoryPlots
implements IAppMenuItem,
IPlotSrc,
IContextMenuItem,
IEventObserver,
IHotkey<UIHook> {
    public static final int PLOT_PRESSURE_DIF_IX = 0;
    public static final int PLOT_PRIMARY_FLOW_IX = 1;
    public static final int PLOT_SECONDARY_FLOW_IX = 2;
    public static final int PLOT_TEMPERATURE_IX = 3;
    public static final int PLOT_PRESSURE_IX = 4;
    public static final int PLOT_DENSITY_IX = 5;
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/results2D16.gif");
    private final int d_seqOffset;
    private final Class<?>[] d_selectedClasses;
    private final UIHook d_runHookMenu;
    private final UIHook d_runHookContext;
    private final Shortcut<UIHook> d_runShortcut;
    public static final ShowTimeHistoryPlots ITEM_PLOT_PRIMARY_FLOWS = new ShowTimeHistoryPlots(1, Intl.intl("Plot Primary &Flows...,-,Plot Flow Path Primary Flow Rates..."), "plotFlowRates", new PlotModeDesc(PlotModeDesc.PlotModeType.PRIMARY_FLOW), FlowPath.class, DataNode.VisLeaf.class);
    public static final ShowTimeHistoryPlots ITEM_PLOT_SECONDARY_FLOWS = new ShowTimeHistoryPlots(2, Intl.intl("Plot Secondary &Flows...,-,Plot Flow Path Secondary Flow Rates..."), "plotSecondaryFlowRates", new PlotModeDesc(PlotModeDesc.PlotModeType.SECONDARY_FLOW), FlowPath.class, DataNode.VisLeaf.class);
    public static final ShowTimeHistoryPlots ITEM_PLOT_PRESSURE_DIFF = new ShowTimeHistoryPlots(0, Intl.intl("Plot Differential &Pressures...,-,Plot Flow Path Differential Pressures..."), "plotPressureDiffs", new PlotModeDesc(PlotModeDesc.PlotModeType.PRESSURE_DIFF), FlowPath.class, DataNode.VisLeaf.class);
    public static final ShowTimeHistoryPlots ITEM_PLOT_TEMPERATURE = new ShowTimeHistoryPlots(3, Intl.intl("Plot Zone &Temperatures...,-,Plot Zone Temperatures..."), "plotZoneTemperatures", new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_TEMP), SchematicRoom.class, DataNode.ZoneVisLeaf.class);
    public static final ShowTimeHistoryPlots ITEM_PLOT_PRESSURE = new ShowTimeHistoryPlots(4, Intl.intl("Plot Zone &Pressures...,-,Plot Zone Pressures..."), "plotZonePressures", new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_PRESSURE), SchematicRoom.class, DataNode.ZoneVisLeaf.class);
    public static final ShowTimeHistoryPlots ITEM_PLOT_DENSITY = new ShowTimeHistoryPlots(5, Intl.intl("Plot Zone &Densities...,-,Plot Zone Densities..."), "plotZoneDensities", new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_DENSITY), SchematicRoom.class, DataNode.ZoneVisLeaf.class);

    private ShowTimeHistoryPlots(int offset, String name, String shortcutKey, PlotModeDesc desc, Class<?> ... classes) {
        this.d_seqOffset = offset;
        this.d_runHookMenu = new UIHook((MerlinOp)new ShowTimeHistoryPlotOp(desc, false), name, ICON);
        this.d_runHookContext = new UIHook((MerlinOp)new ShowTimeHistoryPlotOp(desc, true), name, ICON);
        this.d_runShortcut = new Shortcut<UIHook>(new ShortcutInfo(shortcutKey, ShortcutInfo.Category.RESULTS), this.d_runHookMenu);
        this.d_selectedClasses = classes;
    }

    @Override
    public void addMenuItems(GroupedSequence root) {
        root.getNode("results").add(30 + this.d_seqOffset, (Object)this.d_runHookMenu);
    }

    @Override
    public void addPlotActions(GroupedSequence root) {
        root.add(this.d_seqOffset, (Object)this.d_runHookMenu);
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        GroupedSequence node = root.getNode("results").getOrAdd(new GroupedSequence("plot", 150, null));
        node.add(this.d_seqOffset, (Object)this.d_runHookContext);
    }

    @Override
    public Shortcut<UIHook> getKeyboardShortcut() {
        return this.d_runShortcut;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.hasAddedObjs() || changelog.hasRemovedObjs() || changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData md) {
        DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)md.getComponentData(ResultsDataComp.GUID);
        boolean hasResults = !resultsRoot.flatten(DataNode.VisLeaf.class).isEmpty() || !resultsRoot.flatten(DataNode.ZoneVisLeaf.class).isEmpty();
        this.d_runHookContext.setEnabled(md.selection.contains(this.d_selectedClasses) && hasResults);
    }
}

