/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.levels;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jscience.physics.units.SI;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;

class LevelPrjDataWriterComp
implements IPrjDataWriter {
    LevelPrjDataWriterComp() {
    }

    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.BEFORE_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        Collection<Floor> floors = md.floors.flatten(Floor.class);
        prjData.nlev = floors.size();
        int nr = 1;
        for (Floor f : floors) {
            PrjData.Level level = new PrjData.Level(f);
            prjData.levelList.add(level);
            String levelName = f.getWorkingGeomGroup().getName();
            levelName = levelName.replaceAll("\\.", "-");
            levelName = levelName.replaceAll(" ", "_");
            levelName = StringUtils.truncate(levelName, 15);
            level.nr = nr++;
            level.refHt = f.getWorkingZ().get(SI.METER);
            level.delHt = f.getHeight().get(SI.METER);
            level.levelName = levelName;
        }
    }
}

