/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.flowpaths.FlowPath;
import ventus.gui.ContextMenuUtils;

public class ValidateConnectionOp
extends AMerlinOp
implements IContextMenuItem,
IEventObserver {
    final UIHook uiHook = new UIHook(this, Intl.intl("&Validate Connections..."));

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusApp.getAppOpt().map(VentusApp::getData).ifPresent(this::updateEnabled);
        }
    }

    private void updateEnabled(VentusData vd) {
        if (vd.selection.isEmpty()) {
            this.setEnabled(false);
        } else {
            boolean valid = vd.selection.getDeepSelected(FlowPath.class).stream().anyMatch(FlowPath::getShouldWarnForConnectionTypeChange);
            this.setEnabled(valid);
        }
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode(ContextMenuUtils.ContextMenuNode.MODIFY.id).add(this.uiHook);
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        List<FlowPath> flowPaths = vd.selection.getDeepSelected(FlowPath.class).stream().filter(FlowPath::getShouldWarnForConnectionTypeChange).toList();
        String[] columns = new String[]{"Flow Path", "Start Zone", "End Zone"};
        Class[] colClasses = new Class[]{FlowPath.class, String.class, String.class};
        guiTable table = guiTableUtil.fixedColumnTable(columns, colClasses, 16);
        guiTableEditor editor = new guiTableEditor(table, 0);
        table.setSortOrder(0);
        table.setAutoResizeMode(0);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.clearRows();
        int row = 0;
        for (FlowPath fp : flowPaths) {
            String startZone = fp.getStartZone().getName();
            String endZone = fp.getEndZone().getName();
            table.getModel().setValueAt(fp, row, 0);
            table.getModel().setValueAt(startZone, row, 1);
            table.getModel().setValueAt(endZone, row, 2);
            ++row;
        }
        table.setAutoResizeMode(4);
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), "Validate Flow Path Connections", 9);
        guiPanel mainPanel = dlg.getDialogPane();
        mainPanel.setLayout(new MigLayout("insets 0, gap 6"));
        JLabel iconComp = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        mainPanel.add(iconComp);
        guiPanel msgPanel = new guiPanel(new MigLayout("insets 0, gap 6"));
        msgPanel.add(new JLabel(Intl.intl("This will mark the connections for the following Flow Paths as valid.")));
        msgPanel.add((Component)new JLabel(Intl.intl("The connection warnings for these Flow Paths will be removed.")), "newline");
        mainPanel.add((Component)msgPanel, "gapleft 18");
        mainPanel.add((Component)editor, "span, growx, newline, gaptop 12");
        mainPanel.add((Component)new JLabel(Intl.intl("Would you like to continue?")), "span, cell 1 2, gap 18 0 0 0, newline");
        dlg.setResizable(true);
        dlg.setMinimumSizeEnabled(true);
        dlg.setPreferredSize(new Dimension(500, 300));
        if (dlg.doModal() == 1) {
            for (FlowPath fp : flowPaths) {
                fp.updateInitialConnectionType(true);
            }
        }
    }
}

