/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Window;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPopupMenu;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.BasicHotkey;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IHotkey;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.gui.VentusObjsList;

public class ShowFlowPaths {
    public final IHotkey<UIHook> hkShowAmbient;
    public final IHotkey<UIHook> hkShowInternal;
    public final IAppMenuItem appMenuItems;

    public ShowFlowPaths() {
        UIHook uiHookShowAmbient = new UIHook(new ShowAmbientOp(), Intl.intl("Show &Ambient Flow Paths..."));
        this.hkShowAmbient = new BasicHotkey<UIHook>("showAmbientFlowPaths", ShortcutInfo.Category.SIMULATION, uiHookShowAmbient, false);
        UIHook uiHookShowInternal = new UIHook(new ShowInternalOp(), Intl.intl("Show &Internal Flow Paths..."));
        this.hkShowInternal = new BasicHotkey<UIHook>("showInternalFlowPaths", ShortcutInfo.Category.SIMULATION, uiHookShowInternal, false);
        this.appMenuItems = root -> {
            root.getNode("simulation").add(10, (Object)new JPopupMenu.Separator());
            root.getNode("simulation").add((String)uiHookShowAmbient.getValue("Name"), 11, uiHookShowAmbient);
            root.getNode("simulation").add((String)uiHookShowInternal.getValue("Name"), 12, uiHookShowInternal);
        };
    }

    private static class ShowAmbientOp
    extends AMerlinOp {
        private ShowAmbientOp() {
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            FlowPathRoot flowPathRoot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
            List items = flowPathRoot.flatten(FlowPath.class).stream().filter(fp -> fp.isExterior()).collect(Collectors.toList());
            ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>((Window)app.getActiveFrame(), Intl.intl("Show Ambient Flow Paths"), new VentusObjsList(vd, Intl.intl("Show Ambient Flow Paths"), true, true, items));
            dlg.doModeless();
        }
    }

    private static class ShowInternalOp
    extends AMerlinOp {
        private ShowInternalOp() {
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            FlowPathRoot flowPathRoot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
            List items = flowPathRoot.flatten(FlowPath.class).stream().filter(fp -> !fp.isExterior()).collect(Collectors.toList());
            ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>((Window)app.getActiveFrame(), Intl.intl("Show Internal Flow Paths"), new VentusObjsList(vd, Intl.intl("Show Internal Flow Paths"), true, true, items));
            dlg.doModeless();
        }
    }
}

