/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.transform.ATransformTool;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.builders.ToolName;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.IHotkey;
import ventus.feature.comps.ITool;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathBuilder;
import ventus.feature.flowpaths.FlowPathUtil;
import ventus.feature.flowpaths.NewFlowPathPanel;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;
import ventus.mv.tools.IConditionallyEnabledTool;
import ventus.mv.tools.RoomSnapConstraint;
import ventus.mv.tools.VentusTool;

public class NewFlowPath2Pt
implements ITool<FlowPathBuilder>,
IHotkey<ToolName> {
    public static final ImageIcon icon_route_2pt = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(FlowPath.class, "icons/route-2pt.svg"), 16);
    private final Shortcut<ToolName> d_shortcut = new Shortcut<ToolName>(new ShortcutInfo("newFlowPathMulti", ShortcutInfo.Category.TOOL), ToolName.NEW_FLOW_PATH_MULTI);
    private FlowPathBuilder d_builder;
    private FlowPathBuilder.Display d_display;
    private ModelView d_mv;
    private Tool d_tool;
    private NewFlowPathPanel d_panel;

    @Override
    public void init(ModelView mv) {
        this.d_mv = mv;
        this.d_builder = new FlowPathBuilder();
        this.d_display = new FlowPathBuilder.Display(mv);
        this.d_tool = new Tool(mv);
        this.d_panel = new NewFlowPathPanel(mv.getData(), FlowPathBuilder.Mode.TWO_POINT);
    }

    @Override
    public ModelScene getScene() {
        return this.d_mv.getToolScene();
    }

    @Override
    public APropEditPanel<FlowPathBuilder> getPanel() {
        return this.d_panel;
    }

    @Override
    public FlowPathBuilder getBuilder() {
        return this.d_builder;
    }

    public FlowPathBuilder.Display getDisplay() {
        return this.d_display;
    }

    @Override
    public VentusTool<FlowPathBuilder> getTool() {
        return this.d_tool;
    }

    @Override
    public String getName() {
        return ToolName.NEW_FLOW_PATH_MULTI.get();
    }

    @Override
    public String getTooltip() {
        return Intl.intl("Create a flow path between two walls");
    }

    @Override
    public Icon getIcon() {
        return icon_route_2pt;
    }

    @Override
    public void addToolbarItem(GroupedSequence root) {
        root.getNode("create").add(21, (Object)this.d_tool);
    }

    @Override
    public Shortcut<ToolName> getKeyboardShortcut() {
        return this.d_shortcut;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public static class Tool
    extends VentusTool<FlowPathBuilder>
    implements IConditionallyEnabledTool {
        public final ModelView mv;
        private final GeomDisplay geom;

        public Tool(ModelView mv) {
            super(mv, (IToolFunction<? extends CursorTool>)new Func());
            this.clearSnapInfo();
            this.mv = mv;
            this.geom = new GeomDisplay(mv.getDisplayProps(), new ATransformTool.GeomSrc());
        }

        public ModelScene getScene() {
            return this.mv.getToolScene();
        }

        public void updateDisplay(IGeomNode geom, IPropsSrc props) {
            ATransformTool.GeomSrc source = (ATransformTool.GeomSrc)this.geom.getSource();
            source.display = new DisplayGeom(geom.bakeIfRecommended(), props);
            this.geom.update();
            this.repaintSurface();
        }

        @Override
        public void reset() {
            ((FlowPathBuilder)this.props()).reset(false);
            this.updateDisplay(DisplayGeom.EMPTY.node, DisplayGeom.EMPTY.props);
            super.reset();
        }

        @Override
        public boolean cancel() {
            ((FlowPathBuilder)this.props()).cancel();
            return super.cancel();
        }

        @Override
        public void activate() {
            this.pauseRepaint();
            this.getScene().addObjects(this.geom);
            this.resumeRepaint(true);
            super.activate();
        }

        @Override
        public void deactivate() {
            this.pauseRepaint();
            this.getScene().removeObjects(this.geom);
            this.resumeRepaint(true);
            ((FlowPathBuilder)this.props()).reset(true);
            super.deactivate();
        }

        @Override
        public boolean isEnabled(VentusData vd) {
            return !vd.floors.flatten(SchematicRoom.class).isEmpty() && !((FlowElementRoot)vd.getComponentData(FlowElementData.GUID)).flatten(FlowElement.class).isEmpty();
        }
    }

    public static class Func
    extends AToolFunction<Tool> {
        public static final int POINT_SIZE = 5;
        public static final int LINE_WIDTH = 2;
        private IsectInfo p0;
        private IsectInfo p1;
        private boolean wasDragged = false;

        private void create(Tool tool) {
            Pair<FlowPath.Connection, FlowPath.Connection> validated;
            Pair<ConnectionInfo, ConnectionInfo> connInfo = this.findConnectionInfo(tool);
            if (connInfo == null) {
                return;
            }
            VentusData vd = (VentusData)((ConnectionInfo)connInfo.v1).room.getDomain();
            assert (vd != null);
            Pair<FlowPath.Connection, FlowPath.Connection> conn = new Pair<FlowPath.Connection, FlowPath.Connection>(((ConnectionInfo)connInfo.v1).asConnection(), ((ConnectionInfo)connInfo.v2).asConnection());
            if (!((FlowPath.Connection)conn.v1).p().epsilonEquals(((FlowPath.Connection)conn.v2).p(), 1.0E-6)) {
                FlowPath.Connection sharedLoc1 = FlowPathUtil.findSharedWallLocation(vd, () -> {}, ((FlowPath.Connection)conn.v1).comp(), ((FlowPath.Connection)conn.v1).p());
                if (sharedLoc1 != null) {
                    conn = new Pair<FlowPath.Connection, FlowPath.Connection>((FlowPath.Connection)conn.v1, sharedLoc1);
                } else {
                    FlowPath.Connection sharedLoc2 = FlowPathUtil.findSharedWallLocation(vd, () -> {}, ((FlowPath.Connection)conn.v2).comp(), ((FlowPath.Connection)conn.v2).p());
                    if (sharedLoc2 != null) {
                        conn = new Pair<FlowPath.Connection, FlowPath.Connection>(sharedLoc2, (FlowPath.Connection)conn.v2);
                    }
                }
            }
            if ((validated = FlowPathUtil.validateConnection(vd, () -> {}, (FlowPath.Connection)conn.v1, (FlowPath.Connection)conn.v2, true)) == null) {
                return;
            }
            FlowPath.Connection conn1 = (FlowPath.Connection)validated.v1;
            FlowPath.Connection conn2 = (FlowPath.Connection)validated.v2;
            ((FlowPathBuilder)tool.props()).set(FlowPathBuilder.MODE, FlowPathBuilder.Mode.TWO_POINT);
            ((FlowPathBuilder)tool.props()).setLocation(conn1.comp(), conn2.comp(), conn1.wall(), conn2.wall(), conn1.normal(), conn2.normal(), conn1.p(), conn2.p());
            ((FlowPathBuilder)tool.props()).create();
        }

        private Pair<ISchematicRoom.IWallComponent, Point3d> getWallInRoomSlice(ISchematicRoom room, AABox bounds, IPolygon slice, double elevation) {
            ISchematicRoom.IWallComponent[] resultWall = new ISchematicRoom.IWallComponent[]{null};
            LineSeg[] intersection = new LineSeg[]{null};
            try {
                room.getGeom().find(new AABoxTest(bounds, 1.0E-6), (fprim, ctmt) -> {
                    Optional<ISchematicRoom.IWallComponent> wall = RoomUtil.getWall(fprim.elements);
                    if (wall.isEmpty()) {
                        return;
                    }
                    LineSeg wallIsect = FlowPathUtil.sliceInterWall(slice, room, wall.get());
                    if (wallIsect == null) {
                        return;
                    }
                    resultWall[0] = wall.get();
                    intersection[0] = wallIsect;
                    throw new RuntimeException();
                });
            }
            catch (RuntimeException e) {
                TeciLogging.logFlowControlException(e);
            }
            if (resultWall[0] == null) {
                return null;
            }
            double t = 0.5;
            Floor level = room.getLevel();
            if (level != null) {
                t = elevation / level.getHeight().get(Geometry.LENGTH_UNIT);
            }
            if (intersection[0].p1.z > intersection[0].p2.z) {
                t = 1.0 - t;
            }
            return new Pair<ISchematicRoom.IWallComponent, Point3d>(resultWall[0], intersection[0].get(t));
        }

        private Pair<ConnectionInfo, ConnectionInfo> findConnectionInfo(Tool tool) {
            Point3d p1Far;
            if (this.p0 == null || this.p1 == null) {
                return null;
            }
            Function<IsectInfo, ConnectionInfo> toConnInfo = isect -> {
                if (!(isect.obj instanceof ISchematicRoom)) {
                    return new ConnectionInfo(isect.isectPoint);
                }
                assert (isect.getFaceNormal != null);
                ISchematicRoom.IWallComponent wall = RoomUtil.getWall(isect.elements).orElse(null);
                ConnectionInfo conn = new ConnectionInfo((ISchematicRoom)isect.obj, wall, wall != null ? wall.getNormal() : isect.getFaceNormal.get(), isect.isectPoint);
                if (conn.isValid()) {
                    conn.adjustToElevtion();
                }
                return conn;
            };
            ConnectionInfo conn1 = toConnInfo.apply(this.p0);
            ConnectionInfo conn2 = toConnInfo.apply(this.p1);
            if (conn1.isValid() && conn2.isValid()) {
                return new Pair<ConnectionInfo, ConnectionInfo>(conn1, conn2);
            }
            View view = tool.getView();
            Point3d screen = view.worldToScreen(this.p0.isectPoint);
            Point3d p0Near = view.screenToWorld(new Point3d(screen.x, screen.y, 0.0));
            Point3d p0Far = view.screenToWorld(new Point3d(screen.x, screen.y, 1.0));
            screen = view.worldToScreen(this.p1.isectPoint);
            Point3d p1Near = view.screenToWorld(new Point3d(screen.x, screen.y, 0.0));
            Quad slice = new Quad(p0Near, p1Near, p1Far = view.screenToWorld(new Point3d(screen.x, screen.y, 1.0)), p0Far);
            if (slice.getPlaneIfValid(true) == null) {
                return null;
            }
            AABox sliceBounds = new AABox(p0Near, p1Near, p1Far, p0Far);
            Consumer<ConnectionInfo> finalizeConnection = conn -> {
                if (conn.isValid() || conn.room == null) {
                    return;
                }
                Pair<ISchematicRoom.IWallComponent, Point3d> result = this.getWallInRoomSlice(conn.room, sliceBounds, slice, conn.getDesiredElevation());
                if (result != null) {
                    conn.wall = (ISchematicRoom.IWallComponent)result.v1;
                    conn.wallPt = (Point3d)result.v2;
                    conn.normal = ((ISchematicRoom.IWallComponent)result.v1).getNormal();
                }
            };
            finalizeConnection.accept(conn1);
            finalizeConnection.accept(conn2);
            if (!conn1.isValid() && !conn2.isValid()) {
                return null;
            }
            if (!conn1.isValid()) {
                conn1 = conn2;
            } else if (!conn2.isValid()) {
                conn2 = conn1;
            }
            return new Pair<ConnectionInfo, ConnectionInfo>(conn1, conn2);
        }

        private void updateActor(Tool tool) {
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
            PropsBuilder props = new PropsBuilder();
            if (this.p0 != null) {
                geoms.add(new Point(this.p0.isectPoint));
                props.add(new IPrimProps.Vertex(Color.BLUE, 5.0));
            }
            if (this.p1 != null && this.p0 != null) {
                geoms.add(new LineSeg(this.p0.isectPoint, this.p1.isectPoint));
                props.add(new IPrimProps.Edge(Color.WHITE, 2.0, IPrimProps.DEF_STIPPLE, 0));
                geoms.add(new Point(this.p1.isectPoint));
                props.add(new IPrimProps.Vertex(Color.BLUE, 5.0));
            }
            tool.updateDisplay(GeomNodeUtil.newNode(new GeomGroup(geoms)), props.finalizeProps());
            tool.repaintSurface();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getSnapInfo(Tool tool) {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(this, ISchematicRoom.class, GeomType.FACE){

                @Override
                public boolean acceptIntersection(IsectInfo info) {
                    return info.getFaceNormal != null;
                }
            });
        }

        @Override
        public ISnapConstraint getSnapConstraint(Tool tool) {
            return new RoomSnapConstraint(VentusApp.getAppData(), tool.getDefaultConstraint(), (room, comp) -> room.getType().hasWalls);
        }

        @Override
        public Cursor getCursor(Tool tool) {
            return null;
        }

        @Override
        public boolean cancel(Tool tool) {
            this.reset(tool);
            return super.cancel(tool);
        }

        private void setP0(Tool tool, IsectInfo p) {
            this.p0 = p;
            this.updateActor(tool);
        }

        private void setP1(Tool tool, IsectInfo p) {
            this.p1 = p;
            this.updateActor(tool);
        }

        private void reset(Tool tool) {
            this.p0 = null;
            this.p1 = null;
            this.wasDragged = false;
            tool.reset();
        }

        private void createAndFinish(Tool tool) {
            this.create(tool);
            this.reset(tool);
            tool.finish();
        }

        @Override
        public void mousePressed(Tool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            IsectInfo snap = tool.getP1().getFinalSnap();
            if (snap == null) {
                return;
            }
            if (this.p0 == null) {
                this.setP0(tool, snap);
            } else {
                this.setP1(tool, snap);
                this.createAndFinish(tool);
            }
        }

        @Override
        public void mouseReleased(Tool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                tool.cancel();
                this.reset(tool);
                return;
            }
            if (this.p0 != null && this.p1 == null) {
                return;
            }
            if (this.p0 == null || !(this.p0.obj instanceof ISchematicRoom) && !(this.p1.obj instanceof ISchematicRoom)) {
                this.reset(tool);
            } else {
                this.createAndFinish(tool);
            }
        }

        @Override
        public void mouseDragged(Tool tool, MouseEvent e) {
            IsectInfo snap = tool.getP1().getFinalSnap();
            this.wasDragged = true;
            if (snap == null) {
                return;
            }
            this.setP1(tool, snap);
            ((FlowPathBuilder)tool.props()).set(FlowPath.END_LOCATION, snap.isectPoint);
        }

        @Override
        public void mouseMoved(Tool tool, MouseEvent e) {
            if (this.wasDragged) {
                return;
            }
            Point3d moveLoc = tool.getP1().getFinalSnapLocation();
            if (moveLoc == null) {
                moveLoc = tool.getP1().referenceSnap;
            }
            if (this.p0 == null) {
                ((FlowPathBuilder)tool.props()).set(FlowPath.START_LOCATION, moveLoc);
                return;
            }
            Point3d p0Loc = this.p0.isectPoint;
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
            PropsBuilder props = new PropsBuilder();
            geoms.add(new Point(p0Loc));
            props.add(new IPrimProps.Vertex(Color.BLUE, 5.0));
            geoms.add(new LineSeg(p0Loc, moveLoc));
            props.add(new IPrimProps.Edge(Color.WHITE, 2.0, IPrimProps.DEF_STIPPLE, 0));
            tool.updateDisplay(GeomNodeUtil.newNode(new GeomGroup(geoms)), props.finalizeProps());
            ((FlowPathBuilder)tool.props()).set(FlowPath.END_LOCATION, moveLoc);
        }

        private static class ConnectionInfo {
            public ISchematicRoom room;
            public ISchematicRoom.IWallComponent wall;
            public Vector3d normal;
            public Point3d wallPt;

            public ConnectionInfo(Point3d pt) {
                this(null, null, null, pt);
            }

            public ConnectionInfo(ISchematicRoom room, ISchematicRoom.IWallComponent wall, Vector3d normal, Point3d wallPt) {
                this.room = room;
                this.wall = wall;
                this.normal = normal;
                this.wallPt = wallPt;
            }

            public FlowPath.Connection asConnection() {
                return new FlowPath.Connection(this.wallPt, this.normal, this.room, this.wall);
            }

            public boolean isValid() {
                return this.room != null && this.wall != null;
            }

            public double getDesiredElevation() {
                Floor level = this.room.getLevel();
                double e = level != null ? level.getHeight().get(Geometry.LENGTH_UNIT) * 0.5 : 0.0;
                return e;
            }

            public void adjustToElevtion() {
                assert (this.isValid());
                double elevation = this.getDesiredElevation();
                Point3d projected = this.room.getZProjectedLoc(this.wallPt);
                if (projected != null) {
                    this.wallPt = new Point3d(projected.x, projected.y, projected.z + elevation);
                }
            }
        }
    }
}

