/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.feature.tags.Tag;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileFeature;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class FlowPathOISHandler
implements IInputStreamFeatureHandler {
    private static final Logger LOGGER = Logger.getLogger(FlowPathOISHandler.class.getSimpleName());

    @Override
    public boolean applyVersionUpdates(int updateVersionNumber, int streamVersionNumber, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        FlowPathRoot fproot;
        boolean modified = false;
        if (updateVersionNumber == VentusIO.Version.VER_208.num && streamVersionNumber < VentusIO.Version.VER_208.num) {
            WindProfileRoot wpRoot = (WindProfileRoot)vd.getComponentData(WindProfileFeature.GUID);
            if (wpRoot == null) {
                return false;
            }
            LinkedIdentityHashSet newProfiles = new LinkedIdentityHashSet();
            fproot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
            for (FlowPath flowPath : fproot.flatten(FlowPath.class)) {
                WindProfile wp2 = flowPath.get(FlowPath.WIND_PROFILE);
                if (wp2 == null || wpRoot.containsDeep(wp2)) continue;
                modified = true;
                Optional<WindProfile> existingProfile = wpRoot.flatten(WindProfile.class).stream().filter(existing -> existing.isMatch(wp2, Filters.reject(WindProfile.DESC))).findFirst();
                if (existingProfile.isPresent()) {
                    warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", referenced a Wind Profile, \"%2$s\", that was not in the model."), flowPath.getName(), wp2.getName()), String.format(Intl.intl("Replaced the missing reference with existing Wind Profile, \"%s\"."), existingProfile.get().getName())));
                    flowPath.set(FlowPath.WIND_PROFILE, existingProfile.get());
                    continue;
                }
                warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", referenced a Wind Profile, \"%2$s\", that was not in the model."), flowPath.getName(), wp2.getName()), Intl.intl("Added missing Wind Profile to the model.")));
                newProfiles.add(wp2);
            }
            if (!newProfiles.isEmpty()) {
                Set usedNames = wpRoot.flatten(WindProfile.class).stream().map(wp -> wp.getName()).collect(Collectors.toCollection(() -> new HashSet()));
                for (WindProfile newProf : newProfiles) {
                    String baseName = newProf.getName();
                    int i = 1;
                    String name = baseName;
                    while (usedNames.contains(name)) {
                        name = String.format("%s_%02d", baseName, i++);
                    }
                    if (name.equals(baseName)) continue;
                    usedNames.add(name);
                    newProf.setName(name);
                }
                wpRoot.addAll(newProfiles);
            }
        }
        if (updateVersionNumber == VentusIO.Version.VER_210.num && streamVersionNumber < VentusIO.Version.VER_210.num) {
            IdentityHashSet convertedTags = new IdentityHashSet();
            IdentityHashSet flowpathsWithTagRefs = new IdentityHashSet();
            fproot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
            for (FlowPath flowPath : fproot.flatten(FlowPath.class)) {
                Set<Tag> tags = flowPath.getLegacyTags();
                if (tags.isEmpty()) continue;
                convertedTags.addAll(tags);
                flowPath.setTags(tags);
                flowpathsWithTagRefs.add(flowPath);
            }
            convertedTags.addAll(flowpathsWithTagRefs);
            changes.changeObjs.put(210, convertedTags);
        }
        if (updateVersionNumber == VentusIO.Version.VER_214.num && streamVersionNumber < VentusIO.Version.VER_214.num) {
            FlowPathRoot fproot2 = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
            for (FlowPath fp : fproot2.flatten(FlowPath.class)) {
                fp.validateLegacyInitCxnType();
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyAlwaysPostUpdates(VentusOIS.DecisionMaker responseHandler, WarningReport warns, VentusData vd, int streamVersion) {
        boolean modified = false;
        if (VentusIO.Version.VER_221.isLater(streamVersion)) {
            VentusData tempVd = new VentusData(false, true);
            try {
                Collection<FlowPath> flowpaths = ((FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID)).flatten(FlowPath.class);
                if (!flowpaths.isEmpty()) {
                    LinkedIdentityHashMap<FlowPath, Pair<FlowPath.Connection, FlowPath.Connection>> fpConns = new LinkedIdentityHashMap<FlowPath, Pair<FlowPath.Connection, FlowPath.Connection>>();
                    for (FlowPath fp : flowpaths) {
                        FlowPath.Connection c1 = fp.getConnection(FlowPath.ConnectionProps.START);
                        FlowPath.Connection c2 = fp.getConnection(FlowPath.ConnectionProps.END);
                        fpConns.put(fp, new Pair<FlowPath.Connection, FlowPath.Connection>(c1, c2));
                    }
                    tempVd.loadFrom(vd);
                    for (FlowPath fp : flowpaths) {
                        Pair<ISchematicRoom, ISchematicRoom> newZones;
                        UnitDouble newHeight;
                        UnitDouble prevHeight = Pre221.Pre221FlowPath.getGeometryElevation(fp);
                        if (!prevHeight.epsilonEquals(newHeight = fp.getRelativeElevation(), 0.01)) {
                            warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", was previously assigned an incorrect <b>%2$s</b> of %3$.2f m."), fp.getName(), FlowPath.RELATIVE_ELEVATION.name, prevHeight.get(SI.METER)), String.format(Intl.intl("Corrected the <b>Rel. Height</b> to %.2f m."), newHeight.get(SI.METER))));
                            modified = true;
                        }
                        Pair prevConns = (Pair)fpConns.get(fp);
                        Pair<ISchematicRoom, ISchematicRoom> prevZones = Pre221.Pre221FlowPath.getZones(tempVd, (FlowPath.Connection)prevConns.v1, (FlowPath.Connection)prevConns.v2);
                        if (prevZones.equals(newZones = fp.getZones())) continue;
                        warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", was previously connected to zones, \"%2$s\" -> \"%3$s\", but is now connected to zones, \"%4$s\" -> \"%5$s\"."), fp.getName(), ((ISchematicRoom)prevZones.v1).getName(), ((ISchematicRoom)prevZones.v2).getName(), ((ISchematicRoom)newZones.v1).getName(), ((ISchematicRoom)newZones.v2).getName()), Intl.intl("Check the connections and adjust if necessary.")));
                        modified = true;
                    }
                }
            }
            catch (Throwable t) {
                TeciLogging.log(LOGGER, t);
                assert (false);
            }
            finally {
                block18: {
                    try {
                        tempVd.loadFrom(new VentusData(false, false));
                    }
                    catch (Throwable t) {
                        TeciLogging.log(LOGGER, t);
                        if ($assertionsDisabled) break block18;
                        throw new AssertionError();
                    }
                }
            }
        }
        return modified;
    }

    private static class Pre221 {
        private Pre221() {
        }

        private static class Pre221FlowPathUtil {
            private Pre221FlowPathUtil() {
            }

            private static UnitDouble getGeometryElevation(FlowPath.Connection conn) {
                Point3d startLocation = conn.p();
                ISchematicRoom startComp = conn.comp();
                ISchematicRoom.IWallComponent startWall = conn.wall();
                if (startLocation == null || startComp == null || startWall == null) {
                    return new UnitDouble(0.0, Geometry.LENGTH_UNIT);
                }
                double projZ = Pre221FlowPathUtil.getProjectedLoc(startComp, startLocation);
                double startElevation = startLocation.getZ() - projZ;
                return new UnitDouble(startElevation, Geometry.LENGTH_UNIT);
            }

            private static double getProjectedLoc(ISchematicRoom room, Point3d loc) {
                Point3d proj = Pre221SchematicRoom.getZProjectedLoc(room, loc);
                if (proj != null) {
                    return proj.z;
                }
                Floor level = room.getLevel();
                return level != null ? level.getWorkingZ().get(Geometry.LENGTH_UNIT) : loc.z;
            }

            private static ISchematicRoom getRoomBelow(VentusData vd, ISchematicRoom room1, Point3d point1) {
                Objects.requireNonNull(vd);
                Collection<GeomUtil.FindResult> rooms = GeomUtil.findRooms(vd, () -> {}, point1, Util3D.VEC3D_ZNEG, Double.MAX_VALUE, 1, (r, c) -> r != room1 && !(c instanceof ISchematicRoom.IWallComponent) && Pre221FlowPathUtil.isDirectlyBelow(room1, r));
                if (rooms.isEmpty()) {
                    return null;
                }
                ISchematicRoom first = rooms.iterator().next().room;
                return first.getType() == ISchematicRoom.Type.ZONE ? first : null;
            }

            private static boolean isDirectlyBelow(ISchematicRoom room1, ISchematicRoom room2) {
                Floor floor1 = Pre221FlowPathUtil.getLevel(room1);
                if (floor1 == null) {
                    return false;
                }
                Floor floor2 = Pre221FlowPathUtil.getLevel(room2);
                if (floor2 == null) {
                    return false;
                }
                VentusData md = Objects.requireNonNull((VentusData)room1.getDomain());
                int i1 = md.floors.indexOf(floor1);
                int i2 = md.floors.indexOf(floor2);
                return i1 >= 0 && i2 >= 0 && i2 == i1 - 1;
            }

            private static Floor getLevel(ISchematicRoom obj) {
                if (obj == null) {
                    return null;
                }
                return obj.getLevel();
            }
        }

        private static class Pre221SchematicRoom {
            private Pre221SchematicRoom() {
            }

            private static Point3d getZProjectedLoc(ISchematicRoom room, Point3d loc) {
                Point3d tolLoc = Util3D.add(loc, (Tuple3d)new Point3d(0.0, 0.0, 0.001));
                Collection<GeomUtil.FindResult> isects = GeomUtil.findRoomIsects(Collections.singleton(room), () -> {}, tolLoc, Util3D.VEC3D_ZNEG, Double.MAX_VALUE, (r, comp) -> !ISchematicRoom.IWallComponent.class.isInstance(comp));
                if (isects.isEmpty()) {
                    return null;
                }
                return isects.iterator().next().p;
            }
        }

        private static class Pre221FlowPath {
            private Pre221FlowPath() {
            }

            private static UnitDouble getGeometryElevation(FlowPath fp) {
                return Pre221FlowPathUtil.getGeometryElevation(fp.getConnection(FlowPath.ConnectionProps.START));
            }

            private static Pair<ISchematicRoom, ISchematicRoom> getZones(VentusData vd, FlowPath.Connection c1, FlowPath.Connection c2) {
                ISchematicRoom startComp = c1.comp();
                ISchematicRoom endComp = c2.comp();
                if (startComp == null || endComp == null) {
                    return FlowPath.INVALID_ZONES;
                }
                if (Pre221FlowPath.isFloorPath(c1, c2)) {
                    if (vd == null) {
                        return FlowPath.INVALID_ZONES;
                    }
                    endComp = Pre221FlowPathUtil.getRoomBelow(vd, startComp, c1.p());
                    if (endComp == null) {
                        endComp = FlowPath.AMBIENT_ZONE;
                    }
                    if (startComp.getType() == ISchematicRoom.Type.CEILING) {
                        startComp = endComp;
                        endComp = FlowPath.AMBIENT_ZONE;
                    }
                    return new Pair<ISchematicRoom, ISchematicRoom>(startComp, endComp);
                }
                ISchematicRoom.IWallComponent startWall = c1.wall();
                if (startWall != null && startComp == endComp) {
                    return new Pair<ISchematicRoom, ISchematicRoom>(startComp, FlowPath.AMBIENT_ZONE);
                }
                ISchematicRoom.IWallComponent endWall = c2.wall();
                if (startWall != null && endWall != null) {
                    return new Pair<ISchematicRoom, ISchematicRoom>(startComp, endComp);
                }
                return FlowPath.INVALID_ZONES;
            }

            private static boolean isFloorPath(FlowPath.Connection c1, FlowPath.Connection c2) {
                return c1.wall() == null && c1.comp() == c2.comp();
            }
        }
    }
}

