/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.feature.flowpaths.FlowPath;
import ventus.mv.gui.PropConnections;

public class FlowPathMarkerDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private PropConnections.BoolPropConnection d_overwriteColor = SelectionRibbonHelper.boolConn(FlowPath.OVERWRITE_COLOR);
    private PropConnections.ColorConn d_color;
    private PropConnections.UDPropConnection d_size;

    public FlowPathMarkerDlg(Window owner, Collection<? extends IMerlinObj> objs) {
        super(owner, Intl.intl("Marker"), 9);
        ((guiMultiStateCheckBox)this.d_overwriteColor.getControl()).setText(Intl.intl("Color:"));
        ((guiMultiStateCheckBox)this.d_overwriteColor.getControl()).setToolTipText(Intl.intl("Specify custom color."));
        this.d_color = new PropConnections.ColorConn(new ColorButton(), (TypedProp<Color>)FlowPath.COLOR);
        ((ColorButton)this.d_color.getControl()).setBorder(UIManager.getBorder("Button.border"));
        LinkStatus.link((AbstractButton)this.d_overwriteColor.getControl(), new Component[]{this.d_color.getControl()});
        this.d_size = SelectionRibbonHelper.udConn(FlowPath.SIZE, 0);
        BaseUnit u = VentusApp.getApp() != null ? VentusApp.getApp().getUnitSystem().getLength() : SI.METER;
        ((guiValueField)this.d_size.getControl()).setValueRange(UnitDoubleVR.above(0.0, u, true));
        guiLabel szPropLabel = guiUtil.lbl(Intl.intl("Diameter:"), Intl.intl("Diameter of flow path symbol."));
        this.getDialogPane().setLayout(new MigLayout("insets 0, gap 6"));
        this.getDialogPane().add((Component)this.d_overwriteColor.getControl());
        this.getDialogPane().add((Component)this.d_color.getControl(), "growx, wrap");
        this.getDialogPane().add(szPropLabel);
        this.getDialogPane().add((Component)this.d_size.getControl(), "wrap");
        Stream.of(this.d_overwriteColor, this.d_color, this.d_size).forEach(obj -> obj.setLive(false));
        List<IMerlinObj> imoView = objs.stream().map(obj -> obj).toList();
        Stream.of(this.d_overwriteColor, this.d_color, this.d_size).forEach(obj -> obj.bind(imoView));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (((guiMultiStateCheckBox)this.d_overwriteColor.getControl()).isSelected() && ((ColorButton)this.d_color.getControl()).getColor() == null) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Please select a color."));
            }
            return false;
        }
        return true;
    }

    public void save() {
        Stream.of(this.d_overwriteColor, this.d_color, this.d_size).forEach(obj -> obj.commit());
    }

    public static String getDescription(Collection<? extends IMerlinObj> objs) {
        PropValue<Boolean> overwriteColor = CompositePropertyUtil.getValue(FlowPath.OVERWRITE_COLOR, objs);
        PropValue<UnitDouble> size = CompositePropertyUtil.getValue(FlowPath.SIZE, objs);
        String strColor = Intl.intl("Default");
        if (!overwriteColor.isUniform() || overwriteColor.get().booleanValue()) {
            strColor = Intl.intl("Custom");
        }
        String strSz = size.isUniform() ? size.get().toString() : "Multi";
        return String.format("%s, %s", strColor, strSz);
    }
}

