/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedFunction;
import thunderheadeng.util.CachedPredicate;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.RoomUtil;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathDispProps;
import ventus.feature.flowpaths.FlowPathInitConnection;
import ventus.feature.flowpaths.FlowPathUtil;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.IMerlinDispProps;
import ventus.mv.tools.RoomSnapConstraint;

public class FlowPathGeometry
extends GeomGroup {
    private static final long serialVersionUID = 1L;
    public static final int DOTTED_STIPPLE = IPrimProps.Edge.makeStipple(4, (short)-3856);
    public final FlowPath.Connection begin;
    public final FlowPath.Connection end;
    private final FlowPathInitConnection d_initType;
    private final boolean d_isExterior;
    private final boolean d_isVertical;
    private final double d_size;
    private static final CachedValue<IGeom> cache_sphere = new CachedValue();
    private static final CachedValue<IGeom> s_unitOctahedron = new CachedValue();

    public FlowPathGeometry(FlowPathInitConnection initType, FlowPath.Connection begin, FlowPath.Connection end, boolean isExterior, boolean isVertical, double size) {
        super(FlowPathGeometry.generateGeoms(begin, end, isExterior, size, true));
        this.d_initType = initType;
        this.begin = begin;
        this.end = end;
        this.d_isExterior = isExterior;
        this.d_isVertical = isVertical;
        this.d_size = size;
    }

    @Override
    public void generateManipHandles(Consumer<? super IHandle> handles) {
        handles.accept(new Handle(this, true));
        Optional<Boolean> vertical = this.isDesiredVertical();
        if (!vertical.orElse(true).booleanValue() && !this.isDesiredExterior()) {
            handles.accept(new Handle(this, false));
        }
    }

    private boolean isDesiredExterior() {
        if (this.d_initType.equals(FlowPathInitConnection.UnSet)) {
            return this.d_isExterior;
        }
        return this.d_initType.equals(FlowPathInitConnection.IntExt);
    }

    protected Optional<Boolean> isDesiredVertical() {
        if (!this.d_isVertical) {
            return Optional.of(false);
        }
        return this.begin.comp() != null && this.end.comp() != null ? Optional.of(true) : Optional.empty();
    }

    public Pair<IGeomNode, IPropsSrc> getRenderData(FlowPath fp, IMerlinDispProps appProps) {
        AGeomNode geom = GeomNodeUtil.newNode(this);
        PropsBuilder pb = new PropsBuilder();
        Color edgeColor = fp.getColor().darker();
        if (this.d_isExterior) {
            shape = FlowPathGeometry.generateOctahedron();
            faces = shape.getNumPrims(1);
            edges = shape.getNumPrims(2);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
        } else {
            shape = FlowPathGeometry.generateSphere();
            faces = shape.getNumPrims(1);
            edges = shape.getNumPrims(2);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
        }
        IPrimProps edgeProps = appProps.getEdgeProps(fp, IMerlinDispProps.SchematicType.BOUNDARY, null, 1.0f);
        pb.add(new IPrimProps.Edge(edgeProps.getColor(), edgeProps.getEdgeWidth(), DOTTED_STIPPLE, 0));
        EnumSet<FlowPathDispProps.Options> fpOptions = appProps.get(FlowPathDispProps.OPTIONS);
        if (fpOptions.contains((Object)FlowPathDispProps.Options.SHOW_AREA_CALCULATION)) {
            Pair<UnitDouble, IGeom> mi = fp.getMultiplierInfo();
            if (!((IGeom)mi.v2).isEmpty(true) && !fp.getName().equals("")) {
                ArrayList<GeomNodeLeaf> nodes = new ArrayList<GeomNodeLeaf>(2);
                nodes.add((GeomNodeLeaf)geom);
                nodes.add(GeomNodeUtil.newNode((IGeom)mi.v2));
                geom = GeomNodeUtil.newNode(nodes);
                int numEdges = ((IGeom)mi.v2).getNumPrims(2);
                int numFaces = ((IGeom)mi.v2).getNumPrims(1);
                assert (numEdges != 0 ^ numFaces != 0);
                if (numEdges != 0) {
                    pb.add(new IPrimProps.Edge(FlowPathDispProps.FLOW_AREA_COLOR, 5.0, IPrimProps.DEF_STIPPLE, 0), numEdges);
                }
                if (numFaces != 0) {
                    pb.add(new IPrimProps.Face(FlowPathDispProps.FLOW_AREA_COLOR, null, 0), numFaces);
                }
            }
        }
        return new Pair<IGeomNode, IPropsSrc>(geom, pb.finalizeProps());
    }

    private static List<IGeom> generateGeoms(FlowPath.Connection begin, FlowPath.Connection end, boolean isExterior, double size, boolean connectEndpoints) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        geoms.add(FlowPathGeometry.getEndcapShape(isExterior, begin, size));
        geoms.add(FlowPathGeometry.getEndcapShape(isExterior, end, size));
        if (connectEndpoints) {
            LineSeg lineGeom = new LineSeg(begin.p(), end.p());
            geoms.add(lineGeom);
        }
        return geoms;
    }

    private static IGeom getEndcapShape(boolean isExterior, FlowPath.Connection conn, double size) {
        IGeom endCapShape = isExterior ? FlowPathGeometry.generateOctahedron() : FlowPathGeometry.generateSphere();
        ITransform xform = TransformUtil.translate(conn.p());
        xform = xform.concatenate(new MatrixXform(Util.getLocalToWorldXform(new Plane3d(conn.normal(), GeomConstants.PNT3D_ORIGIN))));
        xform = xform.concatenate(TransformUtil.scale(size, size, size));
        return endCapShape.transform(xform.getInfo(), 0);
    }

    private static IGeom generateSphere() {
        return cache_sphere.get(() -> {
            int stacks = 6;
            int slices = 6;
            double size = 0.4;
            ArrayList<Point3d> verts = new ArrayList<Point3d>();
            verts.add(new Point3d(0.0, size, 0.0));
            for (int i = 0; i < stacks - 1; ++i) {
                double phi = Math.PI * ((double)(i + 1) / (double)stacks);
                for (int j = 0; j < slices; ++j) {
                    double theta = Math.PI * 2 * ((double)j / (double)slices);
                    Point3d pt = new Point3d(Math.cos(theta) * Math.sin(phi) * size, Math.cos(phi) * size, Math.sin(theta) * Math.sin(phi) * size);
                    verts.add(pt);
                }
            }
            verts.add(new Point3d(0.0, -size, 0.0));
            ArrayList<Integer> triFaceIndices = new ArrayList<Integer>();
            ArrayList<Integer> creaseSegIndices = new ArrayList<Integer>();
            for (int i = 0; i < slices; ++i) {
                int t0 = 0;
                int t1 = (i + 1) % slices + 1;
                int t2 = i + 1;
                triFaceIndices.addAll(Arrays.asList(t0, t1, t2));
                creaseSegIndices.addAll(Arrays.asList(t0, t1, t2, t0));
                int b0 = i + slices * (stacks - 2) + 1;
                int b1 = (i + 1) % slices + slices * (stacks - 2) + 1;
                int b2 = verts.size() - 1;
                triFaceIndices.addAll(Arrays.asList(b0, b1, b2));
                creaseSegIndices.addAll(Arrays.asList(b0, b1, b2, b0));
            }
            for (int j = 0; j < stacks - 2; ++j) {
                int j0 = j * slices + 1;
                int j1 = (j + 1) * slices + 1;
                for (int i = 0; i < slices; ++i) {
                    int i0 = j0 + i;
                    int i1 = j0 + (i + 1) % slices;
                    int i2 = j1 + (i + 1) % slices;
                    int i3 = j1 + i;
                    triFaceIndices.addAll(Arrays.asList(i0, i1, i2));
                    triFaceIndices.addAll(Arrays.asList(i2, i3, i0));
                    creaseSegIndices.addAll(Arrays.asList(i0, i1, i1, i2, i2, i3, i3, i0));
                }
            }
            Mesh sphere = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(triFaceIndices), 2, 4);
            Mesh creases = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(creaseSegIndices), 1, 0);
            GeomGroup sphereAndCreases = new GeomGroup(Arrays.asList(sphere, creases));
            ITransform rot90 = TransformUtil.rotate(1.0, 0.0, 0.0, 1.5707963267948966);
            return sphereAndCreases.transform(rot90.getInfo(), 0);
        });
    }

    private static IGeom generateOctahedron() {
        return s_unitOctahedron.get(() -> {
            Point3d lx;
            double size = 0.5;
            Point3d top = new Point3d(0.0, 0.0, size);
            Point3d bot = new Point3d(0.0, 0.0, -size);
            Point3d ly = new Point3d(0.0, size, 0.0);
            Point3d v1 = lx = new Point3d(size, 0.0, 0.0);
            Point3d v2 = ly;
            Point3d v3 = Util3D.scale(lx, -1.0);
            Point3d v4 = Util3D.scale(ly, -1.0);
            int itop = 4;
            int ibot = 5;
            Point3d[] verts = new Point3d[]{v1, v2, v3, v4, null, null};
            verts[itop] = top;
            verts[ibot] = bot;
            ArrayList ixes = new ArrayList();
            TriConsumer<Integer, Integer, Integer> addTri = (i1, i2, i3) -> {
                ixes.add(i1);
                ixes.add(i2);
                ixes.add(i3);
            };
            for (int i = 0; i < 4; ++i) {
                int j = (i + 1) % 4;
                addTri.accept(itop, i, j);
                addTri.accept(ibot, j, i);
            }
            Mesh m = new Mesh(verts, theUtil.toIntArray(ixes), 2);
            Mesh outlines = m.generateOutlines();
            return new GeomGroup(Arrays.asList(m, outlines));
        });
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        ITransform.ITransformer xformer = ti.getTransformer();
        return new FlowPathGeometry(this.d_initType, new FlowPath.Connection(xformer.transformNew(this.begin.p()), xformer.transformNew(this.begin.normal()), null, null), new FlowPath.Connection(xformer.transformNew(this.end.p()), xformer.transformNew(this.end.normal()), null, null), this.d_isExterior, this.d_isVertical, this.d_size);
    }

    private static class Handle
    extends AHandle {
        public Handle(FlowPathGeometry geom, boolean point1) {
            super(geom, point1);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            Optional<Boolean> vertical = this.isDesiredVertical();
            if (vertical.orElse(false).booleanValue()) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return null;
                }
                return this.getVerticalConstraint(vd);
            }
            if (this.isDesiredExterior()) {
                return new ExteriorConstraint();
            }
            return new ConnectionConstraint();
        }

        private ISnapConstraint getVerticalConstraint(VentusData vd) {
            Predicate<IsectInfo> snapFilter = this.getVerticalSnapFilter(vd);
            return new RoomSnapConstraint(vd, null, this.getVerticalRoomFilter(), snapFilter);
        }

        private Predicate<IsectInfo> getVerticalSnapFilter(VentusData vd) {
            return new CachedPredicate<IsectInfo>(isect -> {
                if (isect.getFaceNormal == null) {
                    return false;
                }
                Object patt0$temp = isect.obj;
                if (!(patt0$temp instanceof ISchematicRoom)) {
                    return false;
                }
                ISchematicRoom room = (ISchematicRoom)patt0$temp;
                try (VentusData.ReadLock lock = vd.lockRead();){
                    boolean bl = this.testVerticalLoc(vd, room, isect.isectPoint);
                    return bl;
                }
            });
        }

        private boolean testVerticalLoc(VentusData vd, ISchematicRoom room, Point3d p) {
            GeomUtil.FindResult roomBelow = FlowPathUtil.findRoomBelow(vd, room, p);
            Pair<ISchematicRoom, ISchematicRoom> zones = FlowPath.getZones(room, roomBelow != null ? roomBelow.room : room, null, null, true);
            if (zones.equals(FlowPath.INVALID_ZONES)) {
                return false;
            }
            boolean exterior = FlowPath.isExterior(zones);
            return exterior == this.isDesiredExterior();
        }

        private BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getVerticalRoomFilter() {
            return (room, component) -> component instanceof ISchematicRoom.ICeilingComponent || component instanceof ISchematicRoom.IFloorComponent;
        }

        private static IsectInfo toIsect(FlowPath.Connection conn) {
            return Handle.toIsect(conn.comp(), conn.wall(), conn.normal(), conn.p());
        }

        private static IsectInfo toIsect(ISchematicRoom room, ISchematicRoom.IComponent comp, Vector3d normal, Point3d p) {
            IPropertySet elems = Elements.newElements();
            elems.setIfNotDefault(ISchematicRoom.COMPONENT_ELEMENT, new ElementUniform<ISchematicRoom.IComponent>(comp));
            return new IsectInfo(GeomType.FACE, room, p, null, () -> normal, new Elements.PrimElements(elems, 0), null, null);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
        }

        @Override
        protected FlowPathGeometry modifyImpl(FlowPathGeometry previous, IsectInfo constraintInfo, Point3d snappedPos) throws ManipException {
            ISchematicRoom room;
            VentusData vd;
            block16: {
                block15: {
                    vd = VentusApp.getAppData();
                    if (vd == null) {
                        throw new ManipException();
                    }
                    assert (constraintInfo != null);
                    if (constraintInfo == null) {
                        throw new ManipException();
                    }
                    Object object = constraintInfo.obj;
                    if (!(object instanceof ISchematicRoom)) break block15;
                    room = (ISchematicRoom)object;
                    if (constraintInfo.getFaceNormal != null) break block16;
                }
                throw new ManipException();
            }
            Optional<ISchematicRoom.IComponent> comp = constraintInfo.elements.getElement(ISchematicRoom.COMPONENT_ELEMENT);
            if (comp.isEmpty()) {
                throw new ManipException();
            }
            if (comp.get() instanceof ISchematicRoom.ICeilingComponent || comp.get() instanceof ISchematicRoom.IFloorComponent) {
                FlowPath.Connection newConn = new FlowPath.Connection(snappedPos, constraintInfo.getFaceNormal.get(), room, null);
                return new FlowPathGeometry(previous.d_initType, newConn, newConn, this.isDesiredExterior(), true, previous.d_size);
            }
            ISchematicRoom.IWallComponent wall = theUtil.cast(comp, ISchematicRoom.IWallComponent.class).orElse(null);
            assert (wall != null) : "Encountered unsupported zone element in manipulation.";
            if (wall == null) {
                throw new ManipException();
            }
            FlowPath.Connection newConn = new FlowPath.Connection(snappedPos, constraintInfo.getFaceNormal.get(), room, wall);
            if (this.isDesiredExterior()) {
                return new FlowPathGeometry(previous.d_initType, newConn, newConn, true, false, previous.d_size);
            }
            FlowPath.Connection[] conns = new FlowPath.Connection[]{newConn, this.getOtherConn()};
            FlowPath.Connection sharedConn = FlowPathUtil.findSharedWallLocation(vd, () -> {}, room, snappedPos);
            if (sharedConn != null) {
                conns[1] = sharedConn;
            }
            if (!this.d_point1) {
                theUtil.swap(conns, 0, 1);
            }
            if (conns[0].comp() != null && conns[1].comp() != null) {
                UnitDouble elev = new UnitDouble(newConn.p().z, Geometry.LENGTH_UNIT);
                FlowPathUtil.AdjustedElevation adjusted = FlowPathUtil.adjustElevation(elev, conns[0], conns[1]);
                conns[0] = adjusted.c1();
                conns[1] = adjusted.c2();
            }
            if (previous.begin.comp() != previous.end.comp() && previous.begin.comp() == conns[1].comp() && previous.end.comp() == conns[0].comp()) {
                theUtil.swap(conns, 0, 1);
            }
            return new FlowPathGeometry(previous.d_initType, conns[0], conns[1], false, false, previous.d_size);
        }

        private class ExteriorConstraint
        implements ISnapConstraint {
            private ExteriorConstraint() {
            }

            @Override
            public Pair<Point3d, Collection<IsectInfo>> snapRay(Runnable validateProgress, Vector3d viewDir, Point3d rayBegin, Vector3d rayDir) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return null;
                }
                Plane3d projPlane = Handle.this.getProjectionPlane(viewDir, false);
                Point3d isect = Inter3D.rayPlaneIntersection(rayBegin, rayDir, projPlane, 1.0E-9);
                if (isect == null) {
                    return null;
                }
                Collection<IsectInfo> isects = this.snapPoint(validateProgress, isect);
                if (isects.isEmpty()) {
                    return null;
                }
                return new Pair<Point3d, Collection<IsectInfo>>(isect, isects);
            }

            private boolean isSharedLocation(VentusData vd, Runnable validateProgress, ISchematicRoom room, Point3d p) {
                try (VentusData.ReadLock lock2 = vd.lockRead();){
                    GeomUtil.findRooms(vd, p, 1, validateProgress, fr -> {
                        if (fr.room != room && fr.p.epsilonEquals(p, 1.0E-6)) {
                            throw new CancellationException();
                        }
                    });
                }
                catch (CancellationException e) {
                    return true;
                }
                return false;
            }

            @Override
            public Collection<IsectInfo> snapPoint(Runnable validateProgress, Point3d p) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return List.of();
                }
                try (VentusData.ReadLock lock = vd.lockRead();){
                    ArrayList results = new ArrayList();
                    GeomUtil.findRooms(vd, validateProgress, p, Handle.this.getSize() + 1.0E-6, 0, zone -> zone.getType().hasWalls, new TypeFilter(ISchematicRoom.IWallComponent.class), results::add);
                    results.sort((search1, search2) -> Double.compare(search1.p.distanceSquared(p), search2.p.distanceSquared(p)));
                    validateProgress.run();
                    CachedFunction<GeomUtil.FindResult, FlowPath.Connection> toConnection = new CachedFunction<GeomUtil.FindResult, FlowPath.Connection>(roomLoc -> {
                        validateProgress.run();
                        assert (roomLoc.getWall().isPresent());
                        return this.isSharedLocation(vd, validateProgress, roomLoc.room, roomLoc.p) ? null : new FlowPath.Connection(roomLoc.p, roomLoc.faceNormal, roomLoc.room, roomLoc.getWall().orElse(null));
                    });
                    Supplier getIsects = () -> results.stream().map(toConnection).filter(newConn -> newConn != null).map(conn -> {
                        validateProgress.run();
                        return Handle.toIsect(conn);
                    });
                    Collection<IsectInfo> result = theUtil.asCollection(getIsects);
                    if (!result.isEmpty()) {
                        Collection<IsectInfo> collection = result;
                        return collection;
                    }
                    Optional<Boolean> vertical = Handle.this.isDesiredVertical();
                    if (vertical.isEmpty()) {
                        ISnapConstraint verticalConstraint = Handle.this.getVerticalConstraint(vd);
                        Collection<IsectInfo> collection = verticalConstraint.snapPoint(validateProgress, p);
                        return collection;
                    }
                    List<IsectInfo> list = List.of();
                    return list;
                }
            }

            @Override
            public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return List.of();
                }
                CachedPredicate<IsectInfo> horizontalTester = new CachedPredicate<IsectInfo>(isect -> {
                    Object patt0$temp = isect.obj;
                    if (patt0$temp instanceof ISchematicRoom) {
                        ISchematicRoom room = (ISchematicRoom)patt0$temp;
                        if (room.getType().hasWalls && isect.getFaceNormal != null && RoomUtil.getWall(isect.elements).isPresent()) {
                            try (VentusData.ReadLock lock = vd.lockRead();){
                                ISchematicRoom.IWallComponent wall = RoomUtil.getWall(isect.elements).orElse(null);
                                assert (wall != null);
                                boolean bl = !this.isSharedLocation(vd, validateProgress, room, isect.isectPoint);
                                return bl;
                            }
                        }
                    }
                    return false;
                });
                Optional<Boolean> vertical = Handle.this.isDesiredVertical();
                Predicate<Object> verticalTester = vertical.isEmpty() ? Handle.this.getVerticalSnapFilter(vd) : Predicates.alwaysFalse();
                Collection<IsectInfo> fromIsects = theUtil.asCollection(() -> snaps.stream().filter(Predicates.or(horizontalTester, verticalTester)));
                if (!fromIsects.isEmpty()) {
                    return fromIsects;
                }
                Plane3d testPlane = Handle.this.getProjectionPlane(projectionDir, true);
                CachedFunction<IsectInfo, Collection> findNearest = new CachedFunction<IsectInfo, Collection>(isect -> {
                    try (VentusData.ReadLock lock = vd.lockRead();){
                        Collection<IsectInfo> fromPoint;
                        Supplier<Point3d> getTestPoint = () -> {
                            Point3d p;
                            if (projectionDir != null && (p = Inter3D.linePlaneIntersection(isect.isectPoint, projectionDir, testPlane, 1.0E-9)) != null) {
                                return p;
                            }
                            return testPlane.projectOntoPlane(isect.isectPoint);
                        };
                        Point3d testPoint = getTestPoint.get();
                        Collection<IsectInfo> collection = fromPoint = this.snapPoint(validateProgress, testPoint);
                        return collection;
                    }
                });
                return theUtil.asCollection(() -> snaps.stream().map(findNearest).flatMap(c -> c.stream()).filter(isect -> isect != null));
            }

            @Override
            public ISnapConstraint transform(Matrix4d xform) {
                return this;
            }
        }

        private class ConnectionConstraint
        implements ISnapConstraint {
            private ConnectionConstraint() {
            }

            @Override
            public Pair<Point3d, Collection<IsectInfo>> snapRay(Runnable validateProgress, Vector3d viewDir, Point3d rayBegin, Vector3d rayDir) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return null;
                }
                Plane3d projPlane = Handle.this.getProjectionPlane(viewDir, false);
                Point3d isect = Inter3D.rayPlaneIntersection(rayBegin, rayDir, projPlane, 1.0E-9);
                if (isect == null) {
                    return null;
                }
                Collection<IsectInfo> isects = this.snapPoint(validateProgress, isect);
                if (isects.isEmpty()) {
                    return null;
                }
                return new Pair<Point3d, Collection<IsectInfo>>(isect, isects);
            }

            private FlowPath.Connection findWallIsect(VentusData md, Runnable validateProgress, ISchematicRoom requiredRoom, Point3d testPoint) {
                FlowPath.Connection otherConn = Handle.this.getOtherConn();
                FlowPath.Connection[] result = new FlowPath.Connection[]{null};
                try {
                    FlowPathUtil.findWallsBetweenPoints(md, validateProgress, false, otherConn.p(), testPoint, (testRoom, testWall) -> requiredRoom == null || testRoom == requiredRoom, wallIsect -> {
                        FlowPath.Connection newConn = new FlowPath.Connection(wallIsect.isect(), wallIsect.wall().getNormal(), wallIsect.room(), wallIsect.wall());
                        Pair<FlowPath.Connection, FlowPath.Connection> validated = FlowPathUtil.validateConnection(md, validateProgress, newConn, otherConn, false);
                        if (validated == null) {
                            return;
                        }
                        result[0] = newConn;
                        throw new CancellationException();
                    });
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                validateProgress.run();
                return result[0];
            }

            @Override
            public Collection<IsectInfo> snapPoint(Runnable validateProgress, Point3d p) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return List.of();
                }
                try (VentusData.ReadLock lock = vd.lockRead();){
                    List<IsectInfo> list;
                    FlowPath.Connection otherConn = Handle.this.getOtherConn();
                    ArrayList results = new ArrayList();
                    GeomUtil.findRooms(vd, validateProgress, p, Handle.this.getSize() + 1.0E-6, 0, zone -> zone.getType().hasWalls, Predicates.alwaysTrue(), results::add);
                    results.sort((search1, search2) -> Double.compare(search1.p.distanceSquared(p), search2.p.distanceSquared(p)));
                    validateProgress.run();
                    CachedFunction<GeomUtil.FindResult, FlowPath.Connection> toConnection = new CachedFunction<GeomUtil.FindResult, FlowPath.Connection>(roomLoc -> {
                        validateProgress.run();
                        try (VentusData.ReadLock lock2 = vd.lockRead();){
                            ISchematicRoom.IWallComponent wall = roomLoc.getWall().orElse(null);
                            FlowPath.Connection newConn = new FlowPath.Connection(roomLoc.p, roomLoc.faceNormal, roomLoc.room, wall);
                            if (wall != null) {
                                if (otherConn.comp() == null) {
                                    FlowPath.Connection connection = newConn;
                                    return connection;
                                }
                                FlowPath.Connection sharedConn = FlowPathUtil.findSharedWallLocation(vd, validateProgress, roomLoc.room, roomLoc.p);
                                if (sharedConn != null) {
                                    FlowPath.Connection connection = newConn;
                                    return connection;
                                }
                                Pair<FlowPath.Connection, FlowPath.Connection> validated = FlowPathUtil.validateConnection(vd, validateProgress, newConn, otherConn, false);
                                if (validated == null) {
                                    FlowPath.Connection connection = null;
                                    return connection;
                                }
                                FlowPath.Connection connection = newConn;
                                return connection;
                            }
                            if (Handle.this.isDesiredVertical().isEmpty() && Handle.this.testVerticalLoc(vd, roomLoc.room, roomLoc.p)) {
                                FlowPath.Connection connection = newConn;
                                return connection;
                            }
                            FlowPath.Connection connection = this.findWallIsect(vd, validateProgress, roomLoc.room, roomLoc.p);
                            return connection;
                        }
                    });
                    Collection<IsectInfo> result = theUtil.asCollection(() -> results.stream().map(toConnection).filter(newConn -> newConn != null).map(conn -> {
                        validateProgress.run();
                        return Handle.toIsect(conn);
                    }));
                    if (!result.isEmpty()) {
                        Collection<IsectInfo> collection = result;
                        return collection;
                    }
                    validateProgress.run();
                    FlowPath.Connection wallIsect = this.findWallIsect(vd, validateProgress, null, p);
                    if (wallIsect != null) {
                        list = List.of(Handle.toIsect(wallIsect));
                        return list;
                    }
                    list = List.of();
                    return list;
                }
            }

            @Override
            public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
                VentusData vd = VentusApp.getAppData();
                if (vd == null) {
                    return List.of();
                }
                CachedFunction<IsectInfo, IsectInfo> validSnapMapper = new CachedFunction<IsectInfo, IsectInfo>(isect -> {
                    ISchematicRoom room;
                    block16: {
                        block15: {
                            Object patt0$temp = isect.obj;
                            if (!(patt0$temp instanceof ISchematicRoom)) break block15;
                            room = (ISchematicRoom)patt0$temp;
                            if (isect.getFaceNormal != null) break block16;
                        }
                        return null;
                    }
                    ISchematicRoom.IWallComponent wall = RoomUtil.getWall(isect.elements).orElse(null);
                    if (wall != null) {
                        try (VentusData.ReadLock lock = vd.lockRead();){
                            FlowPath.Connection otherConn = Handle.this.getOtherConn();
                            if (otherConn.comp() == null) {
                                IsectInfo isectInfo = isect;
                                return isectInfo;
                            }
                            FlowPath.Connection sharedConn = FlowPathUtil.findSharedWallLocation(vd, validateProgress, room, isect.isectPoint);
                            if (sharedConn != null) {
                                IsectInfo isectInfo = isect;
                                return isectInfo;
                            }
                            FlowPath.Connection newConn = new FlowPath.Connection(isect.isectPoint, isect.getFaceNormal.get(), room, wall);
                            Pair<FlowPath.Connection, FlowPath.Connection> validated = FlowPathUtil.validateConnection(vd, validateProgress, newConn, otherConn, false);
                            IsectInfo isectInfo = validated != null ? isect : null;
                            return isectInfo;
                        }
                    }
                    if (Handle.this.isDesiredVertical().isEmpty() && Handle.this.testVerticalLoc(vd, room, isect.isectPoint)) {
                        return isect;
                    }
                    return null;
                });
                Collection<IsectInfo> result = theUtil.asCollection(() -> snaps.stream().map(validSnapMapper).filter(isect -> isect != null));
                if (!result.isEmpty()) {
                    return result;
                }
                Plane3d testPlane = Handle.this.getProjectionPlane(projectionDir, true);
                CachedFunction<IsectInfo, Collection> noSnapMapper = new CachedFunction<IsectInfo, Collection>(isect -> {
                    validateProgress.run();
                    try (VentusData.ReadLock lock = vd.lockRead();){
                        Collection<IsectInfo> fromPoint;
                        Supplier<Point3d> getTestPoint = () -> {
                            Point3d p;
                            if (projectionDir != null && (p = Inter3D.linePlaneIntersection(isect.isectPoint, projectionDir, testPlane, 1.0E-9)) != null) {
                                return p;
                            }
                            return testPlane.projectOntoPlane(isect.isectPoint);
                        };
                        Point3d testPoint = getTestPoint.get();
                        Collection<IsectInfo> collection = fromPoint = this.snapPoint(validateProgress, testPoint);
                        return collection;
                    }
                });
                return theUtil.asCollection(() -> snaps.stream().map(noSnapMapper).flatMap(c -> c.stream()).filter(isect -> isect != null));
            }

            @Override
            public ISnapConstraint transform(Matrix4d xform) {
                return this;
            }
        }
    }

    private static abstract class AHandle
    implements IHandle {
        protected final boolean d_point1;
        private FlowPathGeometry d_geom;
        private final FlowPathGeometry d_originalGeom;

        public AHandle(FlowPathGeometry geom, boolean point1) {
            this.d_geom = geom;
            this.d_originalGeom = geom;
            this.d_point1 = point1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AHandle handle = (AHandle)obj;
            return this.d_point1 == handle.d_point1;
        }

        @Override
        public IGeomNode getGeom() {
            IGeom geom = FlowPathGeometry.getEndcapShape(this.d_geom.d_isExterior, this.d_point1 ? this.d_geom.begin : this.d_geom.end, this.d_geom.d_size);
            return GeomNodeUtil.newNode(geom);
        }

        protected double getSize() {
            return this.d_originalGeom.d_size;
        }

        protected FlowPath.Connection getOtherConn() {
            return this.d_point1 ? this.d_originalGeom.end : this.d_originalGeom.begin;
        }

        protected Plane3d getProjectionPlane(Vector3d projectionDir, boolean alignWithThisConn) {
            FlowPath.Connection base;
            FlowPath.Connection connection = alignWithThisConn ? (this.d_point1 ? this.d_originalGeom.begin : this.d_originalGeom.end) : (base = this.d_point1 ? this.d_originalGeom.end : this.d_originalGeom.begin);
            if (projectionDir != null) {
                return new Plane3d(projectionDir, base.p());
            }
            return new Plane3d(GeomConstants.VEC3D_ZPOS, base.p());
        }

        protected boolean isDesiredExterior() {
            return this.d_originalGeom.isDesiredExterior();
        }

        protected Optional<Boolean> isDesiredVertical() {
            return this.d_originalGeom.isDesiredVertical();
        }

        protected abstract FlowPathGeometry modifyImpl(FlowPathGeometry var1, IsectInfo var2, Point3d var3) throws ManipException;

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
            this.d_geom = this.modifyImpl(this.d_originalGeom, constraintInfo, newLoc);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

