/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.ComponentSizeFixer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;
import ventus.feature.dependencies.powerlaw.PowerlawGuiUtil;
import ventus.feature.dependencies.powerlaw.PowerlawMathUtil;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.dependencies.powerlaw.PowerlawUtil;
import ventus.feature.flowpaths.FlowElement;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

class FlowElementEditor
extends guiPanel
implements IEditor<FlowElement> {
    private static final long serialVersionUID = 1L;
    private final PowerlawGuiUtil.Bindings<FlowElement> d_bindings = new PowerlawGuiUtil.Bindings();
    private final List<Consumer<FlowElement>> d_onInit = new ArrayList<Consumer<FlowElement>>();

    public FlowElementEditor(Window owner, UnitSystem us) {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        guiTextField name = this.d_bindings.bind(FlowElement.NAME, new guiTextField());
        name.setEnabled(false);
        guiTextField desc = this.d_bindings.bind(FlowElement.DESC, new guiTextField());
        ColorButton color = this.d_bindings.bind(FlowElement.COLOR, guiUtil.newColorButton());
        guiComboBox<PowerlawModel> cbPowerLaw = PowerlawGuiUtil.createPowerlawCombo(PowerlawModel.Usage.FLOWPATH);
        this.d_bindings.bind(cbPowerLaw, new PowerlawGuiUtil.Binding<FlowElement>(data -> cbPowerLaw.setSelectedItem(data.get(FlowElement.POWERLAW_MODEL)), data -> data.set(FlowElement.POWERLAW_MODEL, (PowerlawModel)cbPowerLaw.getSelectedItem())));
        PowerlawGuiUtil.addRow(this, Intl.intl("Name:"), null, name, "growx, wrap");
        PowerlawGuiUtil.addRow(this, Intl.intl("Description:"), null, desc, "width pref*2.5, growx, wrap");
        PowerlawGuiUtil.addRow(this, Intl.intl("Color:"), null, color, "sg 1, wrap");
        PowerlawGuiUtil.addRow(this, Intl.intl("Model:"), null, cbPowerLaw, "sg 1, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        guiPanel cardsPanel = new guiPanel(new CardLayout());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardOrificeArea(us, this.d_bindings, false), PowerlawModel.ORIFICE_AREA.toString());
        cardsPanel.add((Component)this.createCardLeakageArea(us), PowerlawModel.LEAKAGE_AREA.toString());
        cardsPanel.add((Component)this.createCardStairwell(us), PowerlawModel.STAIRWELL.toString());
        cardsPanel.add((Component)this.createCardShaft(us), PowerlawModel.SHAFT.toString());
        cardsPanel.add((Component)this.createCardSelfRegulatingVent(us), PowerlawModel.SELF_REG_VENT.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardQvP(us, this.d_bindings), PowerlawModel.Q_V_P.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardConstantMassFlowFan(us, this.d_bindings), PowerlawModel.CONSTANT_MASS_FLOW_FAN.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardConstantVolumeFlowFan(us, this.d_bindings), PowerlawModel.CONSTANT_VOLUME_FLOW_FAN.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardPerformanceCurve(us, this.d_bindings), PowerlawModel.PERFORMANCE_CURVE.toString());
        cardsPanel.add((Component)this.createCardTwoWay(us), PowerlawModel.TWOWAY_ONE.toString());
        cardsPanel.add((Component)this.createCardTwoWay(us), PowerlawModel.TWOWAY_TWO.toString());
        cardsPanel.add((Component)this.createCardTest1Point(us), PowerlawModel.TEST_ONE.toString());
        cardsPanel.add((Component)this.createCardTest2Point(us), PowerlawModel.TEST_TWO.toString());
        cardsPanel.add((Component)this.createCardCrackDescription(us), PowerlawModel.CRACK_DESCRIPTION.toString());
        this.add((Component)cardsPanel, "grow, span, wrap");
        guiPanel coefficientPanel = new guiPanel(new MigLayout());
        ValueField<Double> coefLam = ValueFields.doubleFld();
        coefLam.setEditable(false);
        ValueField<Double> coefTurb = ValueFields.doubleFld();
        coefTurb.setEditable(false);
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        PowerlawGuiUtil.addRow(coefficientPanel, Intl.intl("Laminar Coefficient:"), null, coefLam, "sg 1, wrap");
        PowerlawGuiUtil.addRow(coefficientPanel, Intl.intl("Turbulent Coefficient:"), null, coefTurb, "sg 1, wrap");
        this.add((Component)coefficientPanel, "grow, span, wrap");
        cbPowerLaw.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                CardLayout cards = (CardLayout)cardsPanel.getLayout();
                cards.show(cardsPanel, ((PowerlawModel)evt.getItem()).toString());
                coefficientPanel.setVisible(FlowElementEditor.isLamTurbCalcSupported((PowerlawModel)evt.getItem()));
            }
        });
        ComponentSizeFixer.fromExistingContainer(this).setAllPreferredWidthToMax();
        final Runnable updateCoefs = () -> {
            if (this.validateData(false, false)) {
                FlowElement temp = new FlowElement("");
                this.d_bindings.store(temp);
                if (FlowElementEditor.isLamTurbCalcSupported((PowerlawModel)temp.get(FlowElement.POWERLAW_MODEL))) {
                    coefLam.setValue(PowerlawUtil.getLaminarFlow(temp));
                    coefTurb.setValue(PowerlawUtil.getTurbulentFlow(temp));
                }
            }
        };
        this.getComm().addObserver((src, arg) -> updateCoefs.run());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                updateCoefs.run();
                FlowElementEditor.this.setModified(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private static boolean isLamTurbCalcSupported(PowerlawModel model) {
        return !model.equals(PowerlawModel.SELF_REG_VENT) && !model.equals(PowerlawModel.CONSTANT_MASS_FLOW_FAN) && !model.equals(PowerlawModel.CONSTANT_VOLUME_FLOW_FAN) && !model.equals(PowerlawModel.Q_V_P);
    }

    private guiPanel createCardLeakageArea(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0, hidemode 3", "[left][grow][fill, right]"));
        ValueField<Double> pressureExponent = this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        ValueField<Double> dischargeCoef = this.d_bindings.bind(FlowElement.DISCHARGE_COEFFICIENT, ValueFields.doubleFld(DoubleVR.between(0.1, 1.0, true, true)));
        ValueField<UnitDouble> presDiff = this.d_bindings.bind(FlowElement.PRESSURE_DIFFERENCE, ValueFields.udFld(UnitDoubleVR.above(1.0, SI.PASCAL, true), us.getPressure()));
        guiComboBox<LeakageAreaType> leakAreaType = new guiComboBox<LeakageAreaType>((T[])LeakageAreaType.values());
        this.d_bindings.bind(leakAreaType, new PowerlawGuiUtil.Binding<FlowElement>(data -> leakAreaType.setSelectedItem(data.get(FlowElement.LEAKAGE_AREA_TYPE)), data -> data.set(FlowElement.LEAKAGE_AREA_TYPE, (LeakageAreaType)leakAreaType.getSelectedItem())));
        ValueField<UnitDouble> leakAreaPerItem = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_ITEM, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        ValueField<UnitDouble> leakAreaPerLen = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_LENGTH, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> leakAreaPerArea = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getUnit(10)));
        String areaPerItem = String.format(Intl.intl("Area per Item (%s)"), us.getArea().toString() + "/" + Intl.intl("unit"));
        String areaPerLength = String.format(Intl.intl("Area per Unit Length (%s)"), us.getArea().toString() + "/" + us.getLength().toString());
        String areaPerArea = String.format(Intl.intl("Area per Unit Area (%s)"), us.getArea().toString() + "/" + us.getArea().toString());
        PowerlawGuiUtil.addRow(card, Intl.intl("Type:"), null, leakAreaType, new String[0]);
        List<Component> laPerItemComps = PowerlawGuiUtil.addRow(card, areaPerItem, Intl.intl("Total leakage area per item."), leakAreaPerItem, new String[0]);
        List<Component> laPerLenComps = PowerlawGuiUtil.addRow(card, areaPerLength, Intl.intl("Total leakage per length of the item."), leakAreaPerLen, new String[0]);
        List<Component> laPerAreaComps = PowerlawGuiUtil.addRow(card, areaPerArea, Intl.intl("Total leakage per area of the item."), leakAreaPerArea, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Flow Exponent:"), Intl.intl("Flow coefficient for leakage at the reference pressure difference."), pressureExponent, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Discharge Coefficient:"), "Discharge coefficient for the leakage at the reference pressure difference.", dischargeCoef, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Pressure Difference:"), Intl.intl("Reference pressure difference for the associated leakage."), presDiff, new String[0]);
        Consumer<LeakageAreaType> updateFields = type -> {
            laPerItemComps.forEach(item -> item.setVisible(type == LeakageAreaType.ITEM));
            laPerLenComps.forEach(item -> item.setVisible(type == LeakageAreaType.LENGTH));
            laPerAreaComps.forEach(item -> item.setVisible(type == LeakageAreaType.AREA));
            card.revalidate();
            card.repaint();
        };
        leakAreaType.addItemListener(evt -> updateFields.accept((LeakageAreaType)leakAreaType.getSelectedItem()));
        this.d_onInit.add(fe -> updateFields.accept((LeakageAreaType)leakAreaType.getSelectedItem()));
        return card;
    }

    private guiPanel createCardStairwell(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> dz = this.d_bindings.bind(FlowElement.STAIR_SHAFT_DZ, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> crossSectionalArea = this.d_bindings.bind(FlowElement.CROSS_SECTIONAL_AREA, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER.pow(2), false), us.getArea()));
        ValueField<Double> pressureExponent = ValueFields.doubleFld();
        this.d_bindings.bind(pressureExponent, new PowerlawGuiUtil.Binding<FlowElement>(fe -> pressureExponent.setValue(0.5), fe -> fe.set(FlowElement.PRESSURE_EXPONENT, 0.5)));
        pressureExponent.setEditable(false);
        ValueField<UnitDouble> peopleDens = this.d_bindings.bind(FlowElement.PEOPLE_DENSITY, ValueFields.udFld(DoubleVR.above(0.0, true), us.getPersonsDensity()));
        String stOpen = Intl.intl("Open");
        String stClosed = Intl.intl("Closed");
        guiComboBox<String> stairTreads = new guiComboBox<String>((T[])new String[]{stOpen, stClosed});
        this.d_bindings.bind(stairTreads, new PowerlawGuiUtil.Binding<FlowElement>(data -> {
            Boolean value = (Boolean)data.get(FlowElement.STAIR_TREADS_OPEN);
            stairTreads.setSelectedItem(value != false ? stOpen : stClosed);
        }, data -> {
            String item = (String)stairTreads.getSelectedItem();
            data.set(FlowElement.STAIR_TREADS_OPEN, item == stOpen);
        }));
        PowerlawGuiUtil.addRow(card, Intl.intl("Distance Between Levels:"), Intl.intl("Vertical distance between doorways of the stairwell."), dz, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Cross-Sectional Area:"), Intl.intl("Horizontal cross-section area of stairwell shaft."), crossSectionalArea, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Flow Exponent:"), Intl.intl("Assumed exponent = 0.5 for stairwell."), pressureExponent, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("People Density:"), Intl.intl("People density influences flow resistance in stairwell."), peopleDens, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Stair Treads:"), Intl.intl("Indicate if the stair treads are open to flow."), stairTreads, new String[0]);
        return card;
    }

    private guiPanel createCardShaft(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> dz = this.d_bindings.bind(FlowElement.STAIR_SHAFT_DZ, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> crossSectionalArea = this.d_bindings.bind(FlowElement.CROSS_SECTIONAL_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        ValueField<UnitDouble> perimeter = this.d_bindings.bind(FlowElement.PERIMETER, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> roughness = this.d_bindings.bind(FlowElement.ROUGHNESS, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<Double> flowExponent = this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.above(0.0, false)));
        flowExponent.setEditable(false);
        PowerlawGuiUtil.addRow(card, Intl.intl("Distance Between Levels:"), Intl.intl("Vertical distance between shaft openings."), dz, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Cross-Sectional Shaft Area:"), Intl.intl("Horizontal cross-sectional area of the shaft, not the opening."), crossSectionalArea, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Perimeter:"), Intl.intl("Perimeter of shaft. Used with cross-sectional\narea to calculate hydraulic diameter."), perimeter, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Roughness:"), Intl.intl("Average size of protrusions from shaft wall into airflow."), roughness, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Flow Exponent:"), null, flowExponent, new String[0]);
        Arrays.asList(crossSectionalArea, perimeter, roughness).forEach(vf -> vf.addValueChangeListener(evt -> {
            if (card.validateData(false, false)) {
                PowerlawMathUtil.ShaftCalcOutput result = PowerlawMathUtil.getShaftData(((UnitDouble)dz.getValue()).get(SI.METER), ((UnitDouble)crossSectionalArea.getValue()).get(SI.METER.pow(2)), ((UnitDouble)perimeter.getValue()).get(SI.METER), ((UnitDouble)roughness.getValue()).get(SI.METER));
                flowExponent.setValue(result.flowExponent);
            }
        }));
        return card;
    }

    private guiPanel createCardSelfRegulatingVent(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> maxFlowRate = this.d_bindings.bind(FlowElement.MAX_FLOW_RATE, ValueFields.udFld(DoubleVR.above(0.0, false), us.getVolume().divide(us.getTime())));
        ValueField<UnitDouble> regulatingPressure = this.d_bindings.bind(FlowElement.REGULATING_PRESSURE, ValueFields.udFld(DoubleVR.above(0.0, false), us.getPressure()));
        ValueField<UnitDouble> reverseFlowFraction = this.d_bindings.bind(FlowElement.REVERSE_FLOW_FRACTION, ValueFields.udFld(DoubleVR.above(0.0, false), us.getUnit(10)));
        PowerlawGuiUtil.addRow(card, Intl.intl("Max Flow Rate:"), Intl.intl("Maximum airflow rate allowed through paths using this element."), maxFlowRate, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Regulating Pressure:"), Intl.intl("Approximate pressure difference above which airflow will be limited to the maximum flow rate."), regulatingPressure, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Reverse Flow Fraction:"), Intl.intl("Fraction of the Maximum Flow Rate that this element is limited to when the pressure difference is negative."), reverseFlowFraction, new String[0]);
        return card;
    }

    private guiPanel createCardTwoWay(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> height = this.d_bindings.bind(FlowElement.DOOR_HEIGHT, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> width = this.d_bindings.bind(FlowElement.DOOR_WIDTH, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<Double> dischargeCoef = this.d_bindings.bind(FlowElement.DISCHARGE_COEFFICIENT, ValueFields.doubleFld(DoubleVR.between(0.1, 1.0, true, true)));
        PowerlawGuiUtil.addRow(card, FlowElement.DOOR_HEIGHT.name, FlowElement.DOOR_HEIGHT.desc, height, new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.DOOR_WIDTH.name, FlowElement.DOOR_WIDTH.desc, width, new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.DISCHARGE_COEFFICIENT.name, FlowElement.DISCHARGE_COEFFICIENT.desc, dischargeCoef, new String[0]);
        return card;
    }

    private guiPanel createCardTest1Point(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0, hidemode 3", "[left][grow][fill, right]"));
        PowerlawGuiUtil.addRow(card, FlowElement.PRESSURE_EXPONENT.name, FlowElement.PRESSURE_EXPONENT.desc, this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true))), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.PRESSURE_DIFFERENCE.name, FlowElement.PRESSURE_DIFFERENCE.desc, this.d_bindings.bind(FlowElement.PRESSURE_DIFFERENCE, ValueFields.udFld(UnitDoubleVR.above(1.0, SI.PASCAL, true), us.getPressure())), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.FLOWRATE.name, FlowElement.FLOWRATE.desc, this.d_bindings.bind(FlowElement.FLOWRATE, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.KILOGRAM.divide(SI.SECOND), false), us.getDesignFlowRate())), new String[0]);
        return card;
    }

    private guiPanel createCardTest2Point(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0, hidemode 3", "[left][grow][fill, right]"));
        PowerlawGuiUtil.addRow(card, FlowElement.PRESSURE_DIFFERENCE1.name, FlowElement.PRESSURE_DIFFERENCE1.desc, this.d_bindings.bind(FlowElement.PRESSURE_DIFFERENCE1, ValueFields.udFld(UnitDoubleVR.above(1.0, SI.PASCAL, true), us.getPressure())), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.PRESSURE_DIFFERENCE2.name, FlowElement.PRESSURE_DIFFERENCE2.desc, this.d_bindings.bind(FlowElement.PRESSURE_DIFFERENCE2, ValueFields.udFld(UnitDoubleVR.above(1.0, SI.PASCAL, true), us.getPressure())), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.FLOWRATE1.name, FlowElement.FLOWRATE1.desc, this.d_bindings.bind(FlowElement.FLOWRATE1, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.KILOGRAM.divide(SI.SECOND), false), us.getDesignFlowRate())), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.FLOWRATE2.name, FlowElement.FLOWRATE2.desc, this.d_bindings.bind(FlowElement.FLOWRATE2, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.KILOGRAM.divide(SI.SECOND), false), us.getDesignFlowRate())), new String[0]);
        return card;
    }

    private guiPanel createCardCrackDescription(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        PowerlawGuiUtil.addRow(card, FlowElement.CRACK_LENGTH.name, FlowElement.CRACK_LENGTH.desc, this.d_bindings.bind(FlowElement.CRACK_LENGTH, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER, false), us.getLength())), new String[0]);
        PowerlawGuiUtil.addRow(card, FlowElement.CRACK_WIDTH.name, FlowElement.CRACK_WIDTH.desc, this.d_bindings.bind(FlowElement.CRACK_WIDTH, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER, false), us.getLength())), new String[0]);
        return card;
    }

    @Override
    public void init(FlowElement dataObj) {
        ManagerDlg.defaultInit(this, dataObj, obj -> {
            this.d_bindings.load(dataObj);
            this.d_onInit.forEach(handler -> handler.accept(dataObj));
        });
    }

    @Override
    public FlowElement commit(FlowElement dataObj) {
        return ManagerDlg.defaultCommit(this, dataObj, Intl.intl("Edit Flow Element"), "FlowElementEditor.commit", obj -> this.d_bindings.store(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

