/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.GroupedSequence;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.ScenarioData;
import ventus.data.VentusData;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.comps.IScenarioParameterSrc;
import ventus.gui.guiUtil;
import ventus.io.FileUtil;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjWriter;

public class ExportPrj
extends AMerlinOp {
    static final UIHook UI_HOOK = new UIHook(new ExportPrj(), Intl.intl("CONTAM PRJ File...,-,Write simulator input"));

    @Override
    public void run(VentusApp app, VentusData md) {
        int option;
        guiJFXFileChooser chooser = new guiJFXFileChooser(md.getNewFilename(FileUtil.Types.CONTAM_PRJ), MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_CONTAM);
        File prjInputFile = chooser.showSaveDialog();
        if (prjInputFile == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, prjInputFile.getParent());
        ScenarioData sd = new ScenarioData(md, app.getComponents(IScenarioParameterSrc.class));
        if (sd.getScenarioCount() > 1 && (option = guiUtil.showConfirmDialog(app.getActiveFrame(), Intl.intl("Only one scenario will be exported."), Intl.intl("Multiple Scenarios"), 2, 0)) != 0) {
            return;
        }
        PrjData exportData = ScenarioData.getScenarioPrjData(app.getComponents(IPrjDataWriter.class), app, md, sd.getScenario(0));
        boolean modifyForContamW = guiUtil.showConfirmDialog(app.getActiveFrame(), Intl.intl("Maximize CONTAMW compatibility?"), Intl.intl("CONTAMW Compatibility"), 0, 0) == 0;
        StringWriter buffer = new StringWriter();
        PrintWriter buffWriter = new PrintWriter(buffer);
        PrjWriter.writePrjFile(buffWriter, exportData);
        String prjString = buffer.toString();
        if (modifyForContamW) {
            prjString = ExportPrj.modifyForContamW(prjString);
        }
        try (PrintStream stream = new PrintStream(prjInputFile, StandardCharsets.UTF_8);
             OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter((Writer)streamWriter, true);){
            writer.println(prjString);
        }
        catch (IOException e) {
            e.printStackTrace();
            app.error(Intl.intl("Error Exporting PRJ File"), e.getMessage());
        }
    }

    private static String modifyForContamW(String prjString) {
        Predicate<String> flowElemDescLine = Pattern.compile("\\s+lam\\s+turb\\s+expt.*").asMatchPredicate();
        CharSequence[] lines = prjString.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            if (!flowElemDescLine.test((String)lines[i])) continue;
            String compat = StringUtils.truncate((String)lines[i], 62);
            lines[i] = compat;
        }
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    static IAppMenuItem getAppMenuItemComp() {
        return root -> {
            GroupedSequence exportMenuNode = root.getNode("file").getNode("export");
            exportMenuNode.add(UI_HOOK.getMenuItem());
        };
    }
}

