/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.ducts.ISegmentObj;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.geom.Geometry;

public class SegmentWaypoint
extends NamedMerlinObj
implements Serializable,
ISegmentObj,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<SegmentWaypoint> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(SegmentWaypoint.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrFireEvents((p, wp) -> wp.changedEvt(p, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY)).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"SegmentWaypoint.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(SegmentWaypoint::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(SegmentWaypoint::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Point3d> LOCATION = TypedProps.build("SegmentWaypoint.LOCATION", Point3d.class, new Point3d()).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents((prop, obj) -> obj.changedEvt(prop, VentusData.TOPOLOGY)).attrFinish();
    public static final DisplayProp<UnitDouble> RELATIVE_ELEVATION = (DisplayProp)DisplayProps.build((Object)"Junction.RELATIVE_ELEVATION", new UnitDouble(0.0, SI.METER), Intl.intl("Rel. Height"), Intl.intl("Elevation relative to the placement level's working Z location."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    private PropertySet d_properties = new PropertySet();

    public SegmentWaypoint(String name, Point3d rootLocation, UnitDouble relHt) {
        super(name);
        this.set(LOCATION, rootLocation);
        this.set(RELATIVE_ELEVATION, relHt);
    }

    public Floor getLevel() {
        Floor[] floor = VentusApp.getAppData().floors.getSurroundingFloors(new UnitDouble(this.get(SegmentWaypoint.LOCATION).z, Geometry.LENGTH_UNIT));
        if (floor[0] == null) {
            return VentusApp.getAppData().floors.getActive();
        }
        return floor[0];
    }

    public Point3d getRootLocation() {
        return this.get(LOCATION);
    }

    public Point3d getElevatedLocation() {
        Point3d loc = this.get(LOCATION);
        double height = this.getLevel().getWorkingZ().add(this.get(RELATIVE_ELEVATION)).getValue(Geometry.LENGTH_UNIT);
        height = Math.min(height, loc.z + this.getLevel().getHeight().getValue(Geometry.LENGTH_UNIT) * 0.99);
        return new Point3d(loc.x, loc.y, height);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        this.pauseUpdates();
        if (geom instanceof WaypointGeom) {
            WaypointGeom nGeom = (WaypointGeom)geom;
            this.set(LOCATION, nGeom.loc);
        } else if (geom instanceof Point) {
            Point point = (Point)geom;
            this.set(LOCATION, point.loc);
        }
        this.resumeUpdates();
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getWaypointGeom());
    }

    private WaypointGeom getWaypointGeom() {
        Point3d loc = this.get(LOCATION);
        return new WaypointGeom(this.getElevatedLocation());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder qpnProps = new PropsBuilder();
        qpnProps.add(new IPrimProps.Vertex(Color.BLACK, 20.0));
        return new DisplayGeom(geom, qpnProps);
    }

    @Override
    public boolean isVisible() {
        return this.get(STORED_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return true;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        return true;
    }

    private static class WaypointGeom
    extends Point {
        private static final long serialVersionUID = 8317140899487626475L;

        public WaypointGeom(Point3d loc) {
            super(loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new WaypointManipHandle(this));
        }
    }

    private static class WaypointManipHandle
    implements IHandle {
        private WaypointGeom geom;

        public WaypointManipHandle(WaypointGeom geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof WaypointManipHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            double z = VentusApp.getAppData().floors.getActive().getWorkingZ().getValue(Geometry.LENGTH_UNIT);
            return new PlanarConstraint(new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, z)));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
            this.geom = new WaypointGeom(newLoc);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

