/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.format.StringFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.SequentialNameGen;
import ventus.data.VentusData;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctFlowElementData;
import ventus.feature.ducts.DuctFlowElementRoot;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class SegmentBuilder
extends MerlinProps
implements IEventObserver {
    private static final String VALTYPE_JUNCTION_A = "JUNCA";
    private static final String VALTYPE_JUNCTION_B = "JUNCB";
    private static final String VALTYPE_NEW_WAYPOINT = "WAYPOINT";
    protected ValueEditor d_valueEditor;
    public static final Object COMPLETED = new Object();
    private Point3d d_hoveringPoint;
    private Junction d_hoveringJunc = null;
    private SegmentWaypoint d_activeWaypoint = null;
    private ArrayList<SegmentWaypoint> d_waypoints;
    private final Segment d_segment = new Segment("");

    public SegmentBuilder() {
        this.d_hoveringPoint = new Point3d(0.0, 0.0, 0.0);
        this.d_waypoints = new ArrayList();
        VentusApp.getAppData().getEvents().addObserver(this);
    }

    private Junction getJunctionA() {
        return this.get(Segment.JUNCTION_A);
    }

    private Junction getJunctionB() {
        return this.get(Segment.JUNCTION_B);
    }

    protected void initValueEditor(Component attachedComponent) {
        if (this.d_valueEditor != null) {
            return;
        }
        this.d_valueEditor = new ValueEditor(attachedComponent);
        if (this instanceof ValueEditor.IListener) {
            this.d_valueEditor.addListener((ValueEditor.IListener)((Object)this));
        }
        this.d_valueEditor.addChoice(VALTYPE_JUNCTION_A, new ValueEditor.Choice(Intl.intl("Junction A"), new guiFormattedFld<Object>(new StringFormat(), null)));
        this.d_valueEditor.addChoice(VALTYPE_JUNCTION_B, new ValueEditor.Choice(Intl.intl("Junction B"), new guiFormattedFld<Object>(new StringFormat(), null)));
        this.d_valueEditor.addChoice(VALTYPE_NEW_WAYPOINT, new ValueEditor.Choice(Intl.intl("New Waypoint"), new guiFormattedFld<Object>(new StringFormat(), null)));
        this.d_valueEditor.setValueType(VALTYPE_JUNCTION_A);
    }

    public void setHoveringJunction(Junction j) {
        if (this.getJunctionA() != null && j == this.getJunctionA()) {
            return;
        }
        this.d_hoveringJunc = j;
        if (j == null && this.getJunctionA() != null) {
            this.d_valueEditor.setValueType(VALTYPE_NEW_WAYPOINT);
            this.set(Segment.JUNCTION_B, null);
            if (this.d_activeWaypoint == null) {
                this.addWaypoint();
            }
        } else if (j != null && this.getJunctionA() != null) {
            this.d_valueEditor.setValueType(VALTYPE_JUNCTION_B);
            this.set(Segment.JUNCTION_B, this.d_hoveringJunc);
            if (this.d_activeWaypoint != null) {
                this.removeWaypoint();
            }
        }
    }

    private void addWaypoint() {
        UnitDouble relHt = this.d_activeWaypoint == null ? this.getJunctionA().get(Junction.RELATIVE_ELEVATION) : this.d_activeWaypoint.get(SegmentWaypoint.RELATIVE_ELEVATION);
        this.d_segment.removeAll(this.d_waypoints);
        this.d_activeWaypoint = new SegmentWaypoint("waypoint", this.d_hoveringPoint, relHt);
        this.d_activeWaypoint.setVisible(true);
        this.d_waypoints.add(this.d_activeWaypoint);
        this.d_segment.addAll(this.d_waypoints);
        this.firePropChanged(VentusData.CHILD_ADDED);
    }

    private void removeWaypoint() {
        this.d_segment.removeAll(this.d_waypoints);
        this.d_waypoints.remove(this.d_activeWaypoint);
        this.d_activeWaypoint = null;
        this.d_segment.addAll(this.d_waypoints);
        this.firePropChanged(VentusData.CHILD_REMOVED);
    }

    public void setHoveringPoint(Point3d point) {
        this.d_hoveringPoint = point;
        if (this.d_activeWaypoint != null) {
            this.d_activeWaypoint.set(SegmentWaypoint.LOCATION, this.d_hoveringPoint);
            this.firePropChanged(SegmentWaypoint.LOCATION);
        }
    }

    public boolean commitLoc() {
        if (this.d_hoveringJunc == null && this.getJunctionA() == null) {
            return false;
        }
        if (this.d_hoveringJunc != null && this.getJunctionA() == null) {
            this.set(Segment.JUNCTION_A, this.d_hoveringJunc);
            this.setHoveringJunction(null);
            return false;
        }
        if (this.d_hoveringJunc == null && this.getJunctionA() != null) {
            this.addWaypoint();
            return false;
        }
        if (this.getJunctionA() != null && this.getJunctionB() != null) {
            return true;
        }
        assert (false);
        return false;
    }

    private DuctFlowElement getDefaultElement() {
        VentusData vd = VentusApp.getAppData();
        DuctFlowElementRoot elementRoot = (DuctFlowElementRoot)vd.getComponentData(DuctFlowElementData.GUID);
        return elementRoot.getDefault();
    }

    @Override
    public void update(Events events) {
        IEventRecord<DuctFlowElement> rec = events.getEvents(DuctFlowElement.class, new Class[0]);
        if (rec.getRemovedObjs().contains(this.d_segment.get(Segment.ELEMENT))) {
            this.d_segment.set(Segment.ELEMENT, this.getDefaultElement());
        } else if (!rec.getAddedObjs().isEmpty() && this.d_segment.get(Segment.ELEMENT) == null) {
            this.d_segment.set(Segment.ELEMENT, this.getDefaultElement());
        }
    }

    public Segment getSegment() {
        return this.d_segment;
    }

    public ArrayList<SegmentWaypoint> getWaypoints() {
        return this.d_waypoints;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!this.lock()) {
            return;
        }
        try {
            this.d_segment.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        TypedProp typedProp;
        if (prop instanceof TypedProp && Segment.PROP_TYPES.has(typedProp = (TypedProp)prop)) {
            return this.d_segment.get(typedProp);
        }
        return super.get(prop);
    }

    public boolean hasActiveWaypoint() {
        return this.d_activeWaypoint != null;
    }

    public UnitDouble getActiveWaypointRelativeElevation() {
        if (this.hasActiveWaypoint()) {
            return this.d_activeWaypoint.get(SegmentWaypoint.RELATIVE_ELEVATION);
        }
        return new UnitDouble(0.0, SI.METER);
    }

    public void setActiveWaypointRelativeElevation(UnitDouble relHt) {
        if (this.hasActiveWaypoint()) {
            this.d_activeWaypoint.set(SegmentWaypoint.RELATIVE_ELEVATION, relHt);
        }
    }

    public boolean isValid() {
        return this.get(Segment.ELEMENT) != null;
    }

    public void reset() {
        this.set(Segment.JUNCTION_A, null);
        this.set(Segment.JUNCTION_B, null);
        this.d_segment.removeAll(this.d_waypoints);
        this.d_hoveringJunc = null;
        this.d_activeWaypoint = null;
        this.d_waypoints = new ArrayList();
        this.d_valueEditor.setValueType(VALTYPE_JUNCTION_A);
    }

    public void cancel() {
        this.reset();
    }

    public void create(Component c) {
        if (!this.isValid()) {
            return;
        }
        final Segment segment = this.getSegment().clone();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                DuctObjectRoot root = (DuctObjectRoot)md.getComponentData(DuctObjectsData.GUID);
                if (root == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("New Segment"));
                    String nextName = segment.getName().isEmpty() ? root.nextSegmentName() : segment.getName();
                    segment.setName(nextName);
                    SequentialNameGen wpNameGen = new SequentialNameGen(Intl.intl("Waypoint"), 2);
                    for (SegmentWaypoint wp : SegmentBuilder.this.d_waypoints) {
                        SegmentWaypoint wpClone = new SegmentWaypoint("", wp.getRootLocation(), wp.get(SegmentWaypoint.RELATIVE_ELEVATION));
                        wpClone.setVisible(true);
                        wpClone.setName(wpNameGen.nextName());
                        segment.add(wpClone);
                    }
                    AddObject.add((VentusData)md, (Composite)root, (int)root.getMembers().size(), (IMerlinObj[])new Segment[]{segment});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(c, "SegmentBuilder.create", op, 4);
        this.firePropChanged(COMPLETED);
    }

    public static class Display
    extends APropsDisplay<SegmentBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(SegmentBuilder builder) {
            if (!builder.isValid()) {
                return null;
            }
            Segment seg = builder.getSegment().clone();
            seg.setName("");
            seg.setVisible(true);
            for (SegmentWaypoint wp : builder.getWaypoints()) {
                SegmentWaypoint wpClone = new SegmentWaypoint("", wp.getRootLocation(), wp.get(SegmentWaypoint.RELATIVE_ELEVATION));
                wpClone.setVisible(true);
                seg.add(wpClone);
            }
            return seg;
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[]{Segment.JUNCTION_A, Segment.JUNCTION_B, Segment.ELEMENT, VentusData.CHILD_ADDED, VentusData.CHILD_REMOVED, SegmentWaypoint.LOCATION, SegmentWaypoint.RELATIVE_ELEVATION};
        }
    }
}

