/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.value.Schedule;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctFlowElementData;
import ventus.feature.ducts.ISegmentObj;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.geom.Geometry;
import ventus.util.Dependencies;

public class Segment
extends GeomComposite<SegmentWaypoint>
implements Serializable,
ISegmentObj,
IDirectDependent<VentusData>,
ICyclicSurrogate,
IEventObserver {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<Segment> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(Segment.class, new PropertyDefsFramework.Storage<Segment>(obj -> obj.d_properties, obj -> obj.d_transientProps, obj -> {
        obj.d_properties = new PropertySet();
        obj.d_transientProps = new PropertySet();
    }), GeomComposite.PROP_TYPES, Filters.reject(GeomComposite.STORED_VISIBILITY));
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrFireEvents((p, seg) -> seg.changedEvt(p, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY)).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    static final TypedProp<Boolean> PARENT_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"Segment.PARENT_VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(Segment::isVisible, Stream.of(PARENT_VISIBILITY, ENABLED)).attrSetter(Segment::setVisible, null).attrUndoPropRestore(false, PARENT_VISIBILITY).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Junction> JUNCTION_A = TypedProps.build((Object)"Segment.JUNCTION_A", Junction.class).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, Junction.class, Predicates.alwaysTrue())).attrFinish();
    public static final TypedProp<Junction> JUNCTION_B = TypedProps.build((Object)"Segment.JUNCTION_B", Junction.class).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, Junction.class, Predicates.alwaysTrue())).attrFinish();
    public static final DisplayProp<Schedule> MULTIPLIER = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"Segment.MULTIPLIER", Schedule.class, Schedule.newConstant(new UnitDouble(1.0, Unit.ONE)), Intl.intl("Multiplier"), Intl.intl("A constant or schedule multiplier applied to the flow.")).attrFormatValue(sch -> sch.format(10))).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().schedule(10)).attrFinish();
    public static final DisplayProp<DuctFlowElement> ELEMENT = DisplayProps.build((Object)"Segment.ELEMENT", DuctFlowElement.class, null, Intl.intl("Element"), Intl.intl("Duct flow element defining the airflow properties of this duct segment.")).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, DuctFlowElement.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(PropComparisons.getFeatureSrc(DuctFlowElementData.GUID, Intl.intl("<none>")))).attrFinish();
    public static final DisplayProp<UnitDouble> AUTO_LENGTH = (DisplayProp)DisplayProps.build((Object)"Segment.AUTO_LENGTH", new UnitDouble(0.0, SI.METER), Intl.intl("Length"), "", 0).attrStoreAsReadOnly(PROP_TYPES).attrGetter(Segment::getCalculatedLength, Stream.of(JUNCTION_A, JUNCTION_B)).attrFinish();
    public static final DisplayProp<UnitDouble> MANUAL_LENGTH = (DisplayProp)DisplayProps.build((Object)"Segment.MANUAL_LENGTH", new UnitDouble(0.0, SI.METER), Intl.intl("Length"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Boolean> USE_MANUAL_LENGTH = (DisplayProp)DisplayProps.build((Object)"Segment.USE_MANUAL_LENGTH", false, "Uses length", "<html>" + Intl.intl("The length of this entire duct segment between junction points.<br>When checked, the length is defined with a manual value instead of calculated automatically.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> SEARCH_LENGTH = (DisplayProp)DisplayProps.build((Object)"Segment.SEARCH_LENGTH", new UnitDouble(0.0, SI.METER), Intl.intl("Length"), "", 0).attrStoreAsReadOnly(PROP_TYPES).attrGetter(Segment::getEffectiveLength, Stream.of(USE_MANUAL_LENGTH, AUTO_LENGTH, MANUAL_LENGTH)).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<Double> SUM_OF_LOSS_COEFFICIENTS = (DisplayProp)DisplayProps.build((Object)"Segment.SUM_OF_LOSS_COEFFICIENTS", 0.0, Intl.intl("Sum of loss coefficients"), "<html>" + Intl.intl("Sum of all losses due to junctions and fittings along this segment.<BR>Only applicable to segments with Darcy-Colebrook duct flow elements.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final TypedProp<Boolean> DIRECTION_A_TO_B = TypedProps.build((Object)"Segment.DIRECTION", true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public Segment(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Segment seg = (Segment)obj;
        return super.cyclicEquals(obj, comparedSet) && theUtil.surrogateListsEqual(this.getMembers(), seg.getMembers(), comparedSet);
    }

    @Override
    public PropertyDefs<Segment> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public Segment clone() {
        return (Segment)super.clone();
    }

    public UnitDouble getCalculatedLength() {
        double dist = 0.0;
        if (this.getMembers(SegmentWaypoint.class).isEmpty()) {
            dist = this.get(JUNCTION_A).getElevatedLocation().distance(this.get(JUNCTION_B).getElevatedLocation());
        } else {
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            points.add(this.get(JUNCTION_A).getElevatedLocation());
            for (SegmentWaypoint wp : this.getMembers(SegmentWaypoint.class)) {
                points.add(wp.getElevatedLocation());
            }
            points.add(this.get(JUNCTION_B).getElevatedLocation());
            for (int i = 1; i < points.size(); ++i) {
                dist += ((Point3d)points.get(i - 1)).distance((Point3d)points.get(i));
            }
        }
        return new UnitDouble(dist, Geometry.LENGTH_UNIT);
    }

    public UnitDouble getEffectiveLength() {
        if (this.get(USE_MANUAL_LENGTH).booleanValue()) {
            return this.get(MANUAL_LENGTH);
        }
        return this.get(AUTO_LENGTH);
    }

    public Vector3d getRelativeFlowDirection(Junction j) {
        List<SegmentWaypoint> waypoints = this.getMembers(SegmentWaypoint.class).stream().toList();
        if (waypoints.isEmpty()) {
            Vector3d dir = Util3D.vectorN(this.get(JUNCTION_B).getElevatedLocation(), this.get(JUNCTION_A).getElevatedLocation());
            if (j == this.get(JUNCTION_B)) {
                dir.negate();
            }
            return dir;
        }
        if (j == this.get(JUNCTION_A)) {
            return Util3D.vectorN(waypoints.getFirst().getElevatedLocation(), this.get(JUNCTION_A).getElevatedLocation());
        }
        if (j == this.get(JUNCTION_B)) {
            return Util3D.vectorN(waypoints.getLast().getElevatedLocation(), this.get(JUNCTION_B).getElevatedLocation());
        }
        assert (false);
        return new Vector3d(0.0, 0.0, 1.0);
    }

    @Override
    public boolean isVisible() {
        return this.get(PARENT_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(PARENT_VISIBILITY, visible);
    }

    @Override
    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.getEvents().addObserverInDomain((IEventObserver)this, Junction.class, false, false, Junction.LOCATION, Junction.RELATIVE_ELEVATION);
        domain.getEvents().addObserverInDomain((IEventObserver)this, DuctFlowElement.class, false, false, DuctFlowElement.COLOR);
    }

    @Override
    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof SegmentGeom) {
            SegmentGeom seg = (SegmentGeom)geom;
            this.set(JUNCTION_A, seg.junctionA);
            this.set(JUNCTION_B, seg.junctionB);
            this.removeChildren(this.getChildren());
            this.addChildren(seg.waypoints);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getSegmentGeom());
    }

    public IGeom getSegmentGeom() {
        Junction juncA = this.get(JUNCTION_A);
        Junction juncB = this.get(JUNCTION_B);
        if (juncA == null || this.getMembers(SegmentWaypoint.class).isEmpty() && juncB == null) {
            return EmptyGeom.INSTANCE;
        }
        return new SegmentGeom(juncA, juncB, this.getMembers(SegmentWaypoint.class));
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        if (geom == GeomNodeUtil.EMPTY_NODE) {
            return DisplayGeom.EMPTY;
        }
        PropsBuilder pb = new PropsBuilder();
        DuctFlowElement ductFlowElement = this.get(ELEMENT);
        if (ductFlowElement instanceof DuctFlowElement) {
            DuctFlowElement elem = ductFlowElement;
            pb.add(new IPrimProps.Edge(elem.get(DuctFlowElement.COLOR), 12.0, IPrimProps.DEF_STIPPLE, 0));
        } else {
            pb.add(new IPrimProps.Edge(Color.ORANGE, 12.0, IPrimProps.DEF_STIPPLE, 0));
        }
        return new DisplayGeom(geom, pb.finalizeProps());
    }

    @Override
    public void add(IMerlinObj obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends IMerlinObj> objs) {
        super.addAll(theUtil.filter(objs, SegmentWaypoint.class));
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return List.of();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return false;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        return true;
    }

    @Override
    public void update(Events events) {
        if (events.isChanged(this.get(ELEMENT), DuctFlowElement.COLOR)) {
            this.changedEvt(ELEMENT);
        }
        if (events.isChanged(this.get(JUNCTION_A), Junction.LOCATION) || events.isChanged(this.get(JUNCTION_B), Junction.LOCATION) || events.isChanged(this.get(JUNCTION_A), Junction.RELATIVE_ELEVATION) || events.isChanged(this.get(JUNCTION_B), Junction.RELATIVE_ELEVATION)) {
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return new TypeFilter<IMerlinObj>(SegmentWaypoint.class);
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    public Collection<SegmentWaypoint> getNodes() {
        return this.getMembers(SegmentWaypoint.class);
    }

    public static class SegmentGeom
    extends GeomGroup {
        private static final long serialVersionUID = -4010003154858195644L;
        private Junction junctionA;
        private Junction junctionB;
        private Collection<SegmentWaypoint> waypoints;

        public SegmentGeom(Junction juncA, Junction juncB, Collection<SegmentWaypoint> waypoints) {
            super(SegmentGeom.generateGeoms(juncA, juncB, waypoints));
            this.junctionA = juncB;
            this.junctionB = juncB;
            this.waypoints = waypoints;
        }

        private static List<IGeom> generateGeoms(Junction a, Junction b, Collection<SegmentWaypoint> waypoints) {
            ArrayList<IGeom> geoms = new ArrayList<IGeom>();
            if (waypoints.isEmpty()) {
                geoms.add(new LineSeg(a.getElevatedLocation(), b.getElevatedLocation()));
                return geoms;
            }
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            points.add(a.getElevatedLocation());
            for (SegmentWaypoint wp : waypoints) {
                points.add(wp.getElevatedLocation());
            }
            if (b != null) {
                points.add(b.getElevatedLocation());
            }
            for (int i = 1; i < points.size(); ++i) {
                geoms.add(new LineSeg((Point3d)points.get(i - 1), (Point3d)points.get(i)));
            }
            return geoms;
        }
    }
}

