/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentBuilder;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;

public class NewSegmentPanel
extends APropEditPanel<SegmentBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_nameFld = this.initValueField(new guiTextField(), new IPropEditCommand[0]);
    private final guiComboBox<DuctFlowElement> d_elementCb;
    private final MerlinUDF d_relHeightFld;

    public NewSegmentPanel(VentusData vd) {
        super(Segment.NAME, Segment.ELEMENT, VentusData.CHILD_ADDED, VentusData.CHILD_REMOVED);
        this.d_nameFld.setToolTipText(Intl.intl("Name"));
        guiLabel elementLbl = guiUtil.lblProp(Segment.ELEMENT);
        this.d_elementCb = this.initComboBox(new MerlinComboBox(vd, DuctFlowElement.class, (IMerlinObj[])new DuctFlowElement[0]));
        guiPanel namePnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(namePnl);
        gb.addRow(new guiLabel(Intl.intl("Name:")), this.d_nameFld, 0, 1.0);
        guiPanel propsPnl = new guiPanel(new MigLayout("insets 0, align center"));
        propsPnl.add((Component)elementLbl, "aligny center");
        propsPnl.add(this.d_elementCb, "wmax 180px, wrap");
        guiPanel waypointPanel = new guiPanel();
        gb = new GridBagHelper(waypointPanel);
        guiLabel relHeightLbl = guiUtil.lbl(SegmentWaypoint.RELATIVE_ELEVATION.getNameWithColon(), SegmentWaypoint.RELATIVE_ELEVATION.getDisplayDesc());
        this.d_relHeightFld = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        gb.addRow(relHeightLbl, this.d_relHeightFld, 0, 1.0);
        this.addSection(namePnl);
        this.addSeparator();
        this.addSection(propsPnl);
        this.addSeparator();
        this.addSection(waypointPanel);
    }

    @Override
    protected void updateFromProps(SegmentBuilder props) {
        this.d_nameFld.setText((String)props.get(Segment.NAME));
        this.d_elementCb.setSelectedItem(props.get(Segment.ELEMENT));
        this.d_relHeightFld.setValue(props.getActiveWaypointRelativeElevation());
        this.d_relHeightFld.setEditable(props.hasActiveWaypoint());
    }

    @Override
    protected void updateToProps(SegmentBuilder props) {
        props.set(Junction.NAME, this.d_nameFld.getValue());
        props.set(Segment.ELEMENT, this.d_elementCb.getSelectedItem());
        props.setActiveWaypointRelativeElevation((UnitDouble)this.d_relHeightFld.getValue());
    }
}

