/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.feature.simparams.SimParamsFeature;
import ventus.feature.simparams.SimParamsProps;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class JunctionRibbon
implements ISelectionRibbon {
    private final List<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList<SelectionEditorPanel.EditorPanel>();

    private void createSections() {
        guiLabel relHeightLbl = guiUtil.lblProp(Junction.RELATIVE_ELEVATION);
        PropConnections.UDPropConnection relHeightConn = SelectionRibbonHelper.udConn(Junction.RELATIVE_ELEVATION, 0);
        MerlinUDF relHeightFld = (MerlinUDF)relHeightConn.getControl();
        final ScheduleField tempFld = new ScheduleField(Junction.TEMPERATURE_SCHEDULE.name, 14, UnitDoubleVR.UNBOUNDED);
        final guiMultiStateCheckBox tempOverwrite = new guiMultiStateCheckBox(Junction.TEMPERATURE_SCHEDULE.getNameWithColon());
        tempOverwrite.setToolTipText("<html>" + Intl.intl("Temperature at this junction.<br>Determined by simulation parameters unless overwritten with constant or schedule value."));
        final CompElementActions.DefProp<IMerlinObj, Schedule> scheduleProp = new CompElementActions.DefProp<IMerlinObj, Schedule>(Junction.TEMPERATURE_SCHEDULE);
        JunctionTempConn tempScheduleCon = new JunctionTempConn(tempFld, (CompElementActions.IObjectProp<IMerlinObj, Schedule>)scheduleProp);
        LinkStatus.link((AbstractButton)tempOverwrite, tempFld);
        PropConnections.BoolPropConnection checkboxPropConn = new PropConnections.BoolPropConnection(this, new CompElementActions.DefProp(Junction.TEMP_DEFINEDLOCALLY), tempOverwrite){

            @Override
            public void apply(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, Boolean val) {
                Undo.begin(Intl.intl("Set Temperature Schedule Overwrite"));
                VentusData md = VentusApp.getApp().getData();
                prop.set(md, objs, val);
                if (!tempOverwrite.isSelected()) {
                    SimParamsProps simData = VentusApp.getAppData().getComponentData(SimParamsFeature.GUID);
                    tempFld.setValue(Schedule.newConstant(simData.get(SimParamsProps.defaultZoneTemp)));
                    scheduleProp.set(md, objs, tempFld.getValue());
                }
                Undo.end(VentusApp.getApp().getData());
            }
        };
        SelectionEditorPanel.EditorPanel section1 = this.newSection();
        GridBagHelper gb = new GridBagHelper(section1);
        gb.rowSpace = 1;
        gb.addRow(this.createTitleLabel(Intl.intl("Properties")), 0, 1.0);
        gb.addRow(relHeightLbl, relHeightFld, 0, 1.0);
        gb.addRow(tempOverwrite, tempFld);
        section1.addConnection(relHeightConn);
        section1.addConnection(tempScheduleCon);
        section1.addConnection(checkboxPropConn);
        guiRadioButton constantWindPressureRadio = new guiRadioButton(Intl.intl("Constant:"));
        constantWindPressureRadio.setToolTipText(Intl.intl("Constant wind pressure conditions for this terminal."));
        PropConnections.UDPropConnection windPressureConn = SelectionRibbonHelper.udConn(Junction.WIND_PRESSURE, 15);
        MerlinUDF windPressureFld = (MerlinUDF)windPressureConn.getControl();
        windPressureFld.setToolTipText(Junction.WIND_PRESSURE.getDisplayDesc());
        guiRadioButton variableWindPressureRadio = new guiRadioButton(Intl.intl("Variable:"));
        variableWindPressureRadio.setToolTipText(Intl.intl("A variable wind pressure for this terminal defined using a wind profile."));
        MerlinComboBox windProfileComboBox = new MerlinComboBox(VentusApp.getAppData(), WindProfile.class, (IMerlinObj[])new WindProfile[0]);
        PropConnections.ComboPropConn<WindProfile> windProfileConn = new PropConnections.ComboPropConn<WindProfile>(new CompElementActions.DefProp(Junction.WIND_PROFILE), windProfileComboBox);
        new guiButtonGroup(constantWindPressureRadio, variableWindPressureRadio);
        LinkStatus.link((AbstractButton)constantWindPressureRadio, windPressureFld);
        LinkStatus.link((AbstractButton)variableWindPressureRadio, windProfileComboBox);
        SelectionEditorPanel.EditorPanel section2 = this.newSection();
        gb = new GridBagHelper(section2);
        gb.addRow(this.createTitleLabel(Intl.intl("Ambient Wind Pressure")), 0, 1.0);
        gb.addRow(constantWindPressureRadio, windPressureFld, 0, 1.0);
        gb.addRow(variableWindPressureRadio, windProfileComboBox, 0, 1.0);
        section2.addConnection(new PropConnections.BoolRadioPropConn(Junction.CONSTANT_WIND_PRESSURE, constantWindPressureRadio, true));
        section2.addConnection(new PropConnections.BoolRadioPropConn(Junction.CONSTANT_WIND_PRESSURE, variableWindPressureRadio, false));
        section2.addConnection(windPressureConn);
        section2.addConnection(windProfileConn);
        section2.addConnection(new WindPanelPropConn(section2));
        guiLabel lossCoefLbl = guiUtil.lblProp(Junction.LOSS_COEFFICIENT);
        PropConnections.DoublePropConn lossCoefConn = SelectionRibbonHelper.doubleConn(Junction.LOSS_COEFFICIENT, DoubleVR.ge(0.001));
        guiDoubleField lossCoefFld = (guiDoubleField)lossCoefConn.getControl();
        guiLabel freeFaceAreaLbl = guiUtil.lblProp(Junction.FREE_FACE_AREA);
        PropConnections.UDPropConnection freeFaceAreaConn = SelectionRibbonHelper.udConn(Junction.FREE_FACE_AREA, 2);
        MerlinUDF freeFaceAreaFld = (MerlinUDF)freeFaceAreaConn.getControl();
        guiLabel ductAreaLbl = guiUtil.lblProp(Junction.DUCT_AREA);
        PropConnections.UDPropConnection ductAreaConn = SelectionRibbonHelper.udConn(Junction.DUCT_AREA, 2);
        MerlinUDF ductAreaFld = (MerlinUDF)ductAreaConn.getControl();
        ductAreaFld.setEditable(false);
        SelectionEditorPanel.EditorPanel section3 = this.newSection();
        gb = new GridBagHelper(section3);
        gb.addRow(this.createTitleLabel(Intl.intl("Terminal Properties")), 0, 1.0);
        gb.add(lossCoefLbl, lossCoefFld);
        gb.addRow(ductAreaLbl, ductAreaFld, 0, 1.0);
        gb.addRow(freeFaceAreaLbl, freeFaceAreaFld);
        section3.addConnection(lossCoefConn);
        section3.addConnection(freeFaceAreaConn);
        section3.addConnection(ductAreaConn);
        section3.addConnection(new TerminalPanelPropConn(section3));
    }

    private SelectionEditorPanel.EditorPanel newSection() {
        SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel(new MigLayout("insets 0, aligny top"));
        this.d_sections.add(panel);
        return panel;
    }

    private guiLabel createTitleLabel(String title) {
        guiLabel label = new guiLabel(title);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(Junction.ROOM) && !unshared.contains(SegmentWaypoint.RELATIVE_ELEVATION) && !unshared.contains(Segment.ELEMENT);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    private static class JunctionTempConn
    extends PropConnections.ScheduleProp {
        public JunctionTempConn(ScheduleField control, CompElementActions.IObjectProp<IMerlinObj, Schedule> prop) {
            super(prop, control);
        }

        public void commitSoTempCanUpdate() {
            this.runWhileLocked(() -> this.forceCommit());
        }

        @Override
        public void update(Events events) {
            super.update(events);
            if (events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.SIM_PARAMS_CHANGED) || events.getEvents(Junction.class, new Class[0]).containsChange(VentusData.SELECTION_CHANGED)) {
                MerlinSelectionModel sel = Objects.requireNonNull(VentusApp.getAppData()).selection;
                Set junctions = sel.getDeepSelected(Junction.class);
                assert (!junctions.isEmpty());
                if (!((Junction)junctions.iterator().next()).get(Junction.TEMP_DEFINEDLOCALLY).booleanValue()) {
                    SimParamsProps simData = VentusApp.getAppData().getComponentData(SimParamsFeature.GUID);
                    ((ScheduleField)this.d_control).setValue(Schedule.newConstant(simData.get(SimParamsProps.defaultZoneTemp)));
                }
            }
        }
    }

    public static class WindPanelPropConn
    extends PropConnections.AMultiPropConnection<SelectionEditorPanel.EditorPanel, TypedProp<ISchematicRoom>> {
        public WindPanelPropConn(SelectionEditorPanel.EditorPanel control) {
            super(Collections.singleton(Junction.ROOM), control);
        }

        @Override
        public void setProps(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel panel) {
            boolean isAmbient = CompElementActions.flattenToLocallyDefined(Junction.ROOM, objs).stream().allMatch(obj -> {
                ISchematicRoom room = obj.get(Junction.ROOM);
                return room == null;
            });
            boolean isTerminal = CompElementActions.flattenToLocallyDefined(Junction.SEGMENT_COUNT, objs).stream().allMatch(obj -> {
                int segments = obj.get(Junction.SEGMENT_COUNT);
                return segments == 1;
            });
            panel.setVisible(isTerminal);
            panel.setEnabled(isAmbient);
        }
    }

    public static class TerminalPanelPropConn
    extends PropConnections.AMultiPropConnection<SelectionEditorPanel.EditorPanel, TypedProp<Integer>> {
        public TerminalPanelPropConn(SelectionEditorPanel.EditorPanel control) {
            super(Collections.singleton(Junction.SEGMENT_COUNT), control);
        }

        @Override
        public void setProps(Collection<? extends TypedProp<Integer>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(Collection<? extends TypedProp<Integer>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel panel) {
            boolean isTerminal = CompElementActions.flattenToLocallyDefined(Junction.SEGMENT_COUNT, objs).stream().allMatch(obj -> {
                int segments = obj.get(Junction.SEGMENT_COUNT);
                return segments == 1;
            });
            panel.setVisible(isTerminal);
        }
    }
}

