/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.Map;
import org.jscience.physics.units.SI;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.feature.weather.WeatherFeature;
import ventus.feature.weather.WeatherProps;
import ventus.feature.windprofiles.WindProfile;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class JunctionPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    private static int getTypeInt(Junction j) {
        return switch (j.getJunctionType()) {
            default -> throw new MatchException(null, null);
            case Junction.JunctionType.JUNCTION -> 0;
            case Junction.JunctionType.TERMINAL -> 1;
            case Junction.JunctionType.AMBIENT_TERMINAL -> 3;
        };
    }

    private int getZoneIndex(PrjData data, ISchematicRoom room) {
        if (room == null) {
            return -1;
        }
        PrjData.Zone obj = data.findZone(room);
        return obj.nr;
    }

    private double getWindSpeedModifier(VentusData md) {
        WeatherProps weather = md.getComponentData(WeatherFeature.GUID);
        double newmod = Math.pow(weather.get(WeatherProps.localTerrainConst), 2.0) * Math.pow(weather.get(WeatherProps.roofWallHeight).getValue(SI.METER) / 10.0, 2.0 * weather.get(WeatherProps.velocityProfileExpo));
        return newmod;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        DuctObjectRoot root = (DuctObjectRoot)md.getComponentData(DuctObjectsData.GUID);
        for (Junction j : root.flatten(Junction.class)) {
            if (j.get(Junction.SEGMENT_COUNT) == 0) continue;
            Pair<Integer, Double> tempSchedule = PrjUtil.maybeWriteSchedule(prjData, j.get(Junction.TEMPERATURE_SCHEDULE), SI.KELVIN);
            PrjData.Junction out = new PrjData.Junction(j);
            prjData.junctionList.add(out);
            out.nr = prjData.njct = prjData.junctionList.size();
            out.flags = 0;
            out.jtype = JunctionPrjWriter.getTypeInt(j);
            out.pzn = this.getZoneIndex(prjData, j.get(Junction.ROOM));
            out.dnr = 0;
            out.pk = 0;
            out.ps = (Integer)tempSchedule.v1;
            out.pc = 0;
            out.pld = prjData.findLevel((Object)j.getLevel()).nr;
            out.relHt = j.get(Junction.RELATIVE_ELEVATION).getValue(SI.METER);
            out.T0 = (Double)tempSchedule.v2;
            out.P0 = 0.0;
            out.icon = 0;
            out.color = -1;
            out.u_Ht = 0;
            out.u_XY = 0;
            out.u_T = 0;
            out.u_dP = 0;
            out.vf_type = 0;
            out.vf_node_name = "0";
            if (j.getJunctionType() == Junction.JunctionType.JUNCTION) continue;
            out.T = "T:";
            out.pf = 0;
            int ixWindPress = 0;
            if (!j.get(Junction.CONSTANT_WIND_PRESSURE).booleanValue()) {
                PrjData.WindProfile windProfRec;
                WindProfile windPressProfRefObj = j.get(Junction.WIND_PROFILE);
                if (windPressProfRefObj != null && (windProfRec = prjData.findWindProfile(windPressProfRefObj)) != null) {
                    ixWindPress = windProfRec.nr;
                }
                if (ixWindPress == 0) {
                    System.err.printf("[%s] \"%s\" invalid wind profile [%s] for variable pressure, using constant wind pressure%n", this.getClass().getSimpleName(), j.getName(), j.get(Junction.WIND_PROFILE));
                }
            }
            out.pw = ixWindPress;
            boolean ambient = j.getJunctionType() == Junction.JunctionType.AMBIENT_TERMINAL;
            out.wPset = ambient ? j.get(Junction.WIND_PRESSURE).getValue(SI.PASCAL) : 0.0;
            out.wPmod = ambient && out.pw != 0 ? this.getWindSpeedModifier(md) : 0.0;
            out.wazm = -1.0;
            out.bal = j.get(Junction.BALANCE_TERMINAL) != false ? 1 : 0;
            out.Ad = j.get(Junction.DUCT_AREA).getValue(SI.METER.pow(2));
            out.Af = j.get(Junction.FREE_FACE_AREA).getValue(SI.METER.pow(2));
            out.Fdes = j.get(Junction.DESIGN_FLOW_RATE).getValue(SI.KILOGRAM.divide(SI.SECOND));
            out.Ct = j.get(Junction.LOSS_COEFFICIENT);
            out.Cb = j.get(Junction.BALANCE_LOSS_COEFFICIENT);
            out.Cbmax = j.get(Junction.MAX_BALANCE_COEFFICIENT);
            out.u_A = 0;
            out.u_F = 4;
            out.ddir = 0;
            out.fdir = 0;
        }
    }
}

