/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.ducts.DuctsUtil;
import ventus.feature.ducts.Segment;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileFeature;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.PointEntityGeom;
import ventus.mv.tools.RoomSnapConstraint;
import ventus.util.Dependencies;

public class Junction
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
IDirectDependent<VentusData>,
ISurrogate {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<Junction> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(Junction.class, new PropertyDefsFramework.Storage<Junction>(obj -> obj.d_properties, obj -> obj.d_transientProps, obj -> {
        obj.d_properties = new PropertySet();
        obj.d_transientProps = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrFireEvents((p, j) -> j.changedEvt(p, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY)).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"Junction.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(Junction::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(Junction::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"Junction.COLOR", Color.class, Color.ORANGE, Intl.intl("Color"), "").attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(junction -> junction.get(COLOR), COLOR).attrFinish();
    public static final TypedProp<ISchematicRoom> ROOM = TypedProps.build((Object)"Junction.ROOM", ISchematicRoom.class).attrStoreAsTopologyDirect(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyContainedBy(ISchematicRoom.class)).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Point3d> LOCATION = TypedProps.build("Junction.LOCATION", Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> RELATIVE_ELEVATION = (DisplayProp)DisplayProps.build((Object)"Junction.RELATIVE_ELEVATION", new UnitDouble(0.0, SI.METER), Intl.intl("Rel. Height"), Intl.intl("Elevation relative to the placement level's working Z location."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<Schedule> TEMPERATURE_SCHEDULE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"Junction.TEMPERATURE_SCHEDULE", Schedule.class, Schedule.newConstant(new UnitDouble(20.0, SI.CELSIUS)), Intl.intl("Temperature"), "").attrFormatValue(sch -> sch.format(14))).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrComparisonEditor(PropComparisons.factory().schedule(14)).attrFinish();
    public static final TypedProp<Boolean> TEMP_DEFINEDLOCALLY = TypedProps.build((Object)"Junction.TEMP_OVERWRITE", false).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Double> LOSS_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"Junction.LOSS_COEFFICIENT", 0.125, Intl.intl("Loss Coefficient"), Intl.intl("The loss flow coefficient used for determining the flow of this terminal.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<UnitDouble> FREE_FACE_AREA = (DisplayProp)DisplayProps.build((Object)"Junction.FREE_FACE_AREA", new UnitDouble(0.0314159, SI.METER.pow(2)), Intl.intl("Free Face Area"), Intl.intl("The total minimum area through which air can pass. Used to calculate velocity at this junction from airflow rate."), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_AREA = (DisplayProp)DisplayProps.build((Object)"Junction.DUCT", new UnitDouble(0.0, SI.METER.pow(2)), Intl.intl("Duct Area"), Intl.intl("Area of the connected duct. Used to calculate airflow rate."), 2).attrStoreAsReadOnly(PROP_TYPES).attrGetter(Junction::getConnectedSegmentArea, Segment.ELEMENT).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<Boolean> BALANCE_TERMINAL = (DisplayProp)DisplayProps.build((Object)"Junction.BALANCE_TERMINAL", false, Intl.intl("Balance Terminal"), Intl.intl("Whether to include this terminal in duct balancing.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().booleanYesNo()).attrFinish();
    public static final DisplayProp<UnitDouble> DESIGN_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"Junction.DESIGN_FLOW_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Design Flow Rate"), "<html>" + Intl.intl("Airflow rate for this Terminal.<br>Positive rates represent supply flow from duct system to zone and negative rates represent return flow from the zone to the duct system."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(17)).attrFinish();
    public static final DisplayProp<Double> MAX_BALANCE_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"Junction.MAX_BALANCE_COEFFICIENT", 0.8, Intl.intl("Max Balance Coefficient"), Intl.intl("Maximum value for the Balance Loss Coefficient.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<Double> BALANCE_LOSS_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"Junction.BALANCE_LOSS_COEFFICIENT", 0.0, Intl.intl("Balance Loss Coefficient"), Intl.intl("Used to determine effective loss coefficient when balancing is enabled. This coefficient will be automatically determined unless overriden.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final TypedProp<Boolean> CONSTANT_WIND_PRESSURE = TypedProps.build((Object)"Junction.CONSTANT_WIND_PRESSURE", true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<WindProfile> WIND_PROFILE = DisplayProps.build((Object)"Junction.WIND_PROFILE", WindProfile.class, null, Intl.intl("Wind Profile"), "").attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> new DepCallback<VentusData, Junction, WindProfile, WindProfile>(DLink.WEAK, WindProfile.class, (vd, src, prof) -> Stream.of(prof), Predicates.alwaysTrue(), new DepCallback.ReplaceDep<VentusData, Junction, WindProfile, WindProfile>((vd, src) -> (WindProfile)src.get(prop), (vd, src, ref) -> Undo.insertUndoEntry_propRestore(vd, (IMerlinObj)src, List.of(prop, CONSTANT_WIND_PRESSURE)), (vd, src, newVal) -> {
        src.set(prop, newVal);
        if (newVal == null) {
            src.set(CONSTANT_WIND_PRESSURE, true);
        }
    }, (vd, src, val, old, repl) -> repl))).attrComparisonEditor(PropComparisons.factory().singleObj(PropComparisons.getFeatureSrc(WindProfileFeature.GUID, Intl.intl("<none>")))).attrFinish();
    public static final DisplayProp<UnitDouble> WIND_PRESSURE = (DisplayProp)DisplayProps.build((Object)"Junction.WIND_PRESSURE", new UnitDouble(0.0, SI.PASCAL), Intl.intl("Wind Pressure"), "", 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(15)).attrFinish();
    public static final TypedProp<Integer> SEGMENT_COUNT = TypedProps.build((Object)"Junction.SEGMENT_COUNT", 0).attrStoreAsReadOnly(PROP_TYPES).attrGetter(Junction::getConnectedSegmentCount, Stream.of(new TypedProp[0])).attrFinish();
    public static final DisplayProp<Floor> LEVEL = PROP_TYPES.storeAsReadOnly(VentusData.LEVEL).attrGetter(Junction::getLevel, ROOM).attrFinish();
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public Junction(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        if (this.d_properties.isDefined(ROOM)) {
            this.d_transientProps.setIfNotDefault(ROOM, this.d_properties.get(ROOM));
            this.d_properties.remove(ROOM);
        }
    }

    public PropertyDefs<Junction> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public Junction clone() {
        return (Junction)super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public JunctionType getJunctionType() {
        ISchematicRoom room = this.get(ROOM);
        int segCount = this.get(SEGMENT_COUNT);
        if (segCount >= 2) {
            return JunctionType.JUNCTION;
        }
        if (segCount == 1 && room != null) {
            return JunctionType.TERMINAL;
        }
        if (segCount == 1 && room == null) {
            return JunctionType.AMBIENT_TERMINAL;
        }
        return JunctionType.JUNCTION;
    }

    public boolean isValidJunction() {
        return this.get(SEGMENT_COUNT) > 0;
    }

    private Point3d getRootLocation() {
        return this.get(LOCATION);
    }

    public Point3d getElevatedLocation() {
        Point3d loc = this.get(LOCATION);
        double levelZ = this.getLevel().getWorkingZ().getValue(Geometry.LENGTH_UNIT);
        double levelHt = this.getLevel().getHeight().getValue(Geometry.LENGTH_UNIT);
        double juncRelHt = this.get(RELATIVE_ELEVATION).getValue(Geometry.LENGTH_UNIT);
        double clampedHt = juncRelHt >= levelHt ? levelZ + levelHt * 0.99 : (juncRelHt <= 0.0 ? levelZ + levelHt * 0.01 : levelZ + juncRelHt);
        return new Point3d(loc.x, loc.y, clampedHt);
    }

    public boolean getHeightExceedsFloorMinMax() {
        double levelHt = this.getLevel().getHeight().getValue(Geometry.LENGTH_UNIT);
        double juncRelHt = this.get(RELATIVE_ELEVATION).getValue(Geometry.LENGTH_UNIT);
        return juncRelHt > levelHt || juncRelHt < 0.0;
    }

    public Floor getLevel() {
        ISchematicRoom zone = this.get(ROOM);
        if (zone != null && zone.getLevel() != null) {
            return zone.getLevel();
        }
        Floor[] floor = VentusApp.getAppData().floors.getSurroundingFloors(new UnitDouble(this.get(Junction.LOCATION).z, Geometry.LENGTH_UNIT));
        if (floor[0] == null) {
            return VentusApp.getAppData().floors.getActive();
        }
        return floor[0];
    }

    public UnitDouble getConnectedSegmentArea() {
        Optional<Segment> segment = DuctsUtil.getSegmentFromTerminal(this);
        if (segment.isPresent()) {
            return segment.get().get(Segment.ELEMENT).getDuctGeomArea();
        }
        return new UnitDouble(0.0, SI.METER.pow(2));
    }

    public int getConnectedSegmentCount() {
        return DuctsUtil.getConnectedSegmentCount(this);
    }

    @Override
    public boolean isVisible() {
        return this.get(STORED_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.get(ROOM) != null ? Collections.singleton(this.get(ROOM)) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(ROOM) == null;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(ROOM)) {
            this.pauseUpdates();
            this.set(ROOM, null);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        Point3d location = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((VentusData)this.getDomain(), new Point3d(location.x, location.y, location.z + 1.0E-6), new Point3d(location.x, location.y, location.z - 1.0E-6), 1, Junction.getRoomFilter());
        if (room != null) {
            this.pauseUpdates();
            this.set(ROOM, room.room);
            this.set(LOCATION, room.p);
            this.resumeUpdates();
        }
        return true;
    }

    public static BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getRoomFilter() {
        return (room, comp) -> !(comp instanceof ISchematicRoom.IWallComponent);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getJunctionGeom());
    }

    private JunctionGeom getJunctionGeom() {
        return new JunctionGeom((VentusData)this.getDomain(), this.getRootLocation(), this.getElevatedLocation());
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof JunctionGeom) {
            JunctionGeom p = (JunctionGeom)geom;
            this.set(LOCATION, p.d_location);
        }
        this.markTopoDirty();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder pb = new PropsBuilder();
        pb.add(new IPrimProps.Vertex(Color.BLACK, 15.0));
        pb.add(new IPrimProps.Edge(Color.ORANGE, 4.0, IPrimProps.Edge.makeStipple(2, (short)4095), 0));
        pb.add(new IPrimProps.Face(this.get(COLOR), null, 0), 12);
        pb.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0), 18);
        return new DisplayGeom(geom, pb);
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    public static enum JunctionType {
        JUNCTION,
        TERMINAL,
        AMBIENT_TERMINAL;

    }

    private static class JunctionGeom
    extends GeomGroup {
        public Point3d d_location;
        public Point3d d_elevatedLoc;
        public VentusData d_vd;

        public JunctionGeom(VentusData vd, Point3d loc, Point3d elevatedLoc) {
            super(List.of(new JunctionPointGeom(vd, loc), new LineSeg(loc, elevatedLoc), new JunctionBoxGeom(vd, elevatedLoc)));
            this.d_location = loc;
            this.d_elevatedLoc = elevatedLoc;
            this.d_vd = vd;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            return new JunctionGeom(this.d_vd, Util3D.xform(ti.getMatrix(), this.d_location), Util3D.xform(ti.getMatrix(), this.d_elevatedLoc));
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            this.generateManipHandles(2, handles);
        }

        @Override
        protected void generateManipHandles(int m, Consumer<? super IHandle> handles) {
            IGeom child = (IGeom)this.children.get(m);
            if (child instanceof IManipulatable) {
                ((IManipulatable)((Object)child)).generateManipHandles(handle -> handles.accept(new JunctionGeomHandle(this, m, (IHandle)handle, this.d_vd)));
            }
        }

        private static class JunctionGeomHandle
        extends GeomGroup.Handle {
            private JunctionGeom geom;
            private VentusData vd;

            public JunctionGeomHandle(JunctionGeom geom, int childIx, IHandle handle, VentusData vd) {
                super(geom, childIx, handle);
                this.geom = geom;
                this.vd = vd;
            }

            @Override
            public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                this.geom = new JunctionGeom(this.vd, newLoc, newLoc);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }
        }
    }

    private static class JunctionBoxGeom
    extends PointEntityGeom {
        private static final long serialVersionUID = 1L;
        private final VentusData vd;

        public JunctionBoxGeom(VentusData vd, Point3d loc) {
            super(loc, 0.6);
            this.vd = vd;
        }

        @Override
        public JunctionBoxGeom newPoint(Point3d loc) {
            return new JunctionBoxGeom(this.vd, loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle());
        }

        public class Handle
        extends PointEntityGeom.Handle {
            public Handle() {
                super(JunctionBoxGeom.this);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                double z = VentusApp.getAppData().floors.getActive().getWorkingZ().getValue(Geometry.LENGTH_UNIT);
                return new RoomSnapConstraint(JunctionBoxGeom.this.vd, new PlanarConstraint(new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, z))), Junction.getRoomFilter());
            }
        }
    }

    private static class JunctionPointGeom
    extends Point {
        private static final long serialVersionUID = 8317140899487626475L;
        private VentusData vd;

        public JunctionPointGeom(VentusData vd, Point3d loc) {
            super(loc);
            this.vd = vd;
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new JunctionPointManipHandle(this, this.vd));
        }

        private static class JunctionPointManipHandle
        implements IHandle {
            private JunctionPointGeom geom;
            private VentusData vd;

            public JunctionPointManipHandle(JunctionPointGeom geom, VentusData vd) {
                this.geom = geom;
                this.vd = vd;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof JunctionPointManipHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(this.geom);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                double z = VentusApp.getAppData().floors.getActive().getWorkingZ().getValue(Geometry.LENGTH_UNIT);
                return new RoomSnapConstraint(this.vd, new PlanarConstraint(new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, z))), Junction.getRoomFilter());
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                this.geom = new JunctionPointGeom(this.vd, newLoc);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }
        }
    }
}

