/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.jscience.physics.units.SI;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.IDataModel;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctsUtil;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.gui.guiUtil;

public class DuctObjectsData
implements IDataModel {
    public static final CompositeFeatureGuid<DuctObjectRoot, NamedMerlinObj> GUID = new CompositeFeatureGuid<DuctObjectRoot, NamedMerlinObj>("Ducts.data", DuctObjectRoot.class, NamedMerlinObj.class);
    public static final int SEQ_IX = 80;
    public static final ImageIcon DUCT_ROOT_ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(DuctObjectRoot.class, "icons/duct-root.svg"), 16);
    public static final ImageIcon DUCT_GROUP_ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(DuctObjectRoot.class, "icons/duct-group.svg"), 16);
    public static final ImageIcon JUNCTION_ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(Junction.class, "icons/duct-junction.svg"), 16);
    public static final ImageIcon SEGMENT_ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(Segment.class, "icons/duct-segment.svg"), 16);
    public static final ImageIcon SEGMENT_WAYPOINT_ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(SegmentWaypoint.class, "icons/duct-segment-waypoint.svg"), 16);

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new DuctObjectRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((DuctObjectRoot)md.getComponentData(GUID)).reset();
    }

    private static DuctObjectRoot getDataRoot(VentusData md) {
        return (DuctObjectRoot)md.getComponentData(GUID);
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        DuctObjectRoot srcData = DuctObjectsData.getDataRoot(src);
        DuctObjectRoot destData = DuctObjectsData.getDataRoot(dest);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(80, md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper<DuctObjectRoot> rootHelper = EntryPointHelper.rootEP(DuctObjectRoot.class, DUCT_ROOT_ICON, Intl.intl("Duct Root"));
        rootHelper.register();
        EntryPointHelper<DuctObjectRoot.DuctNode> compHelper = EntryPointHelper.groupEP(GUID, DuctObjectRoot.DuctNode.class, DuctObjectRoot.DuctNode.PROP_TYPES, DUCT_GROUP_ICON, Intl.intl("Duct Group"));
        compHelper.register();
        EntryPointHelper<Junction> junctionHelper = EntryPointHelper.objectEP(GUID, Junction.class, Junction.PROP_TYPES, JUNCTION_ICON, Intl.intl("Duct Junction"));
        junctionHelper.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (!obj.isValidJunction()) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s is not connected to any duct segments."), obj.getName()), Intl.intl("Delete Junction or attach to a valid duct segment."), (IMerlinObj)obj));
            }
            if (obj.getHeightExceedsFloorMinMax()) {
                errors.add(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("%s has a relative elevation exceeding its level."), obj.getName()), Intl.intl("Delete Junction or change its relative elevation to a value within the level height."), (IMerlinObj)obj));
            }
            if (obj.getJunctionType() == Junction.JunctionType.AMBIENT_TERMINAL && !obj.get(Junction.CONSTANT_WIND_PRESSURE).booleanValue() && obj.get(Junction.WIND_PROFILE) == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s uses variable ambient wind pressure without a defined wind profile."), obj.getName()), Intl.intl("Delete Junction or create and assign a wind profile."), (IMerlinObj)obj));
            }
            return errors;
        };
        junctionHelper.register();
        EntryPointHelper<Segment> segmentHelper = EntryPointHelper.objectEP(GUID, Segment.class, Segment.PROP_TYPES, SEGMENT_ICON, Intl.intl("Duct Segment"));
        segmentHelper.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.get(Segment.ELEMENT).get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.DARCEY_COLEBROOK && obj.getEffectiveLength().getValue(SI.METER) == 0.0 && obj.get(Segment.SUM_OF_LOSS_COEFFICIENTS) == 0.0) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s using a Darcey-Colebrook element must have length or sum of loss coefficients greater than 0."), obj.getName()), Intl.intl("Delete the segment or change segment properties."), (IMerlinObj)obj));
            }
            if (DuctsUtil.findIdenticallyShapedSegment(obj)) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s directly connecting two junctions is identical to 1 or more segment(s)."), obj.getName()), Intl.intl("Delete the segment or the other identical segment(s)."), (IMerlinObj)obj));
            }
            if (obj.get(Segment.ELEMENT).get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE && obj.get(Segment.MULTIPLIER).isConstant()) {
                errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("The Performance Curve cutoff condition is turned off when a Constant Multiplier is used."), Intl.intl("Select a Scheduled Multiplier for Segments with a Performance Curve element type."), new IMerlinObj[0]));
            }
            return errors;
        };
        segmentHelper.register();
        EntryPointHelper<SegmentWaypoint> waypointHelper = EntryPointHelper.objectEP(GUID, SegmentWaypoint.class, SegmentWaypoint.PROP_TYPES, SEGMENT_WAYPOINT_ICON, Intl.intl("Duct Segment Waypoint"));
        waypointHelper.isIndexed = new EntryPointFactory.ConstantGetter(true);
        waypointHelper.register();
    }
}

