/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.NamedMerlinObj;
import ventus.data.schematics.ISchematicObj;

public class DuctObjectRoot
extends Composite<NamedMerlinObj> {
    private static final long serialVersionUID = 1L;
    private NameGenerator d_junctionNameGen = new NameGenerator(Intl.intl("Junction"));
    private NameGenerator d_segmentNameGen = new NameGenerator(Intl.intl("Segment"));

    public DuctObjectRoot() {
        super(Intl.intl("Ducts"));
    }

    @Override
    public void clear() {
        super.clear();
        this.d_junctionNameGen.reset();
        this.d_segmentNameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (obj instanceof DuctObjectRoot) {
            DuctObjectRoot root = (DuctObjectRoot)obj;
            this.d_junctionNameGen = root.d_junctionNameGen;
            this.d_segmentNameGen = root.d_segmentNameGen;
        }
    }

    public String nextJunctionName() {
        String name = this.d_junctionNameGen.generateName();
        this.d_junctionNameGen.registerName(name);
        return name;
    }

    public String nextSegmentName() {
        String name = this.d_segmentNameGen.generateName();
        this.d_segmentNameGen.registerName(name);
        return name;
    }

    public void reset() {
        this.clear();
    }

    @Override
    public Composite<NamedMerlinObj> newGroup(String name) {
        return new DuctNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Duct Group");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.readTopology(in);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    static class DuctNode
    extends Composite<NamedMerlinObj> {
        public DuctNode(String name) {
            super(name);
        }

        @Override
        public Composite<NamedMerlinObj> newGroup(String name) {
            return new DuctNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Duct Group");
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.writeTopology(out);
            }
        }
    }
}

