/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.ComponentSizeFixer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.PowerlawGuiUtil;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.dependencies.powerlaw.PowerlawUtil;
import ventus.feature.ducts.DuctFlowElement;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class DuctFlowElementEditor
extends guiPanel
implements IEditor<DuctFlowElement> {
    private static final long serialVersionUID = 1L;
    private final PowerlawGuiUtil.Bindings<DuctFlowElement> d_bindings = new PowerlawGuiUtil.Bindings();
    private final List<Consumer<DuctFlowElement>> d_onInit = new ArrayList<Consumer<DuctFlowElement>>();

    public DuctFlowElementEditor(Window owner, UnitSystem us) {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        guiTextField name = this.d_bindings.bind(DuctFlowElement.NAME, new guiTextField());
        name.setEnabled(false);
        guiTextField desc = this.d_bindings.bind(DuctFlowElement.DESC, new guiTextField());
        ColorButton color = this.d_bindings.bind(DuctFlowElement.COLOR, guiUtil.newColorButton());
        guiComboBox<PowerlawModel> cbPowerLaw = PowerlawGuiUtil.createPowerlawCombo(PowerlawModel.Usage.DUCT);
        this.d_bindings.bind(cbPowerLaw, new PowerlawGuiUtil.Binding<DuctFlowElement>(data -> cbPowerLaw.setSelectedItem(data.get(DuctFlowElement.POWERLAW_MODEL)), data -> data.set(DuctFlowElement.POWERLAW_MODEL, (PowerlawModel)cbPowerLaw.getSelectedItem())));
        DuctFlowElementEditor.addRow((guiPanel)this, DuctFlowElement.NAME.name, Intl.intl("Unique duct flow element name."), name, "growx, wrap");
        DuctFlowElementEditor.addRow((guiPanel)this, DuctFlowElement.DESC, desc, "width pref*2.5, growx, wrap");
        DuctFlowElementEditor.addRow((guiPanel)this, DuctFlowElement.COLOR, color, "sg 1, wrap");
        DuctFlowElementEditor.addRow((guiPanel)this, Intl.intl("Model"), null, cbPowerLaw, "sg 1, wrap");
        guiPanel coefficientPanel = new guiPanel(new MigLayout());
        ValueField<Double> coefLam = ValueFields.doubleFld();
        coefLam.setEditable(false);
        ValueField<Double> coefTurb = ValueFields.doubleFld();
        coefTurb.setEditable(false);
        DuctFlowElementEditor.addRow(coefficientPanel, Intl.intl("Laminar Coefficient:"), null, coefLam, "sg 1, wrap");
        DuctFlowElementEditor.addRow(coefficientPanel, Intl.intl("Turbulent Coefficient:"), null, coefTurb, "sg 1, wrap");
        JTabbedPane tabs = new JTabbedPane();
        guiPanel cardsPanel = this.createCardPanel(us);
        tabs.addTab(Intl.intl("Flow Model"), PowerlawGuiUtil.wrapNonMigPanel(cardsPanel));
        tabs.addTab(Intl.intl("Shape"), this.createTabGeom(us));
        tabs.addTab(Intl.intl("Leakage"), this.createTabLeakage(us));
        this.add((Component)tabs, "span, grow, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        this.add((Component)coefficientPanel, "grow, span, wrap");
        cbPowerLaw.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                CardLayout cards = (CardLayout)cardsPanel.getLayout();
                cards.show(cardsPanel, ((PowerlawModel)evt.getItem()).toString());
                coefficientPanel.setVisible(DuctFlowElementEditor.isLamTurbCalcSupported((PowerlawModel)evt.getItem()));
            }
        });
        ComponentSizeFixer.fromExistingContainer(this).setAllPreferredWidthToMax();
        final Runnable updateCoefs = () -> {
            if (this.validateData(false, false)) {
                DuctFlowElement temp = new DuctFlowElement("");
                this.d_bindings.store(temp);
                if (DuctFlowElementEditor.isLamTurbCalcSupported((PowerlawModel)temp.get(DuctFlowElement.POWERLAW_MODEL))) {
                    coefLam.setValue(PowerlawUtil.getLaminarFlow(temp));
                    coefTurb.setValue(PowerlawUtil.getTurbulentFlow(temp));
                }
            }
        };
        this.getComm().addObserver((src, arg) -> updateCoefs.run());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                updateCoefs.run();
                DuctFlowElementEditor.this.setModified(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private static boolean isLamTurbCalcSupported(PowerlawModel model) {
        return !model.equals(PowerlawModel.DARCEY_COLEBROOK) && !model.equals(PowerlawModel.CONSTANT_MASS_FLOW_FAN) && !model.equals(PowerlawModel.CONSTANT_VOLUME_FLOW_FAN) && !model.equals(PowerlawModel.Q_V_P);
    }

    private guiPanel createCardPanel(UnitSystem us) {
        guiPanel cardsPanel = new guiPanel(new CardLayout());
        cardsPanel.add((Component)this.createCardDarcyColebrook(us), PowerlawModel.DARCEY_COLEBROOK.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardOrificeArea(us, this.d_bindings, true), PowerlawModel.ORIFICE_AREA.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardConstantMassFlowFan(us, this.d_bindings), PowerlawModel.CONSTANT_MASS_FLOW_FAN.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardConstantVolumeFlowFan(us, this.d_bindings), PowerlawModel.CONSTANT_VOLUME_FLOW_FAN.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardPerformanceCurve(us, this.d_bindings), PowerlawModel.PERFORMANCE_CURVE.toString());
        cardsPanel.add((Component)PowerlawGuiUtil.createCardQvP(us, this.d_bindings), PowerlawModel.Q_V_P.toString());
        return cardsPanel;
    }

    private static List<Component> addRow(guiPanel migPanel, IDisplayProp<?> prop, Component comp, String ... compConstraints) {
        return DuctFlowElementEditor.addRow(migPanel, prop.getDisplayName(), prop.getDisplayDesc(), comp, compConstraints);
    }

    private static List<Component> addRow(guiPanel migPanel, String intl, String tooltip, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = guiUtil.lblPropHtml(intl, tooltip);
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    @Override
    public void init(DuctFlowElement dataObj) {
        ManagerDlg.defaultInit(this, dataObj, obj -> {
            this.setEnabled(dataObj != null);
            this.d_bindings.load(dataObj);
            this.d_onInit.forEach(handler -> handler.accept(dataObj));
        });
    }

    @Override
    public DuctFlowElement commit(DuctFlowElement dataObj) {
        return ManagerDlg.defaultCommit(this, dataObj, Intl.intl("Edit Duct Flow Elements"), "DuctFlowElementEditor.commit", obj -> this.d_bindings.store(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private guiPanel createCardDarcyColebrook(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout(PowerlawGuiUtil.getStandardMigLayoutConstraintsForTabs(), PowerlawGuiUtil.getStandardMigDimConstraintsForTabs()));
        ValueField<UnitDouble> roughness = this.d_bindings.bind(IPowerlawObj.DUCT_ROUGHNESS, ValueFields.udFld(DoubleVR.above(0.0, true), us.getLength()));
        DuctFlowElementEditor.addRow(card, IPowerlawObj.DUCT_ROUGHNESS.name, IPowerlawObj.DUCT_ROUGHNESS.desc, roughness, new String[0]);
        return card;
    }

    private guiPanel createTabGeom(UnitSystem us) {
        guiPanel tab = new guiPanel(new MigLayout(PowerlawGuiUtil.appendHideMode(PowerlawGuiUtil.getStandardMigLayoutConstraintsForTabs()), PowerlawGuiUtil.getStandardMigDimConstraintsForTabs()));
        guiComboBox<IPowerlawObj.DuctShape> shape = new guiComboBox<IPowerlawObj.DuctShape>((T[])IPowerlawObj.DuctShape.values());
        this.d_bindings.bind(shape, new PowerlawGuiUtil.Binding<DuctFlowElement>(data -> shape.setSelectedItem(data.get(DuctFlowElement.DUCT_SHAPE)), data -> data.set(DuctFlowElement.DUCT_SHAPE, (IPowerlawObj.DuctShape)shape.getSelectedItem())));
        ValueField<UnitDouble> diameter = this.d_bindings.bind(DuctFlowElement.DUCT_CIRCLE_DIAMETER, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> rectHeight = this.d_bindings.bind(DuctFlowElement.DUCT_RECT_HEIGHT, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> rectWidth = this.d_bindings.bind(DuctFlowElement.DUCT_RECT_WIDTH, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> majorDim = this.d_bindings.bind(DuctFlowElement.DUCT_OVAL_MAJOR, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> minorDim = this.d_bindings.bind(DuctFlowElement.DUCT_OVAL_MINOR, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> perim = this.d_bindings.bind(DuctFlowElement.DUCT_PERIMETER, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> flowArea = this.d_bindings.bind(DuctFlowElement.DUCT_FLOW_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        DuctFlowElementEditor.addRow(tab, Intl.intl("Shape"), null, shape, new String[0]);
        List<Component> circleComps = DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_CIRCLE_DIAMETER.name, DuctFlowElement.DUCT_CIRCLE_DIAMETER.desc, diameter, new String[0]);
        List<Component> rectComps = DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_RECT_HEIGHT.name, DuctFlowElement.DUCT_RECT_HEIGHT.desc, rectHeight, new String[0]);
        rectComps.addAll(DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_RECT_WIDTH.name, DuctFlowElement.DUCT_RECT_WIDTH.desc, rectWidth, new String[0]));
        List<Component> ovalComps = DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_OVAL_MAJOR.name, DuctFlowElement.DUCT_OVAL_MAJOR.desc, majorDim, new String[0]);
        ovalComps.addAll(DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_OVAL_MINOR.name, DuctFlowElement.DUCT_OVAL_MINOR.desc, minorDim, new String[0]));
        List<Component> genericComps = DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_PERIMETER.name, DuctFlowElement.DUCT_PERIMETER.desc, perim, new String[0]);
        genericComps.addAll(DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_FLOW_AREA.name, DuctFlowElement.DUCT_FLOW_AREA.desc, flowArea, new String[0]));
        Consumer<IPowerlawObj.DuctShape> updateFields = ds -> {
            circleComps.forEach(item -> item.setVisible(ds == IPowerlawObj.DuctShape.CIRCLE));
            rectComps.forEach(item -> item.setVisible(ds == IPowerlawObj.DuctShape.RECTANGLE));
            ovalComps.forEach(item -> item.setVisible(ds == IPowerlawObj.DuctShape.OVAL));
            genericComps.forEach(item -> item.setVisible(ds == IPowerlawObj.DuctShape.OTHER));
            tab.revalidate();
            tab.repaint();
        };
        shape.addItemListener(evt -> updateFields.accept((IPowerlawObj.DuctShape)shape.getSelectedItem()));
        this.d_onInit.add(elem -> updateFields.accept((IPowerlawObj.DuctShape)shape.getSelectedItem()));
        return tab;
    }

    private guiPanel createTabLeakage(UnitSystem us) {
        guiPanel tab = new guiPanel(new MigLayout(PowerlawGuiUtil.getStandardMigLayoutConstraintsForTabs(), PowerlawGuiUtil.getStandardMigDimConstraintsForTabs()));
        ValueField<UnitDouble> leakRate = this.d_bindings.bind(DuctFlowElement.DUCT_LEAKAGE_RATE, ValueFields.udFld(DoubleVR.above(0.0, true), us.getLeakageRate()));
        ValueField<UnitDouble> pressureDiff = this.d_bindings.bind(DuctFlowElement.PRESSURE_DIFFERENCE, ValueFields.udFld(DoubleVR.above(0.0, true), us.getPressure()));
        DuctFlowElementEditor.addRow(tab, DuctFlowElement.DUCT_LEAKAGE_RATE.name, DuctFlowElement.DUCT_LEAKAGE_RATE.desc, leakRate, new String[0]);
        DuctFlowElementEditor.addRow(tab, DuctFlowElement.PRESSURE_DIFFERENCE.name, DuctFlowElement.PRESSURE_DIFFERENCE.desc, pressureDiff, new String[0]);
        return tab;
    }
}

