/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;

public enum PowerlawModel implements ILabeled
{
    ORIFICE_AREA(Intl.intl("Orifice Area"), Intl.intl("Airflow through an orifice on the face of a room."), List.of(Usage.FLOWPATH, Usage.DUCT), List.of("plr_orfc", "dct_plr")),
    LEAKAGE_AREA(Intl.intl("Leakage Area"), "plr_leak", Intl.intl("A typical area of leakage that occurs between rooms in residential buildings."), Usage.FLOWPATH),
    STAIRWELL(Intl.intl("Stairwell"), "plr_stair", Intl.intl("Airflow within a building stairwell."), Usage.FLOWPATH),
    SHAFT(Intl.intl("Shaft"), "plr_shaft", Intl.intl("Airflow within a building shaft, typically for an elevator."), Usage.FLOWPATH),
    Q_V_P(Intl.intl("Q vs P"), "csf_qsp", Intl.intl("Volume flow rate as a function of pressure difference across the element."), Usage.FLOWPATH),
    SELF_REG_VENT(Intl.intl("Self-regulating Vent"), "srv_jwa", Intl.intl("Two-way airflow across a path with bidirectional limits on airflow rate."), Usage.FLOWPATH),
    CONSTANT_MASS_FLOW_FAN(Intl.intl("Constant Mass Flow Fan"), Intl.intl("Airflow has a constant mass flow rate."), List.of(Usage.FLOWPATH, Usage.DUCT), List.of("fan_cmf", "dct_cmf")),
    CONSTANT_VOLUME_FLOW_FAN(Intl.intl("Constant Volume Flow Fan"), Intl.intl("Airflow has a constant volume flow rate."), List.of(Usage.FLOWPATH, Usage.DUCT), List.of("fan_cvf", "dct_cvf")),
    PERFORMANCE_CURVE(Intl.intl("Performance Curve"), Intl.intl("Create a fan based on a performance curve."), List.of(Usage.FLOWPATH, Usage.DUCT), List.of("fan_fan", "dct_fan")),
    TWOWAY_ONE(Intl.intl("Two-way - One Opening"), "dor_door", Intl.intl("Two-way airflow for large openings such as doors."), Usage.FLOWPATH),
    TWOWAY_TWO(Intl.intl("Two-way - Two Opening"), "dor_pl2", Intl.intl("Two-way airflow accounting for the stack effect on tall openings."), Usage.FLOWPATH),
    DARCEY_COLEBROOK(Intl.intl("Darcy-Colebrook"), "dct_dwc", Intl.intl("Use the Darcy-Weisbach relation and Colebrook's natural roughness."), Usage.DUCT),
    TEST_ONE(Intl.intl("Test Data (1-point)"), Intl.intl("Powerlaw model based on an observed flow rate and pressure drop."), Usage.FLOWPATH, "plr_test1"),
    TEST_TWO(Intl.intl("Test Data (2-point)"), Intl.intl("Powerlaw model based on two observed flow rates and pressure drops."), Usage.FLOWPATH, "plr_test2"),
    CRACK_DESCRIPTION(Intl.intl("Crack Description"), Intl.intl("Airflow through a crack basedd on the powerlaw model."), Usage.FLOWPATH, "plr_crack");

    public final String name;
    public final PropertySet defaultProps;
    public final String description;
    private final Map<Usage, String> usageToDesc = new HashMap<Usage, String>();

    private PowerlawModel(String name, String type, String description, Usage usage) {
        this(name, description, usage, type, Collections.emptyList());
    }

    private PowerlawModel(String name, String description, Usage usage, String type) {
        this(name, description, usage, type, Collections.emptyList());
    }

    private PowerlawModel(String name, String description, Usage usage, String type, List<TypedProp<?>> defaultProps) {
        this.name = name;
        this.description = description;
        this.defaultProps = new PropertySet();
        this.usageToDesc.put(usage, type);
        for (TypedProp<?> prop : defaultProps) {
            this.defaultProps.set(prop, prop.defVal);
        }
    }

    private PowerlawModel(String name, String description, List<Usage> usages, List<String> types) {
        this(name, description, usages, types, Collections.emptyList());
    }

    private PowerlawModel(String name, String description, List<Usage> usages, List<String> types, List<TypedProp<?>> defaultProps) {
        this.name = name;
        this.description = description;
        this.defaultProps = new PropertySet();
        IntStream.range(0, Math.min(usages.size(), types.size())).forEach(i -> this.usageToDesc.put((Usage)((Object)((Object)usages.get(i))), (String)types.get(i)));
        for (TypedProp<?> prop : defaultProps) {
            this.defaultProps.set(prop, prop.defVal);
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean doesUsageApply(Usage usage) {
        return this.usageToDesc.containsKey((Object)usage);
    }

    public String getType(Usage usage) {
        return this.usageToDesc.get((Object)usage);
    }

    public static enum Usage {
        FLOWPATH,
        DUCT;

    }
}

