/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;

public class PowerlawMathUtil {
    public static final double RHO = 1.2041;
    public static final double MU = 1.81625E-5;
    public static final double MUAIR = 1.81625E-5;
    public static final double RHOAIR = 1.2041;
    public static final double SRHO = Math.sqrt(1.2041);
    public static final double DPTMIN = 1.0E-128;
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double RE_LT = 30.0;

    public static double orificeAreaTurbulentFlow(double a, double cD) {
        return SQRT2 * cD * a;
    }

    public static double orificeAreaLaminarFlow(double re, double a, double cD, double dH, double exp) {
        double cT = PowerlawMathUtil.orificeAreaTurbulentFlow(a, cD);
        double fTrans = PowerlawMathUtil.fTrans(re, a, dH);
        double dpTrans = PowerlawMathUtil.dpTrans(fTrans, cT, exp);
        double cL = PowerlawMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static UnitDouble areaToDiameter(UnitDouble area) {
        return area.divide(new UnitDouble(Math.PI, Unit.ONE)).root(2).multiply(new UnitDouble(2.0, Unit.ONE));
    }

    public static double calcTestPoint1LaminarFlow(double dp, double flow, double exp) {
        double re = 30.0;
        double turb = PowerlawMathUtil.calcTestPointTurbulentFlow(flow, dp, exp);
        double area = turb / (0.6 * SQRT2);
        double dia = Math.sqrt(area);
        double f_trans = PowerlawMathUtil.fTrans(re, area, dia);
        double dp_Trans = PowerlawMathUtil.dpTrans(f_trans, turb, exp);
        return PowerlawMathUtil.laminarFlow(f_trans, dp_Trans);
    }

    public static double calcTestPoint2LaminarFlow(double dp1, double flow1, double dp2, double flow2) {
        double re = 30.0;
        double exp = Math.log(flow2 / flow1) / Math.log(dp2 / dp1);
        double turb = PowerlawMathUtil.calcTestPointTurbulentFlow(flow1, dp1, exp);
        double area = turb / (0.6 * SQRT2);
        double dia = Math.sqrt(area);
        double f_trans = PowerlawMathUtil.fTrans(re, area, dia);
        double dp_Trans = PowerlawMathUtil.dpTrans(f_trans, turb, exp);
        return PowerlawMathUtil.laminarFlow(f_trans, dp_Trans);
    }

    public static double calcTestPointTurbulentFlow(double flowRate, double pressureDiff, double exp) {
        return flowRate / (SRHO * Math.pow(pressureDiff, exp));
    }

    public static double calcTestPoint2TurbulentFlow(double dp1, double flow1, double dp2, double flow2) {
        double exp = Math.log(flow2 / flow1) / Math.log(dp2 / dp1);
        return flow1 / (SRHO * Math.pow(dp1, exp));
    }

    public static double calcCrackDescriptionTurbulentFlow(double width, double length) {
        double expt = PowerlawMathUtil.calcCrackExpt(width);
        return SRHO * length * 0.0097 * Math.pow(0.0092, expt);
    }

    public static double calcCrackDescriptionLaminarFlow(double width, double length) {
        double re = 30.0;
        double expt = PowerlawMathUtil.calcCrackExpt(width);
        double turb = PowerlawMathUtil.calcCrackDescriptionTurbulentFlow(width, length);
        double area = length * width;
        double diam = 2.0 * area / (length + width);
        double f_trans = PowerlawMathUtil.fTrans(re, area, diam);
        double dp_Trans = PowerlawMathUtil.dpTrans(f_trans, turb, expt);
        return PowerlawMathUtil.laminarFlow(f_trans, dp_Trans);
    }

    public static double calcCrackExpt(double width) {
        return 0.5 + 0.5 * Math.exp(-500.0 * width);
    }

    public static double getFanFanLaminarFlow(double a) {
        double cturb = PowerlawMathUtil.orificeAreaTurbulentFlow(a, 0.6);
        double re = 100.0;
        double qTrans = 1.81625E-5 * re * a / (1.2041 * Math.sqrt(a));
        double dpTrans = Math.pow(Math.sqrt(1.2041) * qTrans / cturb, 2.0);
        double clam = 1.81625E-5 * qTrans / dpTrans;
        assert (!Double.isNaN(clam));
        return clam;
    }

    public static double getTwoWayLaminarFlow(double a, double dH, double cD, boolean twoOpening) {
        double fTrans = PowerlawMathUtil.fTrans(30.0, a, dH);
        double cT = twoOpening ? PowerlawMathUtil.orificeAreaTurbulentFlow(a / 2.0, cD) : PowerlawMathUtil.orificeAreaTurbulentFlow(a, cD);
        double dpTrans = PowerlawMathUtil.dpTrans(fTrans, cT, 0.5);
        double cL = PowerlawMathUtil.laminarFlow(fTrans, dpTrans);
        return cL;
    }

    public static double stairwellEffectiveArea(double a, double h, double d, boolean to) {
        return to ? a * 0.089 * h * (1.0 - 0.14 * Math.sqrt(d)) : a * 0.083 * h * (1.0 - 0.24 * Math.sqrt(d));
    }

    public static double stairwellTurbulentFlow(double a, double h, double d, boolean to) {
        return PowerlawMathUtil.stairwellTurbulentFlow(PowerlawMathUtil.stairwellEffectiveArea(a, h, d, to));
    }

    public static double stairwellTurbulentFlow(double ae) {
        return Math.sqrt(2.0) * 0.6 * ae;
    }

    public static double stairwellLaminarFlow(double a, double h, double d, double exp, boolean to) {
        double ae = PowerlawMathUtil.stairwellEffectiveArea(a, h, d, to);
        double dH = Math.sqrt(ae);
        double cT = PowerlawMathUtil.stairwellTurbulentFlow(ae);
        double fTrans = PowerlawMathUtil.fTrans(30.0, ae, dH);
        double dpTrans = PowerlawMathUtil.dpTrans(fTrans, cT, exp);
        double cL = PowerlawMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static double leakageAreaTurbulentFlow(double a, double cD, double dP, double exp) {
        return a * cD * Math.sqrt(2.0) * Math.pow(dP, 0.5 - exp);
    }

    public static double leakageAreaLaminarFlow(double a, double cD, double dP, double exp) {
        double dH = Math.sqrt(a);
        double cT = PowerlawMathUtil.leakageAreaTurbulentFlow(a, cD, dP, exp);
        double fTrans = PowerlawMathUtil.fTrans(30.0, a, dH);
        double dpTrans = PowerlawMathUtil.dpTrans(fTrans, cT, exp);
        double cL = PowerlawMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static double fTrans(double re, double a, double dH) {
        assert (Math.abs(dH) > 0.0);
        return 1.81625E-5 * re * a / dH;
    }

    public static double dpTrans(double fTrans, double cT, double exp) {
        assert (Math.abs(cT * Math.sqrt(1.2041)) > 0.0);
        assert (Math.abs(exp) > 0.0);
        return Math.pow(fTrans / (cT * Math.sqrt(1.2041)), 1.0 / exp);
    }

    public static double laminarFlow(double fTrans, double dpTrans) {
        assert (Math.abs(1.2041 * dpTrans) > 0.0);
        return 1.81625E-5 * fTrans / (1.2041 * dpTrans);
    }

    public static ShaftCalcOutput getShaftData(double ht, double area, double perim, double rough) {
        double dia = 4.0 * area / perim;
        double rr = rough / dia;
        double Re = 4000.0;
        double v = 1.81625E-5 * Re / (1.2041 * dia);
        double F1 = 1.2041 * v * area;
        double ff = PowerlawMathUtil.ffdwc(rr, Re, 0.04);
        double dP1 = 0.5 * ff * ht / dia * 1.2041 * v * v;
        double F2 = 1.2041 * (v *= 10.0) * area;
        ff = PowerlawMathUtil.ffdwc(rr, Re *= 10.0, ff);
        double dP2 = 0.5 * ff * ht / dia * 1.2041 * v * v;
        Re = 1000.0;
        double F = 1.81625E-5 * Re * area / dia;
        double expt = Math.log(F2 / F1) / Math.log(dP2 / dP1);
        double turb = F1 / (SRHO * Math.pow(dP1, expt));
        double dP = Math.pow(F / (turb * SRHO), 1.0 / expt);
        if (dP < 1.0E-128) {
            dP = 1.0E-128;
        }
        double lam = 1.81625E-5 * F / (1.2041 * dP);
        return new ShaftCalcOutput(expt, lam, turb);
    }

    public static double ffdwc(double ed, double Re, double f) {
        double RE_MAX_LAM = 2300.0;
        double RE_MIN_TURB = 3500.0;
        double c = 0.868589;
        double tol = 1.0E-7;
        if (Re >= 3500.0) {
            double dg;
            double b = 2.51 / Re;
            double a = ed / 3.7;
            double g = 1.0 / Math.sqrt(f);
            while (Math.abs((dg = (g + 0.868589 * Math.log(a + g * b)) / (1.0 + 0.868589 * b / (a + g * b))) / (g -= dg)) > 1.0E-7) {
            }
            f = 1.0 / (g * g);
        } else if (Re <= 2300.0) {
            f = 64.0 / Re;
        } else {
            double f0 = 0.02782608695652174;
            double f1 = PowerlawMathUtil.ffdwc(ed, 3500.0, 0.04);
            double x0 = (Re - 2300.0) / 1200.0;
            f = f1 * x0 + f0 * (1.0 - x0);
        }
        return f;
    }

    public static class ShaftCalcOutput {
        public final double flowExponent;
        public final double coefLaminar;
        public final double coefTurbulent;

        public ShaftCalcOutput(double flowExponent, double coefLaminar, double coefTurbulent) {
            this.flowExponent = flowExponent;
            this.coefLaminar = coefLaminar;
            this.coefTurbulent = coefTurbulent;
        }
    }
}

