/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.coreextensions;

import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.data.value.Schedule;
import ventus.data.value.ScheduleUtil;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class ZoneOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        if (updateVer == 216 && streamVer < 216) {
            boolean changed = false;
            FloorComposite root = vd.floors;
            for (SchematicRoom zone : root.flatten(SchematicRoom.class)) {
                Schedule temperature = zone.get(SchematicRoom.TEMPERATURE_SCHEDULE);
                if (ScheduleUtil.isTimeSorted(temperature)) continue;
                zone.set(SchematicRoom.TEMPERATURE_SCHEDULE, ScheduleUtil.fixTimeSort(temperature));
                warns.addWarning(new Warning(String.format(Intl.intl("Temperature schedule for Zone, \"%1$s\", had out-of-order time entries."), zone.getName()), Intl.intl("Sorted temperature schedule.")));
                changed = true;
            }
            return changed;
        }
        return false;
    }
}

