/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.comps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextField;
import thunderheadeng.gui.guiComboBox;

public interface IPropUpdater {
    public BiConsumer<Component, Boolean> updateCommand();

    default public void addTFAction(final JTextField field, boolean respondToKeys, final BiConsumer<Component, Boolean> action) {
        field.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                action.accept(field, true);
            }
        });
        if (!respondToKeys) {
            return;
        }
        field.addKeyListener(new KeyAdapter(this){

            @Override
            public void keyReleased(KeyEvent e) {
                action.accept(field, false);
            }
        });
    }

    default public <T extends JTextField> T initValueField(T field) {
        return this.initValueField(field, true, null);
    }

    default public <T extends JTextField> T initValueField(T field, boolean respondToKeys) {
        return this.initValueField(field, respondToKeys, null);
    }

    default public <T extends JTextField> T initValueField(T field, BiConsumer<Component, Boolean> action) {
        return this.initValueField(field, true, action);
    }

    default public <T extends JTextField> T initValueField(T field, boolean respondToKeys, BiConsumer<Component, Boolean> action) {
        Dimension ps = field.getPreferredSize();
        ps.height -= 2;
        field.setPreferredSize(ps);
        field.setColumns(10);
        if (action != null) {
            this.addTFAction(field, respondToKeys, action);
        }
        this.addTFAction(field, respondToKeys, this.updateCommand());
        return field;
    }

    default public void addActionListener(AbstractButton btn, BiConsumer<Component, Boolean> cmd) {
        if (cmd != null) {
            btn.addActionListener(e -> cmd.accept(btn, true));
        }
        btn.addActionListener(e -> this.updateCommand().accept(btn, true));
    }

    default public <T> guiComboBox<T> initComboBox(Collection<T> objs) {
        return this.initComboBox(new guiComboBox<T>(objs));
    }

    default public <T extends guiComboBox<?>> T initComboBox(T cb) {
        Dimension ps = cb.getPreferredSize();
        ps.height -= 2;
        cb.setPreferredSize(ps);
        cb.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.updateCommand().accept(cb, true);
        });
        return cb;
    }

    default public <T extends AbstractButton> T initButton(T btn) {
        return this.initButton(btn, null);
    }

    default public <T extends AbstractButton> T initButton(T btn, BiConsumer<Component, Boolean> action) {
        if (btn instanceof JButton) {
            Dimension ps = btn.getPreferredSize();
            ps.height -= 4;
            btn.setPreferredSize(ps);
        }
        this.addActionListener(btn, action);
        return btn;
    }
}

