/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.comps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointHelper;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.comps.IDataModel;

public final class DefaultCompositeDataModel<T extends Composite<V>, V extends IMerlinObj>
implements IDataModel {
    private final CompositeFeatureGuid<T, V> d_guid;
    private final Supplier<T> d_data;
    private final int d_seqIx;
    private final Collection<EntryPointHelper<? extends IMerlinObj>> d_epHelpers;

    public DefaultCompositeDataModel(Supplier<T> data, CompositeFeatureGuid<T, V> guid, int seqIx) {
        this.d_data = data;
        this.d_guid = guid;
        this.d_seqIx = seqIx;
        this.d_epHelpers = new ArrayList<EntryPointHelper<? extends IMerlinObj>>();
    }

    public <E extends EntryPointHelper> E addEntryPoint(E epHelper) {
        this.d_epHelpers.add(epHelper);
        return epHelper;
    }

    @Override
    public void init(VentusData vd) {
        vd.setComponentData(this.d_guid, (Composite)this.d_data.get());
    }

    @Override
    public void reset(VentusData vd) {
        ((Composite)vd.getComponentData(this.d_guid)).clear();
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        Composite srcData = (Composite)src.getComponentData(this.d_guid);
        Composite destData = (Composite)dest.getComponentData(this.d_guid);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
        assert (destData == dest.getComponentData(this.d_guid));
    }

    @Override
    public void addTreeRoots(VentusData vd, GroupedSequence roots) {
        roots.add(this.d_seqIx, vd.getComponentData(this.d_guid));
    }

    @Override
    public void registerEntryPointData() {
        this.d_epHelpers.forEach(helper -> helper.register());
    }
}

