/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahssimple;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AddObject;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSEditor;
import ventus.feature.ahssimple.SimpleAHSFeature;
import ventus.feature.ahssimple.SimpleAHSManager;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.gui.ManagerDlg;

public class SimpleAHSManagerDlg
extends ManagerDlg<SimpleAHS, SimpleAHSManager> {
    private static final long serialVersionUID = 1L;
    private final SimpleAHSEditor d_editor = new SimpleAHSEditor();
    private SimpleAHSManager d_manager;

    protected SimpleAHSManagerDlg(JFrame owner, VentusApp app) {
        super(owner, app, Intl.intl("Edit Air Handling Systems"), SimpleAHS.class);
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new ManagerDlg.LibraryAction(this, Intl.intl("Air Handling System"), vd -> (Composite)vd.getComponentData(SimpleAHSFeature.GUID), "lib/simpleahs", "simpleahs"));
        this.addAction(new ManagerDlg.RenameAction(this, SimpleAHS.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, SimpleAHSManager manager, SimpleAHS node) {
        super.init(data, manager, this.d_editor, SimpleAHSFeature.ICON);
        this.d_manager = manager;
        this.updateActions();
        this.getList().select(node);
        ManagerDlg.defaultInit(this.d_editor, node, obj -> {});
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        SimpleAHSRoot root = this.d_manager.getRoot();
        final guiTextField nameField = new guiTextField(root.getSuggestedName());
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SimpleAHSManagerDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Air Handling System"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            Undo.begin(Intl.intl("Create AHS"));
            AddObject.add(this.getVentusData(), root, List.of(new SimpleAHS(nameField.getValue())));
            Undo.end(this.getVentusData());
        }
    }
}

