/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSFeature;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.geom.GeomUtil;
import ventus.geom.PointEntityGeom;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.mv.tools.RoomSnapConstraint;
import ventus.util.Dependencies;

public class AHSPoint
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
ICyclicSurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<AHSPoint> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(AHSPoint.class, new PropertyDefsFramework.Storage<AHSPoint>(obj -> obj.d_properties, obj -> obj.d_transientProps, obj -> {
        obj.d_properties = new PropertySet();
        obj.d_transientProps = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrFireEvents((p, o) -> o.changedEvt(p, VentusData.TOPOLOGY)).attrFinish();
    static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"AHSPoint.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(AHSPoint::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(AHSPoint::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final TypedProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final TypedProp<UnitDouble> SIZE = TypedProps.build((Object)"AHS.SIZE", new UnitDouble(1.0, SI.METER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    private static final DepCallback<VentusData, AHSPoint, ISchematicRoom, ISchematicRoom> COMP_CALLBACK = Dependencies.newDependencyContainedBy(ISchematicRoom.class);
    public static final TypedProp<ISchematicRoom> ROOM = TypedProps.build((Object)"AHS.ROOM", ISchematicRoom.class).attrStoreAsTopologyDirect(PROP_TYPES).attrDependency(prop -> COMP_CALLBACK).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Point3d> LOCATION = TypedProps.build("AHS.LOCATION", Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents(AHSPoint.getTopoFireEvents()).attrFinish();
    public static final TypedProp<Vector3d> ROOM_NORMAL = TypedProps.build("AHS.ROOM_NORMAL", Vector3d.class, new Vector3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<UnitDouble> DESIGN_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"AHS.DESIGN_FLOW_RATE", UnitDouble.class, new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Design Flow Rate"), Intl.intl("The Design Flow Rate")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(17)).attrFinish();
    public static final DisplayProp<Types> TYPES = (DisplayProp)DisplayProps.build((Object)"AHS.TYPES", Types.class, Types.SUPPLY, Intl.intl("AHS Zone Point Type"), Intl.intl("Indicates whether the air handling device is a supply or return")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(Types.values())).attrFinish();
    public static final DisplayProp<SimpleAHS> AHS = DisplayProps.build((Object)"AHSPoint.AHS", SimpleAHS.class, null, Intl.intl("Air Handling System"), Intl.intl("The Air Handling System")).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, SimpleAHS.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(PropComparisons.getFeatureSrc(SimpleAHSFeature.GUID, Intl.intl("<none>")))).attrFinish();
    public static final DisplayProp<Schedule> MULTIPLIER = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AHSPoint.MULTIPLIER", Schedule.class, Schedule.newConstant(new UnitDouble(1.0, Unit.ONE)), Intl.intl("Multiplier"), Intl.intl("Multiplier applied to the AHS flow rate.")).attrFormatValue(sch -> sch.format(10))).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().schedule(10)).attrFinish();
    public static final DisplayProp<Floor> LEVEL = PROP_TYPES.storeAsReadOnly(VentusData.LEVEL).attrGetter(AHSPoint::getLevel, ROOM).attrFinish();
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public AHSPoint(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        if (this.d_properties.isDefined(ROOM)) {
            this.d_transientProps.setIfNotDefault(ROOM, this.d_properties.get(ROOM));
            this.d_properties.remove(ROOM);
        }
        if (VentusOIS.isPrior(is, VentusIO.Version.VER_215)) {
            this.d_properties.setIfNotDefault(STORED_VISIBILITY, this.d_properties.get(VISIBILITY));
            this.d_properties.remove(VISIBILITY);
        }
    }

    public PropertyDefs<AHSPoint> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public AHSPoint clone() {
        return (AHSPoint)super.clone();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (VentusOIS.isPrior(ois, VentusIO.Version.VER_215)) {
            this.set(ROOM, (ISchematicRoom)ois.readObject());
        } else {
            super.readTopology(ois);
        }
    }

    public Floor getLevel() {
        ISchematicRoom room = this.get(ROOM);
        return room != null ? room.getLevel() : null;
    }

    public boolean isEnabled() {
        return this.d_properties.get(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.pauseUpdates();
        if (this.setToPropertySet(ENABLED, enabled)) {
            this.changedEvt(VentusData.ENABLED, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
        this.resumeUpdates();
    }

    public SimpleAHS getAHS() {
        return this.get(AHS);
    }

    public void setAHS(SimpleAHS ahs) {
        this.set(AHS, ahs);
    }

    public Set<Tag> getTags() {
        return this.get(TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.set(TAGS, tags);
    }

    public boolean getInvalid() {
        return this.get(ROOM) == null;
    }

    @Override
    public boolean isVisible() {
        return this.get(STORED_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.get(ROOM) != null ? Collections.singleton(this.get(ROOM)) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(ROOM) == null;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(ROOM)) {
            this.pauseUpdates();
            this.set(ROOM, null);
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        Point3d location = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((VentusData)this.getDomain(), new Point3d(location.x, location.y, location.z + 1.0E-6), new Point3d(location.x, location.y, location.z - 1.0E-6), 1, AHSPoint.getRoomFilter());
        if (room != null) {
            this.pauseUpdates();
            this.set(ROOM, room.room);
            this.set(ROOM_NORMAL, room.faceNormal);
            this.set(LOCATION, room.p);
            this.resumeUpdates();
        }
        return true;
    }

    public static BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getRoomFilter() {
        return (room, comp) -> room.getType() == ISchematicRoom.Type.ZONE && !(comp instanceof ISchematicRoom.IWallComponent);
    }

    public static boolean requiresLocation(IPropertySet props) {
        switch (props.get(TYPES).ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    private AHSPointGeom getPointGeom() {
        return new AHSPointGeom((VentusData)this.getDomain(), this.get(LOCATION));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof PointEntityGeom) {
            PointEntityGeom p = (PointEntityGeom)geom;
            this.set(LOCATION, p.location);
        }
        this.markTopoDirty();
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        switch (this.get(TYPES).ordinal()) {
            case 0: {
                gprops.add(new IPrimProps.Face(Color.RED, null, 0), 12);
                break;
            }
            case 1: {
                gprops.add(new IPrimProps.Face(Color.GREEN, null, 0), 12);
            }
        }
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0), 18);
        return new DisplayGeom(geom, gprops);
    }

    private static <ValT, PropT extends TypedProp<ValT>> BiConsumer<PropT, AHSPoint> getTopoFireEvents() {
        return (p, ahs) -> {
            ahs.pauseUpdates();
            ahs.changedEvt(p);
            ahs.markTopoDirty();
            ahs.resumeUpdates();
        };
    }

    public static enum Types implements ILabeled
    {
        SUPPLY(Intl.intl("Supply"), Intl.intl("Supply Zone Point")),
        RETURN(Intl.intl("Return"), Intl.intl("Return Zone Point"));

        public final String name;
        public final String desc;

        private Types(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    private static class AHSPointGeom
    extends PointEntityGeom {
        private static final long serialVersionUID = 1L;
        private final VentusData vd;

        public AHSPointGeom(VentusData vd, Point3d loc) {
            super(loc, 0.6);
            this.vd = vd;
        }

        @Override
        public AHSPointGeom newPoint(Point3d loc) {
            return new AHSPointGeom(this.vd, loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle());
        }

        public class Handle
        extends PointEntityGeom.Handle {
            public Handle() {
                super(AHSPointGeom.this);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new RoomSnapConstraint(AHSPointGeom.this.vd, null, AHSPoint.getRoomFilter());
            }
        }
    }
}

