/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import org.jscience.physics.units.SI;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.ahs.AHSFeature;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSFeature;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class AHSInputStreamHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVersion, int streamVersion, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        AHSRoot root = (AHSRoot)vd.getComponentData(AHSFeature.GUID);
        if (updateVersion == 204 && streamVersion < 204) {
            VentusOIS.findAndReplaceComposites(root, name -> new AHSRoot.AHSNode((String)name));
        }
        if (updateVersion == 205 && streamVersion < 205 && changes.changeObjs.containsKey(204)) {
            for (IMerlinObj obj : changes.changeObjs.get(204)) {
                if (!(obj instanceof AHSPoint)) continue;
                root.add(obj);
            }
        }
        if (updateVersion == 213 && streamVersion < 213) {
            SimpleAHSRoot ahsRoot = (SimpleAHSRoot)vd.getComponentData(SimpleAHSFeature.GUID);
            SimpleAHS defaultAHS = ahsRoot.getDefault();
            AHSRoot ahsPointRoot = (AHSRoot)vd.getComponentData(AHSFeature.GUID);
            for (AHSPoint point : ahsPointRoot.flatten(AHSPoint.class)) {
                point.setAHS(defaultAHS);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyAlwaysPostUpdates(VentusOIS.DecisionMaker responseHandler, WarningReport warns, VentusData vd, int streamVersion) {
        SimpleAHSRoot ahsRoot = (SimpleAHSRoot)vd.getComponentData(SimpleAHSFeature.GUID);
        UnitDouble zero = new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND));
        ahsRoot.flatten(SimpleAHS.class).stream().filter(ahs -> zero.lt(ahs.get(SimpleAHS.MINIMUM_OA_FLOW), 0.0)).forEach(ahs -> warns.addWarning(new Warning(String.format(Intl.intl("Unsupported AHS Parameter Min OA Flow: %s"), guiUtil.escapeHTML(ahs.getName())), Intl.intl("Parameter ignored, AHS intake is 100% OA."))));
        return false;
    }
}

