/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.util.ArrayList;
import java.util.function.UnaryOperator;
import org.jscience.physics.units.Unit;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.data.value.APiecewiseFunction1d;

public class CubicSplineFunction
extends APiecewiseFunction1d {
    private final ArrayList<Double> a = new ArrayList();
    private final ArrayList<Double> b = new ArrayList();
    private final ArrayList<Double> c = new ArrayList();
    private final ArrayList<Double> d = new ArrayList();
    private final ArrayList<Double> d_xs = new ArrayList();
    private final ArrayList<Double> d_ys = new ArrayList();
    private final APiecewiseFunction1d.Entry[] d_input;
    private final APiecewiseFunction1d.Entry[] d_output;

    public CubicSplineFunction(APiecewiseFunction1d.Entry ... input) {
        int i;
        this.d_input = input;
        int n = this.d_input.length;
        for (APiecewiseFunction1d.Entry entry : input) {
            UnitDouble x = entry.x;
            UnitDouble y = entry.y;
            if (x == null || y == null) continue;
            this.d_xs.add(x.getValue(x.getUnit()));
            this.d_ys.add(y.getValue(y.getUnit()));
        }
        for (int i2 = 0; i2 < n; ++i2) {
            this.a.add(this.d_ys.get(i2));
        }
        ArrayList<Double> h = this.diff(this.d_xs);
        Matrix A = this.calA(h, n);
        Matrix B = this.calB(this.d_ys, h, n);
        Matrix A1 = A.inv();
        Matrix m = A1.mtimes(B);
        for (i = 0; i < n - 1; ++i) {
            this.c.add(m.getAsDouble(i, 0L) / 2.0);
        }
        for (i = 0; i < n - 1; ++i) {
            this.b.add((this.d_ys.get(i + 1) - this.d_ys.get(i)) / h.get(i) - h.get(i) / 2.0 * m.getAsDouble(i, 0L) - h.get(i) / 6.0 * (m.getAsDouble(i + 1, 0L) - m.getAsDouble(i, 0L)));
            this.d.add((m.getAsDouble(i + 1, 0L) - m.getAsDouble(i, 0L)) / (6.0 * h.get(i)));
        }
        this.d_output = this.getInput().length < 1 ? new APiecewiseFunction1d.Entry[0] : this.generateOutputPoints(500);
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Intl.intl("Cubic Spline Function");
    }

    private ArrayList<Double> diff(ArrayList<Double> x) {
        ArrayList<Double> h = new ArrayList<Double>();
        for (int i = 0; i < x.size() - 1; ++i) {
            h.add(x.get(i + 1) - x.get(i));
        }
        return h;
    }

    private Matrix calA(ArrayList<Double> h, int n) {
        DenseDoubleMatrix2D A = DenseMatrix.Factory.zeros((long)n, (long)n);
        A.setAsDouble(1.0, 0L, 0L);
        A.setAsDouble(1.0, n - 1, n - 1);
        for (int i = 1; i < n - 1; ++i) {
            A.setAsDouble(2.0 * (h.get(i - 1) + h.get(i)), i, i);
            A.setAsDouble(h.get(i - 1), i, i - 1);
            A.setAsDouble(h.get(i), i, i + 1);
        }
        return A;
    }

    private Matrix calB(ArrayList<Double> y, ArrayList<Double> h, int n) {
        DenseDoubleMatrix2D B = DenseMatrix.Factory.zeros((long)n, 1L);
        for (int i = 1; i < n - 1; ++i) {
            double x = 6.0 * ((y.get(i + 1) - y.get(i)) / h.get(i) - (y.get(i) - y.get(i - 1)) / h.get(i - 1));
            B.setAsDouble(x, i, 0L);
        }
        return B;
    }

    @Override
    public double calculateYValue(double x) {
        int index = 0;
        for (int i = 0; i < this.d_xs.size() - 1; ++i) {
            if (!(this.d_xs.get(i) <= x) || !(x <= this.d_xs.get(i + 1))) continue;
            index = i;
        }
        return this.a.get(index) + this.b.get(index) * (x - this.d_xs.get(index)) + this.c.get(index) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index)) + this.d.get(index) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index));
    }

    @Override
    public APiecewiseFunction1d.Entry[] getInput() {
        return this.d_input;
    }

    @Override
    public APiecewiseFunction1d.Entry[] getOutput() {
        return this.d_output;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CubicSplineFunction && super.equals(obj);
    }
}

