/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.scripting;

import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.geom.GeomUtil;

public class RoomLocationGeometry
extends GeomUtil.ACircleGeometry {
    private static final long serialVersionUID = -5574029433922814496L;

    public RoomLocationGeometry(ISchematicRoom room, Vector3d normal, Point3d location, double arriveRadius) {
        super(room, normal, location, arriveRadius, true, new IGeom[0]);
    }

    @Override
    protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double newRadius) {
        if (find == null) {
            return new RoomLocationGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc, newRadius);
        }
        return new RoomLocationGeometry(find.room, find.faceNormal, newLoc, newRadius);
    }

    @Override
    public void generateManipHandles(Consumer<? super IHandle> handles) {
        handles.accept(new GeomUtil.RadiusHandle(this));
        handles.accept(new GeomUtil.LocationHandle(this));
    }

    @Override
    public GeomUtil.ACircleGeometry getConstructedTransform(ISchematicRoom room, Vector3d normal, Point3d location, double radius) {
        return new RoomLocationGeometry(room, normal, location, radius);
    }
}

