/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.camera;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;

public interface IViewObj
extends IMutableGeomSrc {
    public CameraRecord getCameraState();

    public void setCameraState(CameraRecord var1);

    @Override
    default public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof Point)) {
            return;
        }
        Point p = (Point)geom;
        CameraRecord cr = this.getCameraState();
        if (p.loc.equals(cr.loc)) {
            return;
        }
        Vector3d oldRefDir = Util3D.vector(cr.loc, cr.ref);
        Point3d newRef = Util3D.add(p.loc, (Tuple3d)oldRefDir);
        cr = new CameraRecord(p.loc, newRef, cr.up, cr.zoom, cr.zoomLoc, cr.near, cr.far, cr.frustum);
        this.setCameraState(cr);
    }

    @Override
    default public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(new Point(this.getCameraState().loc));
    }
}

