/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.units.UnitDouble;
import ventus.actions.InfernoGeomBuilder;
import ventus.geom.Geometry;

public class SimParams
implements Serializable {
    static final long serialVersionUID = 1L;
    public boolean runTimeMaxFlag = true;
    public UnitDouble runTimeMax = new UnitDouble(3600.0, SI.SECOND);
    public boolean showVis = false;
    public NavMeshRefinement navmeshRefinement = NavMeshRefinement.NONE;
    public UnitDouble maxEdgeLength = new UnitDouble(2.5, SI.METER);
    public double minAngle = 0.0;
    public UnitDouble maxTriangleArea = new UnitDouble(2.0, SI.METER.pow(2));
    public UnitDouble dtSim = new UnitDouble(0.025, SI.SECOND);
    public UnitDouble dtVis = new UnitDouble(0.25, SI.SECOND);
    public UnitDouble dtStatus = new UnitDouble(0.5, SI.SECOND);
    public UnitDouble dtCSV = new UnitDouble(1.0, SI.SECOND);
    @Deprecated
    public UnitDouble dtSnapshot = new UnitDouble(120.0, SI.SECOND);
    public boolean printPerformance = false;
    public double edgeError = 0.1;
    public double faceError = 0.1;

    public void reset() {
        this.restoreFrom(new SimParams());
    }

    public void restoreFrom(SimParams sp) {
        Field[] fields;
        for (Field f : fields = this.getClass().getFields()) {
            try {
                if (f.get(sp) == null) continue;
                f.set(this, f.get(sp));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object obj) {
        Field[] fields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimParams)) {
            return false;
        }
        SimParams sp = (SimParams)obj;
        for (Field f : fields = this.getClass().getFields()) {
            if (f.getAnnotation(Deprecated.class) != null) continue;
            try {
                Object val1 = f.get(this);
                Object val2 = f.get(sp);
                if (Objects.equals(val1, val2)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.navmeshRefinement == null) {
            NavMeshRefinement navMeshRefinement = this.navmeshRefinement = this.maxTriangleArea != null ? NavMeshRefinement.TRIANGLE_AREA : NavMeshRefinement.NONE;
        }
        if (this.maxTriangleArea == null) {
            this.maxTriangleArea = new SimParams().maxTriangleArea;
        }
        if (this.faceError == 0.0) {
            this.faceError = 0.1;
        }
        if (this.edgeError == 0.0) {
            this.edgeError = 0.1;
        }
    }

    public Face.RefinementOptions getFaceRefinementOptions() {
        switch (this.navmeshRefinement.ordinal()) {
            case 1: {
                return new Face.RefinementOptions(this.minAngle);
            }
            case 2: {
                return new Face.RefinementOptions(this.maxTriangleArea.get(Geometry.AREA_UNIT), 0);
            }
        }
        return Face.NO_REFINEMENT;
    }

    public InfernoGeomBuilder.Param getMeshBuilderParams() {
        Face.RefinementOptions refOptions = this.getFaceRefinementOptions();
        return new InfernoGeomBuilder.Param(switch (this.navmeshRefinement.ordinal()) {
            case 1 -> this.maxEdgeLength;
            case 2 -> {
                double area = this.maxTriangleArea.get(Geometry.AREA_UNIT);
                double len = Math.sqrt(area) * 2.0 / 3.0 * Math.pow(3.0, 0.75);
                yield new UnitDouble(len, Geometry.LENGTH_UNIT);
            }
            default -> new UnitDouble(Double.MAX_VALUE, SI.METER);
        }, refOptions);
    }

    public static enum NavMeshRefinement {
        NONE,
        EDGE_LENGTH,
        TRIANGLE_AREA;

    }
}

