/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.comps.IScenarioParameterSrc;
import ventus.io.contamx.PrjData;

public class ScenarioData {
    final List<Map<TypedProp, Object>> scenarios = new ArrayList<Map<TypedProp, Object>>();
    final Set<TypedProp> multiValParams = new HashSet<TypedProp>();

    public ScenarioData(VentusData vd, Collection<IScenarioParameterSrc> appData) {
        LinkedHashMap<TypedProp, List<Object>> params = new LinkedHashMap<TypedProp, List<Object>>();
        appData.forEach(comp -> {
            for (TypedProp prop : comp.getParameters()) {
                List vals = comp.getParameterValues(vd, prop);
                params.put(prop, vals);
                if (vals.size() <= 1) continue;
                this.multiValParams.add(prop);
            }
        });
        this.scenarios.addAll(ScenarioData.getScenarios(params));
    }

    public List<Map<TypedProp, Object>> getAllScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public int getScenarioCount() {
        return this.scenarios.size();
    }

    public Map<TypedProp, Object> getScenario(int index) {
        return this.scenarios.get(index);
    }

    public Set<TypedProp> getMultiValueParams() {
        return Collections.unmodifiableSet(this.multiValParams);
    }

    private static List<Map<TypedProp, Object>> getScenarios(Map<TypedProp, List<Object>> allParams) {
        List<Map<TypedProp, Object>> current = Collections.emptyList();
        for (Map.Entry<TypedProp, List<Object>> entry : allParams.entrySet()) {
            ArrayList<Map<TypedProp, Object>> allNextGen = new ArrayList<Map<TypedProp, Object>>();
            for (Object propVal : entry.getValue()) {
                List<Map<TypedProp, Object>> valNextGen = ScenarioData.createCopy(current);
                if (valNextGen.isEmpty()) {
                    valNextGen.add(new LinkedHashMap());
                }
                for (Map<TypedProp, Object> mappings : valNextGen) {
                    mappings.put(entry.getKey(), propVal);
                }
                allNextGen.addAll(valNextGen);
            }
            current = allNextGen;
        }
        return current;
    }

    private static List<Map<TypedProp, Object>> createCopy(List<Map<TypedProp, Object>> originalList) {
        ArrayList<Map<TypedProp, Object>> copyOfList = new ArrayList<Map<TypedProp, Object>>(originalList.size());
        for (Map<TypedProp, Object> originalMap : originalList) {
            copyOfList.add(new LinkedHashMap<TypedProp, Object>(originalMap));
        }
        return copyOfList;
    }

    public String getNameFromMapping(VentusData vd, Map<TypedProp, Object> mapping) {
        ArrayList<String> parts = new ArrayList<String>();
        for (TypedProp prop : this.multiValParams) {
            String part;
            if (!(mapping.get(prop) instanceof UnitDouble)) continue;
            UnitDouble val = (UnitDouble)mapping.get(prop);
            if (val.getUnit().isCompatible(SI.RADIAN)) {
                part = Global.format(val, vd.getUnitSystem().getAngle(), 4);
                parts.add(part.replace(" \u00b0", "deg"));
                continue;
            }
            if (val.getUnit().isCompatible(SI.KELVIN)) {
                part = Global.format(val, vd.getUnitSystem().getTemperature(), 4);
                parts.add(part.replace(" \u00b0", ""));
                continue;
            }
            parts.add(mapping.get(prop).toString());
        }
        String slug = String.join((CharSequence)"-", parts);
        if (!slug.isEmpty()) {
            return "-" + slug;
        }
        return "";
    }

    public static PrjData getScenarioPrjData(Collection<IPrjDataWriter> writers, VentusApp app, VentusData md, Map<TypedProp, Object> scenario) {
        PrjData prjData = new PrjData();
        writers.stream().sorted(Comparator.comparing(IPrjDataWriter::getOrder)).forEach(comp -> comp.addPrjData(app, md, scenario, prjData));
        return prjData;
    }
}

