/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.data.AMerlinObj;
import ventus.data.IMerlinObj;
import ventus.data.INamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.PropertyDefs;
import ventus.util.Dependencies;

public class Proxy<T extends INamedMerlinObj>
extends AMerlinObj
implements INamedMerlinObj,
IDirectDependent<VentusData> {
    static final long serialVersionUID = -3893471045648835311L;
    public static final PropertyDefs<Proxy> PROP_TYPES = PropertyDefs.defsRoot(Proxy.class, PropertyDefs.legacy(null));
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrGetter(Proxy::isEnabled, Stream.empty()).attrSetter((proxy, val) -> proxy.setEnabled((boolean)val), (proxy, val) -> proxy.setEnabled((boolean)val, false)).attrSurrogateEquals(null).attrFinish();
    private final T d_obj;
    private boolean d_enabled = true;
    private static final DepCallback<VentusData, Proxy, IMerlinObj, IMerlinObj> OBJ_CALLBACK = Dependencies.newDependencyNoReplace(IMerlinObj.class);

    public Proxy(T obj) {
        this.d_obj = obj;
    }

    @Override
    public String getName() {
        return this.d_obj.getName();
    }

    @Override
    public void setName(String name) {
        this.d_obj.setName(name);
    }

    @Override
    public boolean isComposite() {
        return this.d_obj.isComposite();
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_obj.getChildren();
    }

    public PropertyDefs<Proxy> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        return this.d_obj.getSupportedProps(mode);
    }

    public <U> void set(TypedProp<U> prop, U val) {
        this.pauseUpdates();
        PropertyDefs<Proxy> props = this.getPropertyDefs();
        if (props.has(prop)) {
            props.setValue(this, prop, val);
        }
        this.d_obj.set(prop, val);
        this.changedEvt(prop);
        this.resumeUpdates();
    }

    public <U> PropValue<U> getWithDetails(TypedProp<U> prop) {
        PropertyDefs<Proxy> props = this.getPropertyDefs();
        if (props.has(prop)) {
            return props.getValue(this, prop);
        }
        return this.d_obj.getWithDetails(prop);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, true);
    }

    public void setEnabled(boolean enabled, boolean setToWrapped) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.pauseUpdates();
            this.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, EventChannel.EVT_GENERAL, ENABLED);
            if (setToWrapped) {
                this.d_obj.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, EventChannel.EVT_GENERAL);
            }
            this.resumeUpdates();
        }
    }

    public T getObj() {
        return this.d_obj;
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        this.updateDomainProxy(domain);
        super.setDomain(domain, parent);
    }

    @Override
    public void setDomain(VentusData owner) {
        this.updateDomainProxy(owner);
        super.setDomain(owner);
    }

    private void updateDomainProxy(VentusData domain) {
        VentusData curDomain;
        if (domain != null) {
            domain.proxies.add(this);
        }
        if ((curDomain = (VentusData)this.getDomain()) != null) {
            curDomain.proxies.remove(this);
        }
    }

    public static Collection<Object> getProxyParents(IMerlinObj obj, boolean includeDisabledProxies) {
        Set<Proxy> allProxies;
        VentusData md = (VentusData)obj.getDomain();
        if (md == null) {
            return null;
        }
        Set<Proxy> set = allProxies = md.proxies != null ? md.proxies.getProxies(obj) : Collections.emptySet();
        if (allProxies.isEmpty()) {
            return null;
        }
        LinkedIdentityHashSet<Object> allParents = new LinkedIdentityHashSet<Object>();
        for (Proxy p : allProxies) {
            Object parent;
            if (!includeDisabledProxies && !p.isEnabled() || (parent = ((VentusData)obj.getDomain()).hierarchy.getParent(p)) == null) continue;
            allParents.add(parent);
        }
        return allParents;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(this, this.d_obj, OBJ_CALLBACK);
    }

    @Override
    public boolean isSetNameSupported() {
        return this.d_obj.isSetNameSupported();
    }
}

