/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.data.IMerlinObj;

public class CompositePropertyUtil {
    public static Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode, Collection<? extends IMerlinObj> objs) {
        return switch (mode) {
            case IMerlinObj.SupportMode.INTERSECTION -> {
                if (objs.isEmpty()) {
                    yield Collections.emptySet();
                }
                LinkedHashSet groupTypes = new LinkedHashSet();
                for (IMerlinObj var4_6 : theUtil.filter(objs, IMerlinObj.class, IMerlinObj::isComposite)) {
                    groupTypes.addAll(var4_6.getSupportedProps(IMerlinObj.SupportMode.LOCAL_ONLY));
                }
                LinkedHashSet types = null;
                for (IMerlinObj var5_9 : objs) {
                    if (var5_9.isComposite() && var5_9.getChildren().isEmpty()) continue;
                    if (types == null) {
                        types = new LinkedHashSet(var5_9.getSupportedProps(mode));
                    } else {
                        types.retainAll(var5_9.getSupportedProps(mode));
                    }
                    if (!types.isEmpty()) continue;
                    yield groupTypes;
                }
                if (types == null) {
                    yield groupTypes;
                }
                types.addAll(groupTypes);
                yield types;
            }
            default -> {
                LinkedHashSet types = new LinkedHashSet();
                for (IMerlinObj var4_8 : objs) {
                    types.addAll(var4_8.getSupportedProps(mode));
                }
                yield types;
            }
        };
    }

    public static <T> void setValue(TypedProp<T> property, T value, Collection<? extends IMerlinObj> objs) {
        for (IMerlinObj iMerlinObj : objs) {
            iMerlinObj.set(property, value);
        }
    }

    public static <T> PropValue<T> getValue(TypedProp<T> property, Collection<? extends IMerlinObj> objs) {
        if (objs.isEmpty()) {
            return PropValue.unsupported();
        }
        PropValue val = PropValue.unsupported();
        for (IMerlinObj iMerlinObj : objs) {
            PropValue<T> val2 = iMerlinObj.getWithDetails(property);
            if (val2.isNonUniform()) {
                return PropValue.nonUniform();
            }
            if (val2.isUnsupported()) continue;
            if (val.isUnsupported()) {
                val = val2;
                continue;
            }
            if (Objects.equals(val.get(), val2.get())) continue;
            return PropValue.nonUniform();
        }
        return val;
    }
}

