/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.data.Composite;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.Proxy;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.props.PropertyDefs;
import ventus.geom.IMerlinGeomSrc;
import ventus.util.MerlinUtil;

public abstract class AMerlinObj
extends ADomainObject<VentusData>
implements IMerlinObj,
Serializable {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER = Logger.getLogger(AMerlinObj.class.getSimpleName());

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return Collections.emptyList();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public AMerlinObj clone() {
        AMerlinObj clone = (AMerlinObj)super.clone();
        this.getPropertyDefs().cloneValues(this, clone);
        return clone;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        if (this instanceof ISchematicObj) {
            domain.topology.remove((ISchematicObj)((Object)this));
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.remove((IMerlinGeomSrc)((Object)this));
        }
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(null, this);
        }
        this.removedEvt((Object)this);
        ((VentusData)this.getDomain()).hierarchy.removeFromHierarchy(this);
    }

    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        domain.hierarchy.addToHierarchy(parent, this);
        this.addedEvt((Object)this);
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(domain, this);
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.add((IMerlinGeomSrc)((Object)this));
        }
        if (this instanceof ISchematicObj) {
            domain.topology.add((ISchematicObj)((Object)this));
        }
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((VentusData)this.getDomain(), parent);
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((VentusData)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    @Override
    @Deprecated
    public void setDomain(VentusData owner) {
        super.setDomain(owner);
    }

    public abstract PropertyDefs<? extends IMerlinObj> getPropertyDefs();

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        if (!this.isComposite()) {
            return this.getPropertyDefs().props();
        }
        switch (mode) {
            case LOCAL_ONLY: {
                return this.getPropertyDefs().props();
            }
            case UNION: 
            case INTERSECTION: {
                Set<TypedProp<?>> inherited = CompositePropertyUtil.getSupportedProps(mode, this.getChildren());
                SequencedSet<TypedProp<?>> local = this.getPropertyDefs().props();
                if (!local.isEmpty() && !inherited.isEmpty()) {
                    LinkedHashSet result = new LinkedHashSet(inherited);
                    result.addAll(local);
                    return result;
                }
                if (!local.isEmpty()) {
                    return local;
                }
                if (!inherited.isEmpty()) {
                    return inherited;
                }
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public <T> void set(TypedProp<T> prop, T val) {
        PropertyDefs<? extends IMerlinObj> props = this.getPropertyDefs();
        if (!this.isComposite() || props.has(prop)) {
            props.setValue(this, prop, val);
            return;
        }
        this.pauseUpdates();
        CompositePropertyUtil.setValue(prop, val, theUtil.filter(this.getChildren(), IMerlinObj.class));
        this.changedEvt(prop);
        this.resumeUpdates();
    }

    protected final <T> boolean setToPropertySet(TypedProp<T> prop, T value) {
        PropertyDefs<? extends IMerlinObj> props = this.getPropertyDefs();
        return props.compareAndSetDirect(this, prop, value);
    }

    @Override
    public <T> PropValue<T> getWithDetails(TypedProp<T> prop) {
        PropertyDefs<? extends IMerlinObj> props = this.getPropertyDefs();
        if (!this.isComposite() || props.has(prop)) {
            return props.getValue(this, prop);
        }
        return CompositePropertyUtil.getValue(prop, this.getChildren());
    }

    @Override
    public AMerlinObj getRestoreObj() {
        return this.getPropertyDefs().getRestoreObj(this, (AMerlinObj)super.clone());
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj == null) {
            return;
        }
        if (!this.getClass().equals(obj.getClass())) {
            LOGGER.log(Level.WARNING, () -> String.format("Restore failed. Trying to restore from the wrong type. Expected to restore from %s; found %s", obj.getClass().getSimpleName(), this.getClass().getSimpleName()));
            return;
        }
        AMerlinObj other = (AMerlinObj)obj;
        this.getPropertyDefs().restoreFrom(other, this);
    }

    @Override
    public Optional<UndoFramework.UndoOp> getUndoOpPropRestore(Collection<? extends TypedProp<?>> props) {
        if (this.getDomain() == null) {
            return Optional.of(UndoFramework.MINOR_EMPTY_OP);
        }
        return this.getPropertyDefs().getUndoOpPropRestore(this.getDomain(), this, props);
    }

    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (this == comparable) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        AMerlinObj other = (AMerlinObj)comparable;
        return this.getPropertyDefs().surrogateEquals(this, other, comparedSet);
    }

    public boolean surrogateEquals(Object comparable) {
        if (this == comparable) {
            return true;
        }
        if (!this.getClass().isInstance(comparable)) {
            return false;
        }
        AMerlinObj other = (AMerlinObj)comparable;
        return this.getPropertyDefs().surrogateEquals(this, other, null);
    }

    public void takeDepSnapshot(DepList<VentusData> deps) {
        this.getPropertyDefs().takeDepSnapshot(this, deps);
    }

    public void writeTopology(ObjectOutputStream oos) throws IOException {
        this.getPropertyDefs().delayWriteObj(oos, this);
        for (ISchematicObj child : theUtil.filter(this.getChildren(), ISchematicObj.class)) {
            child.writeTopology(oos);
        }
    }

    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.getPropertyDefs().delayReadObj(ois, this);
        for (ISchematicObj child : theUtil.filter(this.getChildren(), ISchematicObj.class)) {
            child.readTopology(ois);
        }
    }

    protected <T extends IMerlinObj> void addChild(T child) {
        child.setDomain((VentusData)this.getDomain(), this);
        this.changedEvt(VentusData.CHILD_ADDED);
    }

    protected <T extends IMerlinObj> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.addChild(child);
        }
        this.resumeUpdates();
    }

    protected <T extends IMerlinObj> void removeChild(T child) {
        child.setDomain(null, this);
        this.changedEvt(VentusData.CHILD_REMOVED);
    }

    protected <T extends IMerlinObj> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.removeChild(child);
        }
        this.resumeUpdates();
    }

    protected static boolean allChangesMatch(Object[] changeList, Predicate<Object> changeTest) {
        if (changeList.length == 0) {
            return false;
        }
        return Stream.of(changeList).allMatch(changeTest);
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.pauseUpdates();
        this.getPropertyDefs().changedEvt(this, changes);
        if (!AMerlinObj.allChangesMatch(changes, Filters.accept(VentusData.SELECTION_CHANGED))) {
            LinkedIdentityHashSet parents = new LinkedIdentityHashSet();
            parents.add(this.getParent());
            Collection<Object> proxyParents = Proxy.getProxyParents(this, true);
            if (proxyParents != null) {
                parents.addAll(proxyParents);
            }
            Predicate<Object> isVisibilityEvent = MerlinUtil::isVisibilityEvent;
            for (Object parent : parents) {
                if (!(parent instanceof Composite)) continue;
                if (AMerlinObj.allChangesMatch(changes, isVisibilityEvent)) {
                    ((Composite)parent).changedEvt(changes);
                } else {
                    ((Composite)parent).changedEvt(new Object[0]);
                }
                ((Composite)parent).markPropsCacheDirty();
            }
        }
        if (this.getDomain() != null) {
            if (this instanceof IMerlinGeomSrc && !AMerlinObj.allChangesMatch(changes, Filters.accept(VentusData.SELECTION_CHANGED, VentusData.CONNECTION).or(MerlinUtil::isVisibilityEvent))) {
                ((VentusData)this.getDomain()).geomLocation.update((IMerlinGeomSrc)((Object)this));
            }
            if (this instanceof ISchematicObj && theUtil.contains(VentusData.TOPOLOGY, changes)) {
                ((VentusData)this.getDomain()).topology.changed((ISchematicObj)((Object)this));
            }
        }
        boolean result = super.changedEvt(changes);
        this.resumeUpdates();
        return result;
    }
}

