/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.util.Arrays;
import java.util.Collection;
import ventus.actions.FloorSortActions;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;

public class NewCompUtil {
    public static void addSchematicComp(VentusData md, ISchematicComp ... comps) {
        NewCompUtil.addSchematicComp(md, false, comps);
    }

    public static void addSchematicComp(VentusData md, boolean doSelect, ISchematicComp ... comps) {
        NewCompUtil.addSchematicComps(md, doSelect, Arrays.asList(comps));
    }

    public static void addSchematicComps(VentusData md, boolean doSelect, Collection<? extends ISchematicComp> comps) {
        for (ISchematicComp iSchematicComp : comps) {
            Composite<?> node = FloorSortActions.chooseGroup(md, iSchematicComp);
            assert (node != null);
            Undo.insertUndoEntry_delete(md, node, iSchematicComp);
            node.add(iSchematicComp);
        }
        if (doSelect) {
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(comps);
        }
    }
}

