/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importgeom;

import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.material.MaterialCache;
import ventus.util.MerlinUtil;

public class ImportOptions
implements IPropertySet {
    public static final IPropertySet.Prop<File> FILE = new IPropertySet.Prop<Object>("ImportOptions.FILE", null);
    public static final IPropertySet.Prop<VentusData> MD = new IPropertySet.Prop<Object>("ImportOptions.MD", null);
    public static final IPropertySet.Prop<Boolean> NEW_MODEL = new IPropertySet.Prop<Boolean>("ImportOptions.NEW_MODEL", true);
    public static final IPropertySet.Prop<Supplier<MaterialCache>> MAT_CACHE = new IPropertySet.Prop<Supplier<MaterialCache>>("ImportOptions.MAT_CACHE", () -> null);
    private final IPropertySet d_props = new PropertySet();

    public ImportOptions(VentusData md) {
        this.d_props.set(MD, md);
        this.resetMaterialCache();
    }

    private void resetMaterialCache() {
        MaterialCache[] cache = new MaterialCache[]{null};
        this.d_props.set(MAT_CACHE, () -> {
            MaterialCache[] materialCacheArray = cache;
            synchronized (cache) {
                if (cache[0] == null) {
                    Predicate<Object> matFilter = this.d_props.get(NEW_MODEL) != false ? mat -> this.d_props.get(ImportOptions.MD).materials.isPermanent((Material)mat) : Filters.acceptAll();
                    Collection<Material> availableMats = MerlinUtil.flatten(this.d_props.get(ImportOptions.MD).materials.getChildren(), Material.class, matFilter);
                    cache[0] = new MaterialCache(availableMats);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return cache[0];
            }
        });
    }

    public void reset(File file) {
        this.d_props.set(FILE, file);
        this.resetMaterialCache();
    }

    public void cleanup() {
        this.d_props.remove(FILE);
        this.d_props.remove(MAT_CACHE);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (Objects.equals(this.d_props.get(prop), val)) {
            return;
        }
        this.d_props.set(prop, val);
        if (prop == NEW_MODEL) {
            this.resetMaterialCache();
        }
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        if (!this.isDefined(prop)) {
            return;
        }
        this.d_props.remove(prop);
        if (prop == NEW_MODEL) {
            this.resetMaterialCache();
        }
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.isDefined(prop);
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }
}

