/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.geomops;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.GeomComposite;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.SchematicModelGeom;
import ventus.data.schematics.geom.SchematicRoom;

public class CleanupRooms
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new CleanupRooms(), Intl.intl("Remove extra vertices...,-,Remove extra vertices on unused edges."));

    public CleanupRooms() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    protected Set<SchematicRoom> getValidRooms(VentusData md) {
        return theUtil.filter(md.selection.getDeepSelected(SchematicRoom.class), SchematicRoom::getModificationsAllowed);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(VentusApp.getApp().getData().selection.isExclusive(SchematicRoom.class, FloorComposite.class, GeomComposite.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        TaskProgress progress = new TaskProgress();
        LinkedIdentityHashMap newRoomGeom = new LinkedIdentityHashMap();
        Optional<Nullable<Integer>> removed = this.execLongReadTaskNoThrow(app, md, Intl.intl("Removing Extra Vertices"), progress, () -> {
            int vertsRemoved = 0;
            Set<SchematicRoom> rooms = this.getValidRooms(md);
            for (SchematicRoom room : rooms) {
                progress.check();
                Model model = room.getModel();
                Model newModel = room.cleanup(model);
                if (newModel == model) continue;
                if (newModel.getVerts().size() < model.getVerts().size()) {
                    vertsRemoved += model.getVerts().size() - newModel.getVerts().size();
                }
                newRoomGeom.put(room, newModel);
            }
            progress.check();
            return vertsRemoved;
        });
        if (removed.isEmpty()) {
            return;
        }
        if (!newRoomGeom.isEmpty()) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Remove Extra Vertices"));
                for (Map.Entry entry : newRoomGeom.entrySet()) {
                    SchematicRoom room = (SchematicRoom)entry.getKey();
                    Model newModel = (Model)entry.getValue();
                    Undo.insertUndoEntry_restore(md, room);
                    room.setGeom(new SchematicModelGeom(newModel));
                }
                Undo.end(md);
            }
        }
        md.uiLater(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), String.format(Intl.intl("Vertices removed: %d"), ((Nullable)removed.get()).val), Intl.intl("Removed Vertices"), 1));
    }
}

