/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.floorextract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TaskProgress;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CloseGapsAction;
import ventus.actions.SubtractAction;
import ventus.actions.Undo;
import ventus.actions.floorextract.ExtractFloor2DSel;
import ventus.builders.NewCompUtil;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.GeomUtil;
import ventus.geom.ModelConstrictor;

public class ExtractFloor2D
extends AMerlinOp {
    private final TaskProgress d_progress = new TaskProgress();
    private Point3d d_pickLoc = null;
    private final boolean d_searchHidden = false;
    private double d_closeGapSize = Util.inchesToMeters(1.0);

    public ExtractFloor2D(Point3d pickLoc, double closeGapSize) {
        this.d_pickLoc = pickLoc;
        this.d_closeGapSize = closeGapSize;
    }

    public TaskProgress getProgress() {
        return this.d_progress;
    }

    protected void checkCancelled() {
        this.d_progress.check();
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        if (this.d_pickLoc == null) {
            return;
        }
        this.d_progress.reset();
        Optional<Nullable<SchematicRoom>> optRoom = this.execLongReadTaskNoThrow(app, md, Intl.intl("Extracting Room"), this.d_progress, () -> this.extractRoom(md));
        if (optRoom.isEmpty() || optRoom.get().val == null) {
            return;
        }
        SchematicRoom room = (SchematicRoom)optRoom.get().val;
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Extract Room"));
            SchematicRoom newRoom = room;
            md.roomNameGen.nextName();
            ArrayList<SchematicRoom> toClean = new ArrayList<SchematicRoom>();
            toClean.add(newRoom);
            ArrayList toSelect = new ArrayList();
            BiConsumer<SchematicRoom, SchematicRoom> selectFunc = (parentRoom, childRoom) -> {
                if (parentRoom.equals(newRoom)) {
                    toSelect.add(childRoom);
                }
            };
            NewCompUtil.addSchematicComp(md, false, newRoom);
            SubtractAction.subtract(app, md, 0, toClean::add, selectFunc, newRoom);
            Undo.insertUndoEntry_restoreSelection(md);
            if (newRoom.getDomain() == md) {
                md.selection.set(room);
            } else {
                md.selection.set(toSelect);
            }
            SchematicRoom.cleanup(md, toClean);
            Undo.end(md);
        }
    }

    private SchematicRoom extractRoom(VentusData md) {
        Face extractedFace = this.extract(md);
        if (extractedFace == null) {
            return null;
        }
        Model model = new Model();
        model.addFace(extractedFace, 0);
        int[] boundGroup = new int[]{1};
        int[] nonBoundGroup = new int[]{0};
        for (Edge edge : model.getEdges()) {
            edge.groups = ExtractFloor2D.isBoundaryEdge(edge) ? boundGroup : nonBoundGroup;
        }
        for (Vertex vert : model.getVerts()) {
            vert.groups = nonBoundGroup;
        }
        SchematicRoom room = new SchematicRoom(md.roomNameGen.getCurrentName(), model);
        return room;
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(0) && !edge.faces.isEmpty() || !edge.partOfGroup(0) && edge.faces.size() == 1;
    }

    private Face closeGaps(Model model) {
        model = CloseGapsAction.closeGaps(model, this.d_closeGapSize, new ModelConstrictor.IEdgeClassifier(this){

            @Override
            public boolean isBoundary(Edge edge) {
                return edge.partOfGroup(1);
            }

            @Override
            public boolean isInternal(Edge edge) {
                return false;
            }

            @Override
            public boolean canSplit(Edge edge) {
                return true;
            }

            @Override
            public boolean isSplitTarget(Edge edge) {
                return this.isBoundary(edge);
            }
        });
        return model.findFace(this.d_pickLoc);
    }

    private Face extract(VentusData md) {
        AABox globalBB = new AABox();
        for (ImportedGeom geom : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
            this.checkCancelled();
            if (geom.getGeom().getNumPrims(2) <= 0 || !md.isVisible(geom)) continue;
            globalBB.add(geom.getBounds());
        }
        int outerid = 0;
        Model model = ExtractFloor2DSel.getStartModel(globalBB, this.d_pickLoc.z, outerid);
        if (model == null) {
            return null;
        }
        Face testFace = model.findFace(this.d_pickLoc);
        if (testFace == null) {
            return null;
        }
        AABox faceBounds = testFace.getBounds();
        globalBB = new AABox(faceBounds.getMinX(), faceBounds.getMinY(), globalBB.getMinZ(), faceBounds.getMaxX(), faceBounds.getMaxY(), globalBB.getMaxZ());
        Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, this.d_pickLoc.z, 0.0, 0.0, 0.0, 1.0);
        int groupid = 1;
        IdentityHashSet<ImportedGeom> closedGeoms = new IdentityHashSet<ImportedGeom>();
        int maxit = 100;
        for (int it = 1; it <= maxit; ++it) {
            Collection<ImportedGeom> searchSet = this.getSearchSet(md, globalBB, it, maxit, closedGeoms);
            Collection<ImportedGeom> sortedGeoms = this.sortGeoms(md, searchSet);
            Iterator<ImportedGeom> lineIt = sortedGeoms.iterator();
            while (lineIt.hasNext()) {
                this.checkCancelled();
                ImportedGeom startGeom = lineIt.next();
                if (!closedGeoms.add(startGeom)) continue;
                List<LineSeg> projCurves = ExtractFloor2D.getProjCurves(md, startGeom, projectionXform);
                for (LineSeg ls : projCurves) {
                    GeomUtil.addCurveToModel(ls, model, groupid, 0.0);
                }
                Face face = model.findFace(this.d_pickLoc);
                if (!ExtractFloor2D.isOuterFace(face, outerid)) {
                    return this.completeFace(md, model, face, groupid, outerid, projectionXform, globalBB, closedGeoms);
                }
                if (model.getFaces().size() <= 1) continue;
                for (Face otherFace : new ArrayList<Face>(model.getFaces())) {
                    if (otherFace == face) continue;
                    model.deleteFace(otherFace, true, true);
                }
            }
        }
        return this.closeGaps(model);
    }

    public static boolean isFiltered(VentusData md, ImportedGeom geom) {
        if (geom.isIgnoredInModelGeneration()) {
            return true;
        }
        AABox bounds = null;
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            if (!floor.isVisible()) continue;
            ConvexHull ch = md.floors.getClippingRegion(floor);
            if (bounds == null) {
                bounds = geom.getBounds().scale(1.000001);
            }
            if (!ch.containsAtLeastPart(bounds)) continue;
            return false;
        }
        return true;
    }

    public static Collection<ImportedGeom> findSceneGeom(final VentusData md, ITest<AABox> test, boolean searchHidden) {
        Predicate<ImportedGeom> filter = new Predicate<ImportedGeom>(){

            @Override
            public boolean test(ImportedGeom o) {
                return !ExtractFloor2D.isFiltered(md, o);
            }
        };
        CollResult result = new CollResult(ImportedGeom.class, filter);
        md.geomLocation.getLocator().find(test, result, searchHidden ? 1 : 0);
        return new ArrayList<ImportedGeom>(result.coll);
    }

    private static boolean isOuterFace(Face face, int outerid) {
        FaceLoop outerLoop = face.outerLoop();
        return !outerLoop.edges.isEmpty() && outerLoop.edges.get((int)0).edge.partOfGroup(outerid);
    }

    private static void setZExtents(AABox bb, double minz, double maxz) {
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        min.z = minz;
        max.z = maxz;
        bb.set(min, max);
    }

    private Face completeFace(VentusData md, Model model, Face inputFace, int testID, int globalFaceID, Matrix4d projXform, AABox globalBB, Set<ImportedGeom> closedGeoms) {
        AABox bb = new AABox(inputFace.getBounds());
        ExtractFloor2D.setZExtents(bb, globalBB.getMinZ(), globalBB.getMaxZ());
        AABoxTest test = new AABoxTest(bb, 1.0E-6);
        Collection<ImportedGeom> igeoms = ExtractFloor2D.findSceneGeom(md, test, false);
        for (ImportedGeom geom : igeoms) {
            if (closedGeoms.contains(geom)) continue;
            for (LineSeg ls : ExtractFloor2D.getProjCurves(md, geom, projXform)) {
                GeomUtil.addCurveToModel(ls, model, testID, 0.0);
            }
            if (model.getFaces().size() <= 1) continue;
            Face face = model.findFace(this.d_pickLoc);
            for (Face otherFace : new ArrayList<Face>(model.getFaces())) {
                if (otherFace == face) continue;
                model.deleteFace(otherFace, true, true);
            }
        }
        return this.closeGaps(model);
    }

    private static List<LineSeg> getProjCurves(VentusData md, ImportedGeom geom, Matrix4d projXform) {
        Collection<LineSeg> curves = ExtractFloor2D.getCurves(md, geom);
        ArrayList<LineSeg> projCurves = new ArrayList<LineSeg>(curves.size());
        TransformInfo ti = new TransformInfo(projXform);
        for (LineSeg curve : curves) {
            LineSeg projCurve = curve.transform(ti, 0);
            projCurves.add(projCurve);
        }
        return projCurves;
    }

    private Collection<ImportedGeom> getSearchSet(final VentusData md, AABox globalBB, int iteration, int maxIterations, final Set<ImportedGeom> closed) {
        double mult = (double)iteration / (double)maxIterations;
        double dx = globalBB.getWidth() * mult;
        double dy = globalBB.getDepth() * mult;
        double dist = Math.max(dx, dy);
        AABox searchBox = new AABox(this.d_pickLoc.x - dist, this.d_pickLoc.y - dist, globalBB.getMinZ(), this.d_pickLoc.x + dist, this.d_pickLoc.y + dist, globalBB.getMaxZ());
        AABoxTest test = new AABoxTest(searchBox, 1.0E-6);
        final ArrayList<ImportedGeom> geoms = new ArrayList<ImportedGeom>();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (obj instanceof ImportedGeom && !closed.contains(obj) && !ExtractFloor2D.isFiltered(md, (ImportedGeom)obj)) {
                    geoms.add((ImportedGeom)obj);
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, 0);
        if (geoms.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return geoms;
    }

    private static Collection<LineSeg> getCurves(VentusData md, ImportedGeom obj) {
        IGeom geom = obj.getGeom().flatten().getLocalGeom();
        return thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(md.simParams.edgeError, geom);
    }

    private Collection<ImportedGeom> sortGeoms(VentusData md, Collection<ImportedGeom> geoms) {
        TreeMap<Double, ImportedGeom> map = new TreeMap<Double, ImportedGeom>();
        Point3d linep = this.d_pickLoc;
        Vector3d linedir = new Vector3d(0.0, 0.0, 1.0);
        Point3d closestOnLine1 = new Point3d();
        Point3d closestOnLine2 = new Point3d();
        for (ImportedGeom obj : geoms) {
            double closestDist = Double.MAX_VALUE;
            for (LineSeg curve : ExtractFloor2D.getCurves(md, obj)) {
                double dist;
                this.checkCancelled();
                if (!Inter3D.lineLineSegProximity(closestOnLine1, closestOnLine2, linep, linedir, curve.evaluate(0.0), curve.evaluate(1.0)) || !((dist = closestOnLine1.distanceSquared(closestOnLine2)) < closestDist)) continue;
                closestDist = dist;
            }
            if (closestDist == Double.MAX_VALUE) continue;
            map.put(closestDist, obj);
        }
        return map.values();
    }
}

