/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Warning;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.actions.SubtractAction;
import ventus.actions.TransformAction;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.builders.NewCompUtil;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.IMerlinGeomSrc;
import ventus.util.MerlinUtil;

public class FloorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return FloorComposite.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(VentusData md, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObj);
    }

    private void transformPasteObjs(VentusApp app, VentusData md, Collection<? extends ISchematicComp> geomObjs, Consumer<? super IDomainObject> allPastedObjs, TransformInfo xform) {
        LinkedIdentityHashSet<SchematicRoom> subtractors = new LinkedIdentityHashSet<SchematicRoom>();
        for (IMerlinGeomSrc obj : TransformAction.getGeom(md, geomObjs)) {
            obj.transform(xform);
            if (!(obj instanceof SchematicRoom)) continue;
            SchematicRoom room = (SchematicRoom)obj;
            subtractors.add(room);
        }
        NewCompUtil.addSchematicComps(md, false, geomObjs);
        int subtractOptions = TransformAction.getSubtractOptions(xform);
        ArrayList toClean = new ArrayList();
        IdentityHashMap separatedRooms = new IdentityHashMap();
        SubtractAction.subtract(app, md, subtractOptions, toClean::add, (inputRoom, resultingRoom) -> {
            if (subtractors.contains(inputRoom)) {
                separatedRooms.computeIfAbsent(inputRoom, r -> new ArrayList()).add(resultingRoom);
            }
        }, subtractors);
        SchematicRoom.cleanup(md, toClean);
        for (ISchematicComp iSchematicComp : geomObjs) {
            List separated = (List)separatedRooms.get(iSchematicComp);
            if (separated == null) {
                allPastedObjs.accept(iSchematicComp);
                continue;
            }
            separated.forEach(allPastedObjs);
        }
    }

    @Override
    public void pasteApply(VentusData md, VentusApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        LinkedHashMap<ITransform, List> transformEntries = new LinkedHashMap<ITransform, List>();
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            transformEntries.computeIfAbsent(pasteEntry.hints().geomTransform.xform, xform -> new ArrayList()).add(pasteEntry);
        }
        for (Map.Entry entry : transformEntries.entrySet()) {
            Collection<ISchematicComp> geomObjs = MerlinUtil.flatten(theUtil.map((List)entry.getValue(), e -> e.pasteObj()), ISchematicComp.class);
            this.transformPasteObjs(app, md, geomObjs, allPastedObjs, ((ITransform)entry.getKey()).getInfo());
        }
    }
}

