/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.FileFilters;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.data.camera.Camera;
import ventus.data.camera.ICameraObj;
import ventus.gui.guiUtil;
import ventus.io.FileUtil;

public class WriteViews
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteViews(), Intl.intl("Save Views File...,-,Update the 3D Results Views file"));

    @Override
    public void run(VentusApp app, VentusData md) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(md.getNewFilename(FileUtil.Types.VIEWS), MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_JSON);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        WriteViews.writeInputFile(app, md, f.getAbsolutePath());
    }

    public static boolean writeInputFile(VentusApp app, VentusData md, String fn) {
        try {
            WriteViews.writeInputFile(md, fn);
            return true;
        }
        catch (IOException e) {
            guiUtil.showError(app, Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), fn), (Throwable)e);
            return false;
        }
    }

    public static void writeInputFile(VentusData md, String fn) throws IOException {
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(fn);){
            JSONArray objects = new JSONArray();
            for (ICameraObj obj : md.cameras.flatten(ICameraObj.class)) {
                if (!(obj instanceof Camera)) continue;
                Camera camera = (Camera)obj;
                objects.add(WriteViews.toJSON(camera));
            }
            String text = objects.toJSONString();
            fWrite.println(text);
        }
    }

    public static JSONObject toJSON(Camera view) {
        JSONObject obj = new JSONObject();
        obj.put("type", "camera_view");
        obj.put("name", view.getName());
        CameraRecord cr = view.getCameraState();
        JSONObject state = WriteViews.toJSON(cr);
        obj.put("state", state);
        return obj;
    }

    private static JSONObject toJSON(CameraRecord cr) {
        JSONObject jsnode = new JSONObject();
        jsnode.put("loc", WriteViews.toArray(cr.loc));
        jsnode.put("ref", WriteViews.toArray(cr.ref));
        jsnode.put("up", WriteViews.toArray(cr.up));
        jsnode.put("zoom", cr.zoom);
        jsnode.put("zoomloc", WriteViews.toArray(cr.zoomLoc));
        jsnode.put("near", cr.near);
        jsnode.put("far", cr.far);
        if (cr.frustum instanceof PerspectiveCamera.FrustumRecord) {
            PerspectiveCamera.FrustumRecord pfr = (PerspectiveCamera.FrustumRecord)cr.frustum;
            jsnode.put("fov", pfr.fov);
        } else {
            jsnode.put("fov", Math.toRadians(45.0));
        }
        return jsnode;
    }

    private static JSONArray toArray(Tuple3d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        arr.add(t.z);
        return arr;
    }

    private static JSONArray toArray(Tuple2d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        return arr;
    }
}

