/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinBoolAction;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.unitsystem.EnglishUS;
import ventus.unitsystem.SIUS;
import ventus.unitsystem.UnitSystem;

public class UnitsAction
extends AMerlinBoolAction {
    private static final long serialVersionUID = 1664063778508194962L;
    public static final Icon ICON_EN = UIHook.loadIcon("ventus/icons/en16.png");
    public static final Icon ICON_SI = UIHook.loadIcon("ventus/icons/si16.png");
    public static final UnitsAction SI_ACTION = new UnitsAction(SIUS.getInstance(), Intl.intl("SI"), ICON_SI);
    public static final UnitsAction ENGLISH_ACTION = new UnitsAction(EnglishUS.getInstance(), Intl.intl("English"), ICON_EN);
    private static final Semaphore d_lock = new Semaphore(1);
    private static final IEventObserver s_actionUpdator = new IEventObserver(){

        @Override
        public void update(Events events) {
            for (EventChannel<VentusData> channel : events.getAffectedChannels(VentusData.class, new Class[0])) {
                if (!channel.hasChangedObjs(VentusData.UNITSYSTEM_CHANGED)) continue;
                if (!d_lock.tryAcquire()) {
                    return;
                }
                VentusApp app = VentusApp.getApp();
                if (app.getUnitSystem() == SIUS.getInstance()) {
                    SI_ACTION.setSelected(true);
                } else {
                    ENGLISH_ACTION.setSelected(true);
                }
                d_lock.release();
                break;
            }
        }
    };
    public UnitSystem d_unitSys;

    public UnitsAction(UnitSystem unitSystem, String menuStr, Icon ico) {
        super(menuStr, VentusApp.getApp().getData().getUnitSystem() == unitSystem, ico);
        this.putValue("ShortDescription", String.format(Intl.intl("Show values in %s units"), unitSystem.getSystemName()));
        this.d_unitSys = unitSystem;
    }

    @Override
    protected void stateChanged() {
        if (!d_lock.tryAcquire()) {
            return;
        }
        super.stateChanged();
        d_lock.release();
    }

    @Override
    protected void work(VentusData data, boolean selected) {
        if (selected) {
            VentusApp.getApp().getData().setUnitSystem(this.d_unitSys);
            VentusApp.getApp().getPrefs().set(MerlinPrefs.KEY_UNITSYSTEM_PROP, this.d_unitSys.getSystemName());
        }
    }

    static {
        VentusApp.getApp().getData().getEvents().addObserver(s_actionUpdator);
    }
}

