/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Window;
import java.util.Set;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.VentusObjsList;
import ventus.util.Dependencies;

public class ShowReferencingObjects
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ShowReferencingObjects(), Intl.intl("Show Referencing Objects..."));

    public ShowReferencingObjects() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    public static Set<IMerlinObj> getReferencing(VentusData md) {
        LinkedIdentityHashSet<IMerlinObj> referencing = new LinkedIdentityHashSet<IMerlinObj>();
        Dependencies.getObjReferences(md, Predicates.alwaysTrue(), obj -> md.selection.isSelected(obj), (src, link, target) -> {
            if (link != null && link != DLink.CONTAINED_BY && EntryPointFactory.get(src).canShowInReferencingLists(md, (IMerlinObj)src)) {
                referencing.add(src);
            }
        });
        return referencing;
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        Set<IMerlinObj> referencing = ShowReferencingObjects.getReferencing(vd);
        ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>((Window)app.getActiveFrame(), Intl.intl("Show Referencing Objects"), new VentusObjsList(vd, Intl.intl("Select Referencing Objects"), true, true, referencing));
        dlg.doModeless();
    }

    @Override
    public void update(Events events) {
        VentusData vd = VentusApp.getApp().getData();
        this.setEnabled(!vd.selection.isDeepEmpty(IMerlinObj.class));
    }
}

